/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.TaxClassificationCodeImport;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeSourceType;
import com.kingdee.eas.tm.im.app.AbstractTaxClassificationCodeControllerBean;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaxClassificationCodeControllerBean
extends AbstractTaxClassificationCodeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.TaxClassificationCodeControllerBean");

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TaxClassificationCodeInfo info = (TaxClassificationCodeInfo)this.getValue(ctx, pk);
        IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"3A2CC8F7"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_taxClassificationCode_delete", ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
        this.checkReferences(ctx, pk, info.getNumber());
        super._delete(ctx, pk);
        LogUtils.afterLog(ctx, logPk);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UserInfo userInfo = this.getUserInfo(ctx);
        ObjectBaseInfo objectBaseInfo = null;
        objectBaseInfo = (ObjectBaseInfo)model;
        Timestamp createtime = this.getTime();
        objectBaseInfo.setLastUpdateUser(userInfo);
        objectBaseInfo.setLastUpdateTime(createtime);
        this.innerUpdate(ctx, pk, model);
    }

    private UserInfo getUserInfo(Context ctx) throws BOSException {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        return userInfo;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private void checkReferences(Context ctx, IObjectPK pk, String number) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String id = pk.toString();
        sql.append("select 1 from T_IM_TaxClassificationCode where FSourceType !='").append(TaxClassificationCodeSourceType.ExcelImport.getValue()).append("' and fparentid = '").append(id).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new IMException(IMException.TAXCLASSIFICATIONCODEDELETE_EXCELIMPORT, new Object[]{number});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append("select 1 from T_IM_TaxClassificationCode where fparentid = '").append(id).append("'");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new IMException(IMException.NONLEAFNODENOTDELETE, new Object[]{number});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        int i;
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> successIDs = new ArrayList<String>();
        for (i = 0; i < ids.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids.get(i).toString());
            try {
                StringBuffer sql = new StringBuffer();
                String number = null;
                sql.append("select FNumber from T_IM_TaxClassificationCode where FID='").append(pk.toString()).append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                try {
                    if (rs.next()) {
                        number = rs.getString("FNumber");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                IObjectPK logPk = LogUtils.beginLog(ctx, "delete", BOSObjectType.create((String)"3A2CC8F7"), (IObjectPK)new ObjectUuidPK(pk.toString()), number, "im_taxClassificationCode_delete", ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
                this.checkReferences(ctx, (IObjectPK)pk, number);
                LogUtils.afterLog(ctx, logPk);
                successIDs.add(pk.toString());
                continue;
            }
            catch (Exception e) {
                errors.add(e.getMessage());
            }
        }
        for (i = 0; i < successIDs.size(); ++i) {
            super._delete(ctx, (IObjectPK)new ObjectUuidPK(successIDs.get(i).toString()));
        }
        return errors;
    }

    @Override
    protected void _importComplete(Context ctx) throws BOSException, EASBizException {
        TaxClassificationCodeImport taxClassificationCodeImport = new TaxClassificationCodeImport();
        try {
            taxClassificationCodeImport.solutionOnFinished(ctx);
        }
        catch (TaskExternalException e) {
            throw new BOSException(e.getMessage());
        }
    }

    @Override
    public IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }
}

