/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.BillBaseCollection;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.IBillBase;
import com.kingdee.eas.tm.common.app.service.BillVoucherService;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.common.invoicePool.ConfirmStateEnum;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.ITaxTransfer;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.TaxTransferEntryCollection;
import com.kingdee.eas.tm.im.TaxTransferEntryInfo;
import com.kingdee.eas.tm.im.TaxTransferFactory;
import com.kingdee.eas.tm.im.TaxTransferInfo;
import com.kingdee.eas.tm.im.TaxTransferInvoiceType;
import com.kingdee.eas.tm.im.app.AbstractTaxTransferControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxTransferControllerBean
extends AbstractTaxTransferControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.TaxTransferControllerBean");
    private static final String INCOMEINVOICE_BOSTYPE = "1343913D";
    private static final String TOLLINVOICE_BOSTYPE = "0329A272";
    private static final String VEHICLEINVOICE_BOSTYPE = "8F9D8961";
    private static final String FULLSPECIALINVOICE_BOSTYPE = "AF83503C";
    private static final String TAXTRANSFER_BOSTYPE = "573282EF";

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        this.traceUpAndDown(ctx, model);
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxTransferInfo taxTransferInfo = (TaxTransferInfo)model;
        taxTransferInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.checkBeforeSubmit(ctx, taxTransferInfo);
        super._checkNumberDup(ctx, null, model);
        IObjectPK pk = super._save(ctx, (IObjectValue)taxTransferInfo);
        this.deleteBotpRelations(ctx, model);
        this.traceUpAndDown(ctx, model);
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxTransferInfo taxTransferInfo = null;
        taxTransferInfo = model == null ? TaxTransferFactory.getLocalInstance(ctx).getTaxTransferInfo(pk) : (TaxTransferInfo)model;
        this._submit(ctx, (IObjectValue)taxTransferInfo);
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        if (model.getString(model.getPKField()) == null) {
            model.setString(model.getPKField(), BOSUuid.create((String)model.getBOSType().toString()).toString());
        }
        ObjectUuidPK pk = new ObjectUuidPK(model.getString(model.getPKField()));
        this.submit(ctx, (IObjectPK)pk, model);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxTransferInfo taxTransferInfo = (TaxTransferInfo)model;
        this.checkBeforeSubmit(ctx, taxTransferInfo);
        taxTransferInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        super._checkNumberDup(ctx, null, (IObjectValue)taxTransferInfo);
        taxTransferInfo.setStatus(InvoiceBillStatus.SUBMITED);
        IObjectPK pk = super._submit(ctx, model);
        this.deleteBotpRelations(ctx, model);
        this.traceUpAndDown(ctx, (IObjectValue)taxTransferInfo);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null && !this._exists(ctx, pk)) {
            return;
        }
        TaxTransferInfo taxTransferInfo = TaxTransferFactory.getLocalInstance(ctx).getTaxTransferInfo(pk);
        this.checkBeforeDelete(ctx, taxTransferInfo);
        this.recycleNumber(ctx, pk, taxTransferInfo);
        this.deleteBotpRelations(ctx, (IObjectValue)taxTransferInfo);
        super._delete(ctx, pk);
    }

    private void recycleNumber(Context ctx, IObjectPK pk, TaxTransferInfo info) throws EASBizException, BOSException {
        if (info == null || info.getNumber() == null || info.getCompany() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            info = TaxTransferFactory.getLocalInstance(ctx).getTaxTransferInfo(pk, sic);
        }
        if (info.getNumber() != null) {
            String companyID = info.getCompany().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, info.getNumber());
            }
        }
    }

    public void checkBeforeDelete(Context ctx, TaxTransferInfo taxTransferInfo) throws BOSException, EASBizException {
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(taxTransferInfo.getCompany().getId().toString(), "im_taxTransfer_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (!InvoiceBillStatus.TEMPSTROE.equals((Object)taxTransferInfo.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)taxTransferInfo.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "STATUSDELETE", new String[0])});
        }
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        TaxTransferInfo taxTransferInfo = TaxTransferFactory.getLocalInstance(ctx).getTaxTransferInfo(pk);
        this.checkBeforeAudit(ctx, taxTransferInfo);
        taxTransferInfo.setStatus(InvoiceBillStatus.AUDITED);
        taxTransferInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        taxTransferInfo.setAudittime(new Timestamp(System.currentTimeMillis()));
        if (taxTransferInfo.getId() == null) {
            throw new BillBaseException(BillBaseException.NOEXIST);
        }
        super.update(ctx, pk, taxTransferInfo);
        this.writeBill(ctx, (IObjectValue)taxTransferInfo, 0);
    }

    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        TaxTransferInfo infoWithVoucher = TaxTransferFactory.getLocalInstance(ctx).getTaxTransferInfo(pk);
        TaxTransferInfo taxTransferInfo = null;
        taxTransferInfo = model == null ? infoWithVoucher : (TaxTransferInfo)model;
        taxTransferInfo.setFiVouchered(infoWithVoucher.isFiVouchered());
        this.checkBeforeUnAudit(ctx, taxTransferInfo);
        taxTransferInfo.setStatus(InvoiceBillStatus.TEMPSTROE);
        taxTransferInfo.setAuditor(null);
        taxTransferInfo.setAudittime(null);
        if (taxTransferInfo.getId() == null) {
            throw new BillBaseException(BillBaseException.NOEXIST);
        }
        super.update(ctx, pk, taxTransferInfo);
        this.writeBill(ctx, (IObjectValue)taxTransferInfo, 1);
    }

    public void checkBeforeSubmit(Context ctx, TaxTransferInfo taxTransferInfo) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (taxTransferInfo == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        if (taxTransferInfo.getStatus() != null && !InvoiceBillStatus.TEMPSTROE.equals((Object)taxTransferInfo.getStatus()) && !InvoiceBillStatus.SUBMITED.equals((Object)taxTransferInfo.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "STATUSNETEMPSTORE", new String[0])).append(";");
        }
        if (taxTransferInfo.getCompany() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])).append(";\r\n");
        }
        if (!StringUtils.isEmpty((String)taxTransferInfo.getNumber())) {
            String msg = this.isSameNumber(ctx, taxTransferInfo);
            if (!StringUtils.isEmpty((String)msg)) {
                errorMsg.append(msg).append(";\r\n");
            }
        } else {
            String number = this.getNumer(ctx, taxTransferInfo);
            if (StringUtils.isEmpty((String)number)) {
                errorMsg.append(IMUtils.getIMResource(ctx, "BILLNUMBER", new String[0])).append(";\r\n");
            } else {
                taxTransferInfo.setNumber(number);
            }
        }
        if (taxTransferInfo.getTransferDate() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TRANSFERDATE", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTaxPeriod() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TAXPERIOD_NULL", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTotalTaxAmount() == null || taxTransferInfo.getTotalTaxAmount().compareTo(BigDecimal.ZERO) < 1) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TOTALTAXAMOUNT_NULL", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTaxTransferItem() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TAXTRANSFERITEM_NULL", new String[0])).append(";\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        TaxTransferEntryCollection taxTransferColl = taxTransferInfo.getEntries();
        errorMsg.setLength(0);
        for (int i = 0; i < taxTransferColl.size(); ++i) {
            TaxTransferEntryInfo entryInfo = taxTransferColl.get(i);
            if (entryInfo.getTaxTransferInvoiceType() != null) continue;
            errorMsg.append(IMUtils.getIMResource(ctx, "INVOICETYPE_NOT_NULL", i + 1 + "")).append(";\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
        this.checkAmountAndState(ctx, taxTransferInfo);
    }

    private String getNumer(Context ctx, TaxTransferInfo caller) throws BOSException, EASBizException {
        ITaxTransfer iBillBase = TaxTransferFactory.getLocalInstance(ctx);
        String strCompanyID = caller.getCompany() != null && caller.getCompany().getId() != null ? caller.getCompany().getId().toString() : ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String number = (String)caller.get("number");
        caller.setCU(CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,CU.id,CU.number,CU.name where id='" + strCompanyID + "'").getCU());
        int maxCycleNum = 100;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyID, CompareType.EQUALS));
        if (caller.get("id") != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", caller.get("id"), CompareType.EQUALS));
        }
        while (number == null || number.equals("") || iBillBase.exists(filter)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            CodingRuleInfo ruleInfo = iCodingRuleManager.getCodingRule((IObjectValue)caller, strCompanyID);
            number = iCodingRuleManager.getNumber((IObjectValue)caller, ruleInfo);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)strCompanyID, CompareType.EQUALS));
            if (caller.get("id") == null) continue;
            filter.getFilterItems().add(new FilterItemInfo("id", caller.get("id"), CompareType.EQUALS));
        }
        return number;
    }

    private String isSameNumber(Context ctx, TaxTransferInfo taxTransferInfo) throws EASBizException, BOSException {
        String msg = "";
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)taxTransferInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (taxTransferInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)taxTransferInfo.getId().toString(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)taxTransferInfo).getCU() != null) {
            filterItem = new FilterItemInfo("CU", (Object)this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)taxTransferInfo).getCU().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("CU", null, CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (taxTransferInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)taxTransferInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        int size = filter.getFilterItems().size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            msg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"Number_Exists", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{taxTransferInfo.getNumber()});
        }
        return msg;
    }

    private void checkAmountAndState(Context ctx, TaxTransferInfo taxTransferInfo) throws BOSException, EASBizException {
        TaxTransferEntryCollection taxTransferColl = taxTransferInfo.getEntries();
        HashSet<String> specialInvoiceCodes = new HashSet<String>();
        HashSet<String> specialInvoiceNumbers = new HashSet<String>();
        HashSet<String> tollInvoiceCodes = new HashSet<String>();
        HashSet<String> tollInvoiceNumbers = new HashSet<String>();
        HashSet<String> vehicleInvoiceCodes = new HashSet<String>();
        HashSet<String> vehicleInvoiceNumbers = new HashSet<String>();
        HashSet<String> fullSpecInvoiceCodes = new HashSet<String>();
        HashSet<String> fullSpecInvoiceNumbers = new HashSet<String>();
        HashMap<String, BigDecimal> idAndAmountMap = new HashMap<String, BigDecimal>();
        StringBuffer errorMsg = new StringBuffer();
        ArrayList<BillBaseInfo> incomeInvoices = new ArrayList();
        ArrayList<BillBaseInfo> tollInvoices = new ArrayList();
        ArrayList<BillBaseInfo> vehicleInvoices = new ArrayList();
        ArrayList<BillBaseInfo> fullSpecInvoices = new ArrayList();
        BigDecimal entriesAmount = BigDecimal.ZERO;
        String invoiceCode = null;
        String invoiceNumber = null;
        BigDecimal amount = null;
        if (taxTransferColl != null && taxTransferColl.size() > 0) {
            for (int i = 0; i < taxTransferColl.size(); ++i) {
                TaxTransferEntryInfo entryInfo = taxTransferColl.get(i);
                invoiceCode = entryInfo.getInvoiceCode() != null ? entryInfo.getInvoiceCode() : "";
                invoiceNumber = entryInfo.getInvoiceNumber() != null ? entryInfo.getInvoiceNumber() : "";
                this.checkZero(invoiceCode, invoiceNumber, entryInfo, i);
                BigDecimal entryAmount = entryInfo.getAmount() == null ? BigDecimal.ZERO : entryInfo.getAmount();
                entriesAmount = entriesAmount.add(entryAmount);
                String codeAndNumber = invoiceCode + "_" + invoiceNumber;
                amount = (BigDecimal)idAndAmountMap.get(codeAndNumber);
                if (null == amount) {
                    amount = entryInfo.getAmount() == null ? BigDecimal.ZERO : entryInfo.getAmount();
                    idAndAmountMap.put(codeAndNumber, amount);
                } else {
                    amount = amount.add(entryInfo.getAmount() == null ? BigDecimal.ZERO : entryInfo.getAmount());
                    idAndAmountMap.put(codeAndNumber, amount);
                }
                if (TaxTransferInvoiceType.INVOICETYPE_SPECIAL_PAPER.equals((Object)entryInfo.getTaxTransferInvoiceType()) || TaxTransferInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (!IMUtils.isEmpty(invoiceCode)) {
                        specialInvoiceCodes.add(invoiceCode);
                    }
                    if (IMUtils.isEmpty(invoiceNumber)) continue;
                    specialInvoiceNumbers.add(invoiceNumber);
                    continue;
                }
                if (TaxTransferInvoiceType.INVOICETYPE_TOLL.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (!IMUtils.isEmpty(invoiceCode)) {
                        tollInvoiceCodes.add(invoiceCode);
                    }
                    if (IMUtils.isEmpty(invoiceNumber)) continue;
                    tollInvoiceNumbers.add(invoiceNumber);
                    continue;
                }
                if (TaxTransferInvoiceType.INVOICETYPE_USEDCAR.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (!IMUtils.isEmpty(invoiceCode)) {
                        vehicleInvoiceCodes.add(invoiceCode);
                    }
                    if (IMUtils.isEmpty(invoiceNumber)) continue;
                    vehicleInvoiceNumbers.add(invoiceNumber);
                    continue;
                }
                if (!TaxTransferInvoiceType.INVOICETYPE_FULL_ELECTRONIC_SPECIAL.equals((Object)entryInfo.getTaxTransferInvoiceType())) continue;
                if (!IMUtils.isEmpty(invoiceCode)) {
                    fullSpecInvoiceCodes.add(invoiceCode);
                }
                if (IMUtils.isEmpty(invoiceNumber)) continue;
                fullSpecInvoiceNumbers.add(invoiceNumber);
            }
        }
        if (entriesAmount.compareTo(taxTransferInfo.getTotalTaxAmount()) != 0) {
            throw new IMException(IMException.ENTRIES_AMOUNT_CHECK, new Object[]{taxTransferInfo.getNumber()});
        }
        incomeInvoices = this.getBillInvoices(ctx, taxTransferInfo, specialInvoiceCodes, specialInvoiceNumbers, INCOMEINVOICE_BOSTYPE);
        tollInvoices = this.getBillInvoices(ctx, taxTransferInfo, tollInvoiceCodes, tollInvoiceNumbers, TOLLINVOICE_BOSTYPE);
        vehicleInvoices = this.getBillInvoices(ctx, taxTransferInfo, vehicleInvoiceCodes, vehicleInvoiceNumbers, VEHICLEINVOICE_BOSTYPE);
        fullSpecInvoices = this.getBillInvoices(ctx, taxTransferInfo, fullSpecInvoiceCodes, fullSpecInvoiceNumbers, FULLSPECIALINVOICE_BOSTYPE);
        this.checkAmountAndState(ctx, incomeInvoices, idAndAmountMap, INCOMEINVOICE_BOSTYPE, errorMsg);
        this.checkAmountAndState(ctx, tollInvoices, idAndAmountMap, TOLLINVOICE_BOSTYPE, errorMsg);
        this.checkAmountAndState(ctx, vehicleInvoices, idAndAmountMap, VEHICLEINVOICE_BOSTYPE, errorMsg);
        this.checkAmountAndState(ctx, fullSpecInvoices, idAndAmountMap, FULLSPECIALINVOICE_BOSTYPE, errorMsg);
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    private void checkAmountAndState(Context ctx, ArrayList<BillBaseInfo> invoices, Map<String, BigDecimal> idAndAmountMap, String bosType, StringBuffer errorMsg) {
        String invoiceCode = "invoiceCode";
        String invoiceNumber = "invoiceNumber";
        String tax = "tax";
        String transferTaxAmt = "transferTaxAmt";
        String unTransferTaxAmt = "unTransferTaxAmt";
        if (TOLLINVOICE_BOSTYPE.equals(bosType) || VEHICLEINVOICE_BOSTYPE.equals(bosType) || FULLSPECIALINVOICE_BOSTYPE.equals(bosType)) {
            invoiceNumber = "invoiceNo";
            tax = "totalTaxAmount";
        }
        boolean isShowMsg = false;
        BillBaseInfo billBaseInfo = null;
        BigDecimal amount = null;
        BigDecimal canUseTax = null;
        String msg = "";
        for (int i = 0; i < invoices.size(); ++i) {
            BigDecimal taxAmt;
            String confirmAndTypeMsg = "";
            String unTransferTaxAmtMsg = "";
            billBaseInfo = invoices.get(i);
            amount = idAndAmountMap.get((billBaseInfo.get(invoiceCode) != null ? billBaseInfo.get(invoiceCode) : "") + "_" + billBaseInfo.get(invoiceNumber));
            BigDecimal bigDecimal = taxAmt = null == billBaseInfo.getBigDecimal(transferTaxAmt) ? BigDecimal.ZERO : billBaseInfo.getBigDecimal(transferTaxAmt);
            if (billBaseInfo.getBigDecimal(unTransferTaxAmt) != null) {
                if (amount.add(taxAmt).compareTo(billBaseInfo.getBigDecimal(unTransferTaxAmt)) > 0) {
                    canUseTax = billBaseInfo.getBigDecimal(unTransferTaxAmt).subtract(taxAmt);
                }
            } else if (billBaseInfo.getBigDecimal(tax) != null && amount.add(taxAmt).compareTo(billBaseInfo.getBigDecimal(tax)) > 0) {
                canUseTax = billBaseInfo.getBigDecimal(tax).subtract(taxAmt);
            }
            if (canUseTax != null) {
                unTransferTaxAmtMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"TransferAmtLeft", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{canUseTax.setScale(2, 4)}) + ",";
                canUseTax = null;
                isShowMsg = true;
            }
            if (INCOMEINVOICE_BOSTYPE.equals(bosType)) {
                if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)PayInvoiceTypeEnum.getEnum((String)billBaseInfo.getString("invoiceType"))) && PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)PayInvoiceTypeEnum.getEnum((String)billBaseInfo.getString("invoiceType"))) && billBaseInfo.get("checkAbs") != null && !ConfirmStateEnum.Confirmed.equals((Object)((CheckAbsInfo)billBaseInfo.get("checkAbs")).getConfirmState())) {
                    confirmAndTypeMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"InvNotConfirmAndTaxInv", (Locale)ctx.getOriginLocale()) + ",";
                    isShowMsg = true;
                }
            } else if ((TOLLINVOICE_BOSTYPE.equals(bosType) || VEHICLEINVOICE_BOSTYPE.equals(bosType) || FULLSPECIALINVOICE_BOSTYPE.equals(bosType)) && billBaseInfo.get("checkAbs") != null && !ConfirmStateEnum.Confirmed.equals((Object)((CheckAbsInfo)billBaseInfo.get("checkAbs")).getConfirmState())) {
                confirmAndTypeMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"InvNotConfirmAndTaxInv", (Locale)ctx.getOriginLocale()) + ",";
                isShowMsg = true;
            }
            if (!isShowMsg) continue;
            msg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"INVOICENO", (Locale)ctx.getOriginLocale()) + "\uff1a" + billBaseInfo.get(invoiceNumber) + "  " + confirmAndTypeMsg + unTransferTaxAmtMsg;
            errorMsg.append(msg);
            errorMsg.append("\r\n");
            isShowMsg = false;
        }
    }

    private ArrayList<BillBaseInfo> getBillInvoices(Context ctx, TaxTransferInfo taxTransferInfo, Set<String> invoiceCodes, Set<String> invoiceNumbers, String bosType) throws BOSException, EASBizException {
        ArrayList<BillBaseInfo> billInvoices = new ArrayList<BillBaseInfo>();
        BillBaseInfo srcInfo = null;
        TaxTransferEntryCollection taxTransferColl = taxTransferInfo.getEntries();
        String invoiceCode = "invoiceCode";
        String invoiceNumber = "invoiceNumber";
        if (TOLLINVOICE_BOSTYPE.equals(bosType) || VEHICLEINVOICE_BOSTYPE.equals(bosType) || FULLSPECIALINVOICE_BOSTYPE.equals(bosType)) {
            invoiceNumber = "invoiceNo";
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (invoiceCodes.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(invoiceCode, invoiceCodes, CompareType.INCLUDE));
        }
        if (invoiceNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(invoiceNumber, invoiceNumbers, CompareType.INCLUDE));
        }
        if (invoiceCodes.size() == 0 && invoiceNumbers.size() == 0) {
            return billInvoices;
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("checkAbs.*"));
        viewInfo.setSelector(sic);
        BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosObjectType);
        BillBaseCollection billBaseCollection = iBillBase.getBillBaseCollection(viewInfo);
        if (billBaseCollection != null && billBaseCollection.size() > 0) {
            block0: for (int i = 0; i < billBaseCollection.size(); ++i) {
                srcInfo = billBaseCollection.get(i);
                for (int j = 0; j < taxTransferColl.size(); ++j) {
                    TaxTransferEntryInfo entryInfo = taxTransferColl.get(j);
                    if (!this.emptyIsNull(srcInfo.get(invoiceCode), false).equals(this.emptyIsNull(entryInfo.getInvoiceCode(), false)) || !this.emptyIsNull(srcInfo.get(invoiceNumber), false).equals(this.emptyIsNull(entryInfo.getInvoiceNumber(), false))) continue;
                    billInvoices.add(srcInfo);
                    continue block0;
                }
            }
        }
        return billInvoices;
    }

    private void checkZero(String invoiceCode, String invoiceNumber, TaxTransferEntryInfo entry, int i) throws IMException {
        if (!StringUtils.isEmpty((String)invoiceCode) && !StringUtils.isEmpty((String)invoiceNumber)) {
            this.checkZero(entry, i);
        } else if (this.isMoreThanTwoFilled(entry)) {
            this.checkZero(entry, i);
        }
    }

    private void checkZero(TaxTransferEntryInfo entry, int i) throws IMException {
        if (entry.getTax() == null || BigDecimal.ZERO.compareTo(entry.getTax()) == 0) {
            throw new IMException(IMException.ZERO_CHECK, new Object[]{i + 1});
        }
        if (entry.getProportion() == null || BigDecimal.ZERO.compareTo(entry.getProportion()) == 0) {
            throw new IMException(IMException.ZERO_CHECK, new Object[]{i + 1});
        }
        if (entry.getAmount() == null || BigDecimal.ZERO.compareTo(entry.getAmount()) == 0) {
            throw new IMException(IMException.ZERO_CHECK, new Object[]{i + 1});
        }
    }

    private boolean isMoreThanTwoFilled(TaxTransferEntryInfo entry) {
        BigDecimal tax = entry.getTax();
        BigDecimal proportion = entry.getProportion();
        BigDecimal amount = entry.getAmount();
        return tax != null && proportion != null || tax != null && amount != null || proportion != null && amount != null;
    }

    public void checkBeforeAudit(Context ctx, TaxTransferInfo taxTransferInfo) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (taxTransferInfo == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        if (!InvoiceBillStatus.SUBMITED.equals((Object)taxTransferInfo.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "SUBMITEDAUTIT", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getCompany() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getNumber() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "BILLNUMBER", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTransferDate() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TRANSFERDATE", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTaxPeriod() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TAXPERIOD_NULL", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTotalTaxAmount() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TOTALTAXAMOUNT_NULL", new String[0])).append(";\r\n");
        }
        if (taxTransferInfo.getTaxTransferItem() == null) {
            errorMsg.append(IMUtils.getIMResource(ctx, "TAXTRANSFERITEM_NULL", new String[0])).append(";\r\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    public void checkBeforeUnAudit(Context ctx, TaxTransferInfo taxTransferInfo) throws BOSException, EASBizException {
        StringBuffer errorMsg = new StringBuffer();
        if (taxTransferInfo == null) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "ENTITYISNULL", new String[0])});
        }
        if (!InvoiceBillStatus.AUDITED.equals((Object)taxTransferInfo.getStatus())) {
            errorMsg.append(IMUtils.getIMResource(ctx, "AUDITEDUNAUTIT", new String[0])).append(";");
        }
        if (taxTransferInfo.isFiVouchered()) {
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "HasVoucher_NotUnAudit", ctx.getLocale())).append(";");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    private void traceUpAndDown(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxTransferInfo taxTransferInfo = (TaxTransferInfo)model;
        TaxTransferEntryCollection taxTransferColl = taxTransferInfo.getEntries();
        HashSet<String> specialInvoiceCodes = new HashSet<String>();
        HashSet<String> specialInvoiceNumbers = new HashSet<String>();
        HashSet<String> tollInvoiceCodes = new HashSet<String>();
        HashSet<String> tollInvoiceNumbers = new HashSet<String>();
        HashSet<String> vehicleInvoiceCodes = new HashSet<String>();
        HashSet<String> vehicleInvoiceNumbers = new HashSet<String>();
        HashSet<String> fullSpecInvoiceCodes = new HashSet<String>();
        HashSet<String> fullSpecInvoiceNumbers = new HashSet<String>();
        String invoiceCode = null;
        String invoiceNumber = null;
        if (taxTransferColl != null && taxTransferColl.size() > 0) {
            for (int i = 0; i < taxTransferColl.size(); ++i) {
                TaxTransferEntryInfo entryInfo = taxTransferColl.get(i);
                invoiceCode = entryInfo.getInvoiceCode() != null ? entryInfo.getInvoiceCode() : "";
                String string = invoiceNumber = entryInfo.getInvoiceNumber() != null ? entryInfo.getInvoiceNumber() : "";
                if (TaxTransferInvoiceType.INVOICETYPE_SPECIAL_PAPER.equals((Object)entryInfo.getTaxTransferInvoiceType()) || TaxTransferInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (!IMUtils.isEmpty(invoiceCode)) {
                        specialInvoiceCodes.add(invoiceCode);
                    }
                    if (IMUtils.isEmpty(invoiceNumber)) continue;
                    specialInvoiceNumbers.add(invoiceNumber);
                    continue;
                }
                if (TaxTransferInvoiceType.INVOICETYPE_TOLL.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (!IMUtils.isEmpty(invoiceCode)) {
                        tollInvoiceCodes.add(invoiceCode);
                    }
                    if (IMUtils.isEmpty(invoiceNumber)) continue;
                    tollInvoiceNumbers.add(invoiceNumber);
                    continue;
                }
                if (TaxTransferInvoiceType.INVOICETYPE_USEDCAR.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (!IMUtils.isEmpty(invoiceCode)) {
                        vehicleInvoiceCodes.add(invoiceCode);
                    }
                    if (IMUtils.isEmpty(invoiceNumber)) continue;
                    vehicleInvoiceNumbers.add(invoiceNumber);
                    continue;
                }
                if (!TaxTransferInvoiceType.INVOICETYPE_FULL_ELECTRONIC_SPECIAL.equals((Object)entryInfo.getTaxTransferInvoiceType())) continue;
                if (!IMUtils.isEmpty(invoiceCode)) {
                    fullSpecInvoiceCodes.add(invoiceCode);
                }
                if (IMUtils.isEmpty(invoiceNumber)) continue;
                fullSpecInvoiceNumbers.add(invoiceNumber);
            }
            this.buildBotpRelations(ctx, taxTransferInfo, specialInvoiceCodes, specialInvoiceNumbers, INCOMEINVOICE_BOSTYPE);
            this.buildBotpRelations(ctx, taxTransferInfo, tollInvoiceCodes, tollInvoiceNumbers, TOLLINVOICE_BOSTYPE);
            this.buildBotpRelations(ctx, taxTransferInfo, vehicleInvoiceCodes, vehicleInvoiceNumbers, VEHICLEINVOICE_BOSTYPE);
            this.buildBotpRelations(ctx, taxTransferInfo, fullSpecInvoiceCodes, fullSpecInvoiceNumbers, FULLSPECIALINVOICE_BOSTYPE);
        }
    }

    private void buildBotpRelations(Context ctx, TaxTransferInfo taxTransferInfo, Set<String> invoiceCodes, Set<String> invoiceNumbers, String bosType) throws BOSException, EASBizException {
        BillBaseInfo srcInfo = null;
        ArrayList<String> srcIds = new ArrayList<String>();
        TaxTransferEntryCollection taxTransferColl = taxTransferInfo.getEntries();
        String invoiceCode = "invoiceCode";
        String invoiceNumber = "invoiceNumber";
        if (TOLLINVOICE_BOSTYPE.equals(bosType) || VEHICLEINVOICE_BOSTYPE.equals(bosType) || FULLSPECIALINVOICE_BOSTYPE.equals(bosType)) {
            invoiceNumber = "invoiceNo";
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (invoiceCodes.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(invoiceCode, invoiceCodes, CompareType.INCLUDE));
        }
        if (invoiceNumbers.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo(invoiceNumber, invoiceNumbers, CompareType.INCLUDE));
        }
        if (invoiceCodes.size() == 0 && invoiceNumbers.size() == 0) {
            return;
        }
        viewInfo.setFilter(filter);
        BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
        IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosObjectType);
        BillBaseCollection billBaseCollection = iBillBase.getBillBaseCollection(viewInfo);
        if (billBaseCollection != null && billBaseCollection.size() > 0) {
            block0: for (int i = 0; i < billBaseCollection.size(); ++i) {
                srcInfo = billBaseCollection.get(i);
                for (int j = 0; j < taxTransferColl.size(); ++j) {
                    TaxTransferEntryInfo entryInfo = taxTransferColl.get(j);
                    if (!this.emptyIsNull(srcInfo.get(invoiceCode), false).equals(this.emptyIsNull(entryInfo.getInvoiceCode(), false)) || !this.emptyIsNull(srcInfo.get(invoiceNumber), false).equals(this.emptyIsNull(entryInfo.getInvoiceNumber(), false))) continue;
                    srcIds.add(srcInfo.getId().toString());
                    continue block0;
                }
            }
            if (srcIds.size() > 0) {
                String insertSql = " INSERT INTO t_bot_relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FisEffected,FType) values(?,?,?,?,?,?,?,?) ";
                Object[][] params = new Object[srcIds.size()][8];
                for (int i = 0; i < srcIds.size(); ++i) {
                    String srcId = (String)srcIds.get(i);
                    params[i][0] = BOSUuid.create((String)"59302EC6").toString();
                    params[i][1] = bosType;
                    params[i][2] = TAXTRANSFER_BOSTYPE;
                    params[i][3] = srcId;
                    params[i][4] = taxTransferInfo.getId().toString();
                    params[i][5] = "taxTransferBill";
                    params[i][6] = 1;
                    params[i][7] = 0;
                }
                DBUtil.executeBatch((Context)ctx, (String)insertSql, (Object[][])params);
            }
        }
    }

    private void deleteBotpRelations(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxTransferInfo taxTransferInfo = (TaxTransferInfo)model;
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM T_BOT_Relation  where FDestObjectID = ? and FOperatorID = ?");
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{taxTransferInfo.getId().toString(), "taxTransferBill"});
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        new BillVoucherService().batchReverseSave(ctx, srcBillPKs, srcBillVOs, bOTBillOperStateEnum, bOTRelationInfos);
    }

    private void writeBill(Context ctx, IObjectValue model, int operation) throws BOSException, EASBizException {
        TaxTransferInfo billInfo = (TaxTransferInfo)model;
        TaxTransferEntryCollection taxTransferEntrys = billInfo.getEntries();
        HashMap<String, TaxTransferEntryInfo> sepcialEntrys = new HashMap<String, TaxTransferEntryInfo>();
        HashMap<String, TaxTransferEntryInfo> tollEntrys = new HashMap<String, TaxTransferEntryInfo>();
        HashMap<String, TaxTransferEntryInfo> vehicleEntrys = new HashMap<String, TaxTransferEntryInfo>();
        HashMap<String, TaxTransferEntryInfo> fullSpecEntrys = new HashMap<String, TaxTransferEntryInfo>();
        StringBuffer errorMsg = new StringBuffer();
        String key = "";
        String invoiceCode = null;
        String invoiceNumber = null;
        if (taxTransferEntrys != null && taxTransferEntrys.size() > 0) {
            for (int i = 0; i < taxTransferEntrys.size(); ++i) {
                TaxTransferEntryInfo entry;
                TaxTransferEntryInfo entryInfo = taxTransferEntrys.get(i);
                TaxTransferEntryInfo entryInfoClone = new TaxTransferEntryInfo();
                entryInfoClone.setInvoiceCode(entryInfo.getInvoiceCode());
                entryInfoClone.setInvoiceNumber(entryInfo.getInvoiceNumber());
                entryInfoClone.setAmount(IMUtils.isNullToZero(entryInfo.getAmount()));
                invoiceCode = entryInfo.getInvoiceCode() != null ? entryInfo.getInvoiceCode() : "";
                invoiceNumber = entryInfo.getInvoiceNumber() != null ? entryInfo.getInvoiceNumber() : "";
                key = invoiceCode + "_" + invoiceNumber;
                if (TaxTransferInvoiceType.INVOICETYPE_SPECIAL_PAPER.equals((Object)entryInfo.getTaxTransferInvoiceType()) || TaxTransferInvoiceType.INVOICETYPE_ELECTRONIC_SPECIAL.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (sepcialEntrys.containsKey(key)) {
                        entry = sepcialEntrys.get(key);
                        entry.setAmount(entry.getAmount().add(entryInfoClone.getAmount()));
                        sepcialEntrys.put(key, entry);
                        continue;
                    }
                    sepcialEntrys.put(key, entryInfoClone);
                    continue;
                }
                if (TaxTransferInvoiceType.INVOICETYPE_TOLL.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (tollEntrys.containsKey(key)) {
                        entry = tollEntrys.get(key);
                        entry.setAmount(entry.getAmount().add(entryInfoClone.getAmount()));
                        tollEntrys.put(key, entry);
                        continue;
                    }
                    tollEntrys.put(key, entryInfoClone);
                    continue;
                }
                if (TaxTransferInvoiceType.INVOICETYPE_USEDCAR.equals((Object)entryInfo.getTaxTransferInvoiceType())) {
                    if (vehicleEntrys.containsKey(key)) {
                        entry = tollEntrys.get(key);
                        entry.setAmount(entry.getAmount().add(entryInfoClone.getAmount()));
                        vehicleEntrys.put(key, entry);
                        continue;
                    }
                    vehicleEntrys.put(key, entryInfoClone);
                    continue;
                }
                if (!TaxTransferInvoiceType.INVOICETYPE_FULL_ELECTRONIC_SPECIAL.equals((Object)entryInfo.getTaxTransferInvoiceType())) continue;
                if (fullSpecEntrys.containsKey(key)) {
                    entry = tollEntrys.get(key);
                    entry.setAmount(entry.getAmount().add(entryInfoClone.getAmount()));
                    fullSpecEntrys.put(key, entry);
                    continue;
                }
                fullSpecEntrys.put(key, entryInfoClone);
            }
            this.writeSrcBill(ctx, billInfo, sepcialEntrys, INCOMEINVOICE_BOSTYPE, operation, errorMsg);
            this.writeSrcBill(ctx, billInfo, tollEntrys, TOLLINVOICE_BOSTYPE, operation, errorMsg);
            this.writeSrcBill(ctx, billInfo, vehicleEntrys, VEHICLEINVOICE_BOSTYPE, operation, errorMsg);
            this.writeSrcBill(ctx, billInfo, fullSpecEntrys, FULLSPECIALINVOICE_BOSTYPE, operation, errorMsg);
            if (errorMsg.length() > 0) {
                throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
            }
        }
    }

    private void writeSrcBill(Context ctx, TaxTransferInfo taxTransferInfo, HashMap<String, TaxTransferEntryInfo> entrys, String bosType, int operation, StringBuffer errorMsg) throws BOSException, EASBizException {
        String key = "";
        String invoiceCode = "invoiceCode";
        String invoiceNumber = "invoiceNumber";
        String table = "T_IM_IncomeInvoice";
        String tax = "tax";
        String transferTaxAmt = "transferTaxAmt";
        String unTransferTaxAmt = "unTransferTaxAmt";
        if (PoolConstant.BOSTYPE_TOLLINVOICE.equals(bosType)) {
            table = "T_TM_TollInvoice";
            invoiceNumber = "invoiceNo";
            tax = "totalTaxAmount";
        } else if (PoolConstant.BOSTYPE_VEHICLEINVOICE.equals(bosType)) {
            table = "T_TM_VehicleInvoice";
            invoiceNumber = "invoiceNo";
            tax = "totalTaxAmount";
        } else if (PoolConstant.BOSTYPE_FULLELECTRICINVOICE.equals(bosType)) {
            table = "T_TM_FullElectricInvoice";
            invoiceNumber = "invoiceNo";
            tax = "totalTaxAmount";
        }
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer rewritesql = new StringBuffer("update " + table + " set FTransferTaxAmt= ? where fid=?");
            stmt = conn.prepareStatement(rewritesql.toString());
            HashSet<String> ids = new HashSet<String>();
            StringBuffer sql = new StringBuffer("select FSRCOBJECTID from T_BOT_Relation where FDESTOBJECTID='" + taxTransferInfo.getId().toString() + "' and FSRCENTITYID='" + bosType + "' and FDESTENTITYID='" + TAXTRANSFER_BOSTYPE + "'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String id = rs.getString("FSRCOBJECTID");
                ids.add(id);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            BOSObjectType bosObjectType = BOSObjectType.create((String)bosType);
            IBillBase iBillBase = (IBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosObjectType);
            BillBaseCollection billBaseCollection = iBillBase.getBillBaseCollection(viewInfo);
            BillBaseInfo billBaseInfo = null;
            for (int j = 0; j < billBaseCollection.size(); ++j) {
                BigDecimal taxAmt;
                billBaseInfo = billBaseCollection.get(j);
                key = (billBaseInfo.get(invoiceCode) != null ? billBaseInfo.get(invoiceCode) : "") + "_" + billBaseInfo.get(invoiceNumber);
                BigDecimal bigDecimal = taxAmt = null == billBaseInfo.getBigDecimal(transferTaxAmt) ? BigDecimal.ZERO : billBaseInfo.getBigDecimal(transferTaxAmt);
                if (entrys.get(key) == null) continue;
                BigDecimal amount = entrys.get(key).getAmount();
                BigDecimal amt = BigDecimal.ZERO;
                amt = operation == 0 ? taxAmt.add(amount) : taxAmt.subtract(amount);
                String msg = "";
                msg = StringUtils.isEmpty((String)billBaseInfo.getString(invoiceCode)) ? ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"CheckTransTaxAmtByNumber", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{billBaseInfo.get(invoiceNumber)}) : ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"CheckTransferTaxAmt", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{billBaseInfo.get(invoiceCode), billBaseInfo.get(invoiceNumber)});
                if (billBaseInfo.getBigDecimal(unTransferTaxAmt) != null) {
                    if (amt.compareTo(billBaseInfo.getBigDecimal(unTransferTaxAmt)) > 0) {
                        errorMsg.append(msg).append("\r\n");
                    }
                } else if (billBaseInfo.getBigDecimal(tax) != null && amt.compareTo(billBaseInfo.getBigDecimal(tax)) > 0) {
                    errorMsg.append(msg).append("\r\n");
                }
                if (errorMsg.length() != 0) continue;
                stmt.setBigDecimal(1, amt);
                stmt.setString(2, billBaseInfo.getId().toString());
                stmt.addBatch();
            }
            if (errorMsg.length() == 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt);
        SQLUtils.cleanup((Connection)conn);
    }

    private Object emptyIsNull(Object obj, boolean flag) {
        if (obj == null) {
            if (flag) {
                return null;
            }
            return "";
        }
        if (obj instanceof String) {
            if (IMUtils.isEmpty((String)obj)) {
                if (flag) {
                    return null;
                }
                return "";
            }
            return obj.toString();
        }
        return obj;
    }
}

