/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.MakeInvoiceReqBillTypeEnum;
import com.kingdee.eas.tm.im.MakeInvoiceReqSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqException;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqFactory;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.app.AbstractUsedCarInvoiceReqControllerBean;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.common.writeback.WriteBackFacadeFactory;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UsedCarInvoiceReqControllerBean
extends AbstractUsedCarInvoiceReqControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.UsedCarInvoiceReqControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)model;
        if (info.getId() != null) {
            this.checkStatusEqualsInDB(ctx, info);
        } else {
            info.setId(BOSUuid.create((String)"0CADF79B"));
        }
        if (info.getStatus() == null) {
            info.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
        }
        if (info.getSrcSystem() == null) {
            info.setSrcSystem(MakeInvoiceReqSrcSystem.MANUAL);
        }
        this.doNumber(ctx, info);
        this.clearTrimInfo(ctx, info);
        this.checkBeforeSave(ctx, info);
        this.synchronousAmt(info);
        this.calTotalFields(info);
        this.dispose(ctx, info, "restore");
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        this.dispose(ctx, info, "save");
        return pk;
    }

    private void checkStatusEqualsInDB(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, IMException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("status"));
        view.setSelector(sic);
        UsedCarInvoiceReqCollection reqInfos = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqCollection(view);
        if (reqInfos.size() == 1 && reqInfos.get(0).getStatus() != null && !reqInfos.get(0).getStatus().equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + " : " + IMUtils.getIMResource(ctx, "BillStatusChange", new String[0])});
        }
    }

    private void addSameCoreBillEntrySeqLock(Context ctx, String id) throws EASBizException, BOSException {
        StringBuffer lockSQL = new StringBuffer();
        lockSQL.append(" update T_IM_UsedCarInvoiceReqEntry set FID = FID where FCoreBillEntryId  in ");
        lockSQL.append(" (SELECT FCoreBillEntryId FROM T_IM_UsedCarInvoiceReqEntry");
        lockSQL.append("  WHERE FParentID = ?)");
        DbUtil.execute((Context)ctx, (String)lockSQL.toString(), (Object[])new Object[]{id});
    }

    protected void dispose(Context ctx, UsedCarInvoiceReqInfo info, String action) throws EASBizException, BOSException {
        if (info == null || info.getId() == null || info.getSourceBillId() == null) {
            return;
        }
        this.addSameCoreBillEntrySeqLock(ctx, info.getId().toString());
        if ("restore".equals(action)) {
            String billId = info.getId().toString();
            if (!this._exists(ctx, (IObjectPK)new ObjectUuidPK(billId))) {
                return;
            }
            int entrySize = info.getEntries().size();
            int dbEntrySize = 0;
            String sql = "select count(1) as totalCount from t_im_UsedCarinvoicereqEntry where fparentid = '" + billId + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rs.next()) {
                    dbEntrySize = rs.getInt("totalCount");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (entrySize == dbEntrySize) {
                return;
            }
        }
        WriteBackFacadeFactory.getLocalInstance(ctx).dispose(action, (IObjectValue)info);
    }

    protected void doNumber(Context ctx, UsedCarInvoiceReqInfo info) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNewNumber(ctx, (IObjectValue)info, info.getCompany().getId().toString(), null);
            info.setNumber(number);
        }
        if (info.getNumber() != null) {
            info.setNumber(info.getNumber().trim());
        }
    }

    protected void checkBeforeSave(Context ctx, UsedCarInvoiceReqInfo info) throws EASBizException, BOSException {
        if (MakeInvoiceReqStatusEnum.SUBMITED.equals((Object)info.getStatus()) || MakeInvoiceReqStatusEnum.AUDITED.equals((Object)info.getStatus()) || MakeInvoiceReqStatusEnum.DELETED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_SAVE_STATUS_ERROR", ctx.getLocale(), new Object[]{info.getStatus().getAlias(ctx.getLocale())})});
        }
        String[] fields = new String[]{"company", "number", "bizDate"};
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, fields, null);
        String[] lengthFields = new String[]{"number", "buyerName", "buyerAddress", "buyerCardNo", "buyerPhoneNumber", "remark", "entries.licensePlateNumber", "entries.registrationNumber", "entries.vehicleType", "entries.vehicleIdentificationCode", "entries.facPlateModel", "entries.transferInVehilceManager", "entries.remark"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)info, lengthFields);
        super._checkNumberDup(ctx, null, (IObjectValue)info);
    }

    protected void synchronousAmt(UsedCarInvoiceReqInfo info) {
        info.setPriceExcludingTaxLocal(info.getPriceExcludingTax());
        info.setTaxLocal(info.getTax());
        info.setPriceIncludingTaxLocal(info.getPriceIncludingTax());
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            UsedCarInvoiceReqEntryInfo entryInfo = info.getEntries().get(i);
            entryInfo.setPriceExcludingTaxLocal(entryInfo.getPriceExcludingTax());
            entryInfo.setTaxLocal(entryInfo.getTax());
            entryInfo.setPriceIncludingTaxLocal(entryInfo.getPriceIncludingTax());
        }
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)model;
        if (model == null) {
            info = this.getUsedCarInvoiceReqInfo(ctx, pk, this.getSelectors());
        }
        this.submit(ctx, (CoreBaseInfo)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((String)"0CADF79B"));
        }
        this.doNumber(ctx, info);
        this.clearTrimInfo(ctx, info);
        this.checkBeforeSubmit(ctx, info);
        if (info.getId() != null) {
            this.checkStatusEqualsInDB(ctx, info);
        }
        info.setStatus(MakeInvoiceReqStatusEnum.SUBMITED);
        if (info.getSrcSystem() == null) {
            info.setSrcSystem(MakeInvoiceReqSrcSystem.MANUAL);
        }
        this.synchronousAmt(info);
        this.calTotalFields(info);
        this.dispose(ctx, info, "restore");
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.dispose(ctx, info, "submit");
        return pk;
    }

    public IObjectPK submit(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        try {
            return super.submit(ctx, model);
        }
        catch (MissMatchParticipantException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.base.multiapprove.MultiApproveResource", (String)"HAVENO_MULTIAPPROVE_ASSIGNMENT", (Locale)ctx.getLocale())});
        }
        catch (MatchAssignmentException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_WFMatch", (Locale)ctx.getLocale())});
        }
        catch (AlreadyInProcessQueueException e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_AlreadyInProcessQueue", (Locale)ctx.getLocale())});
        }
    }

    protected void checkBeforeSubmit(Context ctx, UsedCarInvoiceReqInfo info) throws EASBizException, BOSException {
        if (!MakeInvoiceReqStatusEnum.TEMPSTROE.equals((Object)info.getStatus()) && !MakeInvoiceReqStatusEnum.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_SUBMIT_STATUS_ERROR", ctx.getLocale())});
        }
        super._checkNumberDup(ctx, null, (IObjectValue)info);
        if (info.getEntries().size() < 1) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_NOT_NULL", ctx.getLocale())});
        }
        String[] emptyFields = new String[]{"company", "number", "bizDate", "salerEnterpriseType", "buyerCardNo", "buyerName", "buyerAddress", "buyerPhoneNumber", "entries.licensePlateNumber", "entries.registrationNumber", "entries.vehicleType", "entries.vehicleIdentificationCode", "entries.facPlateModel", "entries.transferInVehilceManager", "entries.priceExcludingTax", "entries.taxRate", "entries.tax", "entries.priceIncludingTax"};
        String buyerNameAlias = ResourceBase.getString((String)"com.kingdee.eas.tm.im.UsedCarInvoiceResource", (String)"BUYERNAME", (Locale)ctx.getLocale());
        String buyerCardNoAlias = ResourceBase.getString((String)"com.kingdee.eas.tm.im.UsedCarInvoiceResource", (String)"BUYERCARDNO", (Locale)ctx.getLocale());
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        fieldAlias.put("buyerName", buyerNameAlias);
        fieldAlias.put("buyerCardNo", buyerCardNoAlias);
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, emptyFields, fieldAlias);
        String[] lengthFields = new String[]{"number", "buyerName", "buyerAddress", "buyerCardNo", "buyerPhoneNumber", "remark", "entries.licensePlateNumber", "entries.registrationNumber", "entries.vehicleType", "entries.vehicleIdentificationCode", "entries.facPlateModel", "entries.transferInVehilceManager", "entries.remark"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)info, lengthFields);
    }

    protected void clearTrimInfo(Context ctx, UsedCarInvoiceReqInfo info) {
        String[] fields = new String[]{"number", "remark", "buyerName", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "bankAccount"};
        String[] entryfields = new String[]{"licensePlateNumber", "registrationNumber", "vehicleType", "vehicleIdentificationCode", "facPlateModel", "transferInVehilceManager", "taxClassificationCode", "remark"};
        IMServerUtil.clearTrimInfo((IObjectValue)info, fields);
        UsedCarInvoiceReqEntryCollection entryCol = info.getEntries();
        if (entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                UsedCarInvoiceReqEntryInfo entryInfo = entryCol.get(i);
                IMServerUtil.clearTrimInfo((IObjectValue)entryInfo, entryfields);
            }
        }
    }

    @Override
    protected void _checkBeforeCopy(Context ctx, String billId) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqInfo((IObjectPK)new ObjectUuidPK(billId));
        if (MakeInvoiceReqSrcSystem.SYSTEM.equals((Object)info.getSrcSystem())) {
            throw new UsedCarInvoiceReqException(UsedCarInvoiceReqException.CANT_COPY_BILL);
        }
        CompanyOrgUnitInfo orgInfo = info.getCompany();
        try {
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(orgInfo.getId().toString()), this.getPermissionItem());
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected void _checkBeforeAdjustEntries(Context ctx, String billID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isMakeInvoiced"));
        UsedCarInvoiceReqInfo info = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqInfo((IObjectPK)new ObjectUuidPK(billID), sic);
        if (info.isIsMakeInvoiced()) {
            throw new UsedCarInvoiceReqException(UsedCarInvoiceReqException.BILL_HASMAKEINVOICED);
        }
    }

    @Override
    protected void _adjustEntries(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)model;
        this.clearTrimInfo(ctx, info);
        this.checkBeforeAdjustEntries(ctx, info);
        this.synchronousAmt(info);
        this.dispose(ctx, info, "restore");
        super._update(ctx, pk, (IObjectValue)info);
        this.dispose(ctx, info, "save");
    }

    protected void checkBeforeAdjustEntries(Context ctx, UsedCarInvoiceReqInfo info) throws EASBizException, BOSException {
        if (info.getEntries().size() < 1) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_NOT_NULL", ctx.getLocale())});
        }
        String[] emptyFields = new String[]{"company", "number", "bizDate", "salerEnterpriseType", "buyerCardNo", "buyerAddress", "buyerPhoneNumber", "entries.licensePlateNumber", "entries.registrationNumber", "entries.vehicleType", "entries.vehicleIdentificationCode", "entries.facPlateModel", "entries.transferInVehilceManager", "entries.priceExcludingTax", "entries.taxRate", "entries.tax", "entries.priceIncludingTax", "entries.taxClassificationCode"};
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, emptyFields, null);
        String[] lengthFields = new String[]{"number", "buyerName", "buyerAddress", "buyerCardNo", "buyerPhoneNumber", "remark", "entries.licensePlateNumber", "entries.registrationNumber", "entries.vehicleType", "entries.vehicleIdentificationCode", "entries.facPlateModel", "entries.transferInVehilceManager", "entries.remark"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)info, lengthFields);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = this.getUsedCarInvoiceReqInfo(ctx, pk, this.getSelectors());
        this.checkBeforeAudit(ctx, info);
        info.setStatus(MakeInvoiceReqStatusEnum.AUDITED);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        if (info.getPlanInvoiceDate() == null) {
            info.setPlanInvoiceDate(new Date());
        } else {
            Date planDate = info.getPlanInvoiceDate();
            if (planDate.before(new Date())) {
                info.setPlanInvoiceDate(new Date());
            }
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void checkBeforeAudit(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        if (!MakeInvoiceReqStatusEnum.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_AUDIT_STATUS_ERROR", ctx.getLocale())});
        }
        String[] entryfields = new String[]{"entries.taxClassificationCode"};
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, entryfields, null);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = this.getUsedCarInvoiceReqInfo(ctx, pk, this.getSelectors());
        this.checkBeforeUnAudit(ctx, info);
        info.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
        info.setAuditor(null);
        info.setAuditTime(null);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void checkBeforeUnAudit(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        if (!MakeInvoiceReqStatusEnum.AUDITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_AUDIT_STATUS_ERROR", ctx.getLocale())});
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select fbizbillid from t_im_makeinvoicerelation t1");
        sb.append(" where t1.fbizbillid = '").append(info.getId().toString()).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            if (rs.next()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "HAVE_INVOICEBILL", ctx.getLocale())});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = this.getUsedCarInvoiceReqInfo(ctx, pk, this.getSelectors());
        this.checkBeforeDelete(ctx, info);
        this.beforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    protected void checkBeforeDelete(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        if (!MakeInvoiceReqStatusEnum.TEMPSTROE.equals((Object)info.getStatus()) && !MakeInvoiceReqStatusEnum.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "STATUSDELETE", new String[0])});
        }
    }

    protected void beforeDelete(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        this.dispose(ctx, info, "delete");
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
        super._handleAfterTransform(ctx, action, collection);
        HashSet<String> companyIds = new HashSet<String>();
        UsedCarInvoiceReqInfo info2 = null;
        for (UsedCarInvoiceReqInfo info2 : collection) {
            if (info2.getCU() != null || info2.getCompany() == null) continue;
            companyIds.add(info2.getCompany().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        CompanyOrgUnitInfo companyInfo2 = null;
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        for (CompanyOrgUnitInfo companyInfo2 : companyColl) {
            companyMap.put(companyInfo2.getId().toString(), companyInfo2);
        }
        for (UsedCarInvoiceReqInfo info2 : collection) {
            if (info2.getCU() == null && info2.getCompany() != null) {
                companyInfo2 = (CompanyOrgUnitInfo)companyMap.get(info2.getCompany().getId().toString());
                info2.setCU(companyInfo2.getCU());
            }
            this.handleInfoAfterTransferform(ctx, info2);
        }
    }

    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
        super._handleAfterTransform(ctx, action, objectValue);
        UsedCarInvoiceReqInfo info = (UsedCarInvoiceReqInfo)objectValue;
        if (info.getCU() == null && info.getCompany() != null) {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
            info.setCU(companyInfo.getCU());
        }
        this.handleInfoAfterTransferform(ctx, info);
    }

    protected void handleInfoAfterTransferform(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        info.setStatus(MakeInvoiceReqStatusEnum.TEMPSTROE);
        info.setSrcSystem(MakeInvoiceReqSrcSystem.SYSTEM);
        this.readNumber(ctx, info, info.getCompany().getId().toString(), null);
        if (info.getAsstActType() != null && !"YW3xsAEJEADgAAUWwKgTB0c4VZA=".equals(info.getAsstActType().getId().toString()) && !"YW3xsAEJEADgAAVEwKgTB0c4VZA=".equals(info.getAsstActType().getId().toString())) {
            info.setAsstActType(null);
            info.setAsstActID(null);
            info.setAsstActName(null);
            info.setAsstActNumber(null);
        }
        if (info.getSourceBillType() == null) {
            info.setSourceBillType(MakeInvoiceReqBillTypeEnum.OtherReceiveBill);
        }
        this.setAddressAndTel(info.getBuyerAddress(), info);
        this.setBuyerInfo(ctx, info);
        this.setProductCode(ctx, info);
        this.calTotalFields(info);
    }

    protected void setAddressAndTel(String addressAndTel, UsedCarInvoiceReqInfo info) {
        if (!StringUtils.isEmpty((String)addressAndTel)) {
            String address = addressAndTel.substring(0, addressAndTel.lastIndexOf(" ") + 1);
            String phoneNumber = addressAndTel.substring(addressAndTel.lastIndexOf(" ") + 1, addressAndTel.length());
            info.setBuyerAddress(address.trim());
            info.setBuyerPhoneNumber(phoneNumber.trim());
        }
    }

    protected void setBuyerInfo(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        String companyId = "";
        if (info.getCompany() != null) {
            companyId = info.getCompany().getId().toString();
        }
        if (info.getAsstActType() == null) {
            return;
        }
        if ("YW3xsAEJEADgAAUWwKgTB0c4VZA=".equals(info.getAsstActType().getId().toString())) {
            String customerId = "";
            if (info.getAsstActID() != null) {
                customerId = info.getAsstActID();
            }
            CustomerTaxInfo customerTax = null;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("isVehicle", "1");
            map.put("companyId", companyId);
            map.put("customerId", customerId);
            Map retValue = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(map);
            customerTax = (CustomerTaxInfo)retValue.get("value");
            if (customerTax == null) {
                return;
            }
            if (info.getBuyerName() == null) {
                info.setBuyerName(customerTax.getRecCompanyName());
            }
            if (info.getBuyerCardNo() == null) {
                info.setBuyerCardNo(customerTax.getTaxNumber());
            }
            if (StringUtils.isEmpty((String)info.getBuyerAddress()) && StringUtils.isEmpty((String)info.getBuyerPhoneNumber())) {
                this.setAddressAndTel(customerTax.getAddressTel(), info);
            }
            if (StringUtils.isEmpty((String)info.getBankAccount())) {
                info.setBankAccount(customerTax.getBankAccount());
            }
        } else if ("YW3xsAEJEADgAAVEwKgTB0c4VZA=".equals(info.getAsstActType().getId().toString())) {
            SupplierInfo supplierInfo;
            if (info.getBuyerName() == null) {
                info.setBuyerName(info.getAsstActName());
            }
            if (info.getAsstActID() != null && (supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getAsstActID()))) != null && info.getBuyerTaxNo() == null) {
                info.setBuyerCardNo(supplierInfo.getTaxRegisterNo());
            }
        }
    }

    protected void setProductCode(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        Map productCache = this.batchFetchProductCode(ctx, info);
        Map materialEntryCache = (Map)productCache.get("materialEntryCache");
        Map expenseItemEntryCache = (Map)productCache.get("expenseItemEntryCache");
        String arEntryId = "";
        String productRelation = "";
        String materialExpenseID = "";
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            UsedCarInvoiceReqEntryInfo entryInfo = info.getEntries().get(i);
            if (!StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId())) {
                arEntryId = entryInfo.getSourceBillEntryId();
            }
            BigDecimal taxRate = entryInfo.getTaxRate().divide(new BigDecimal(100)).stripTrailingZeros();
            if (materialEntryCache.containsKey(arEntryId)) {
                productRelation = "material";
                materialExpenseID = (String)materialEntryCache.get(arEntryId);
            } else {
                productRelation = "expenseItem";
                materialExpenseID = (String)expenseItemEntryCache.get(arEntryId);
            }
            ProductCodeInfo product = this.getProductName(productCache, productRelation, materialExpenseID, info, taxRate);
            entryInfo.setProductCode(product);
            this.setProductFields(entryInfo, product);
            this.reCalEntryFields(ctx, entryInfo);
        }
    }

    protected void setProductFields(UsedCarInvoiceReqEntryInfo entryInfo, ProductCodeInfo product) throws BOSException, EASBizException {
        if (product == null) {
            return;
        }
        if (StringUtils.isEmpty((String)entryInfo.getProductName())) {
            entryInfo.setProductName(product.getName());
        }
        if (StringUtils.isEmpty((String)entryInfo.getUnitName()) && entryInfo.getUnit() != null) {
            entryInfo.setUnitName(entryInfo.getUnit().getName());
        }
        if (entryInfo.getTaxClassificationCode() == null && product.getTaxClassificationCode() != null) {
            entryInfo.setTaxClassificationCode(product.getTaxClassificationCode().getMergeCode());
        }
        if (entryInfo.getVehicleType() == null) {
            entryInfo.setVehicleType(product.getVehicleType());
        }
        if (entryInfo.getFacPlateModel() == null) {
            entryInfo.setFacPlateModel(product.getFacPlateModel());
        }
        if (entryInfo.getTaxRate() == null && product.getTaxRate() != null) {
            entryInfo.setTaxRate(product.getTaxRate().multiply(new BigDecimal(100)));
        }
    }

    protected void reCalEntryFields(Context ctx, UsedCarInvoiceReqEntryInfo entryInfo) throws BOSException, EASBizException {
        BigDecimal priceIncludingTax = entryInfo.getPriceIncludingTax();
        BigDecimal taxRate = BigDecimal.ZERO;
        if (entryInfo.getTaxRate() != null) {
            taxRate = entryInfo.getTaxRate().divide(new BigDecimal(100), 10, 4);
        }
        BigDecimal tax = priceIncludingTax.divide(BigDecimal.ONE.add(taxRate), 10, 4).multiply(taxRate);
        BigDecimal priceExcludingTax = priceIncludingTax.subtract(tax);
        entryInfo.setTax(tax.setScale(2, 4));
        entryInfo.setPriceExcludingTax(priceExcludingTax.setScale(2, 4));
        int pricePrecision = 10;
        if (entryInfo.getProductCode() != null && entryInfo.getProductCode().getMaterial() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            MaterialInfo material = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(entryInfo.getProductCode().getMaterial().getId()), sic);
            pricePrecision = material.getPricePrecision();
        }
        if (entryInfo.getQuantity() != null) {
            if (BigDecimal.ZERO.compareTo(entryInfo.getQuantity()) == 0) {
                entryInfo.setPrice(BigDecimal.ZERO);
                entryInfo.setNoTaxPrice(BigDecimal.ZERO);
            } else {
                entryInfo.setPrice(entryInfo.getPriceIncludingTax().divide(entryInfo.getQuantity(), pricePrecision, 4));
                entryInfo.setNoTaxPrice(entryInfo.getPriceExcludingTax().divide(entryInfo.getQuantity(), pricePrecision, 4));
            }
        }
    }

    protected void calTotalFields(UsedCarInvoiceReqInfo info) throws BOSException, EASBizException {
        BigDecimal totalPriceIncludingTax = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalPriceExcludingTax = BigDecimal.ZERO;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            UsedCarInvoiceReqEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo.getPriceIncludingTax() != null) {
                totalPriceIncludingTax = totalPriceIncludingTax.add(entryInfo.getPriceIncludingTax());
            }
            if (entryInfo.getTax() != null) {
                totalTax = totalTax.add(entryInfo.getTax());
            }
            if (entryInfo.getPriceExcludingTax() == null) continue;
            totalPriceExcludingTax = totalPriceExcludingTax.add(entryInfo.getPriceExcludingTax());
        }
        info.setPriceIncludingTax(totalPriceIncludingTax);
        info.setTax(totalTax);
        info.setPriceExcludingTax(totalPriceExcludingTax);
    }

    protected Map batchFetchProductCode(Context ctx, UsedCarInvoiceReqInfo info) throws BOSException {
        String key;
        int i;
        int size;
        HashMap productCache = new HashMap();
        HashMap<String, ProductCodeCollection> productMaterialCache = new HashMap<String, ProductCodeCollection>();
        HashMap<String, ProductCodeCollection> productExpenseItemCache = new HashMap<String, ProductCodeCollection>();
        HashMap<String, String> materialEntryCache = new HashMap<String, String>();
        HashMap<String, String> expenseItemEntryCache = new HashMap<String, String>();
        HashSet<String> arEntryIDs = new HashSet<String>();
        HashSet<String> materialIDs = new HashSet<String>();
        HashSet<String> expenseItemIDS = new HashSet<String>();
        int size2 = info.getEntries().size();
        for (int i2 = 0; i2 < size2; ++i2) {
            UsedCarInvoiceReqEntryInfo entryInfo = info.getEntries().get(i2);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId())) continue;
            arEntryIDs.add(entryInfo.getSourceBillEntryId());
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", arEntryIDs, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        OtherBillentryCollection arEntryColl = OtherBillentryFactory.getLocalInstance((Context)ctx).getOtherBillentryCollection(viewInfo);
        int n = arEntryColl.size();
        for (int i3 = 0; i3 < n; ++i3) {
            OtherBillentryInfo arEntryInfo = arEntryColl.get(i3);
            if (arEntryInfo.getMaterial() != null) {
                materialIDs.add(arEntryInfo.getMaterial().getId().toString());
                materialEntryCache.put(arEntryInfo.getId().toString(), arEntryInfo.getMaterial().getId().toString());
            }
            if (arEntryInfo.getExpenseItem() == null) continue;
            expenseItemIDS.add(arEntryInfo.getExpenseItem().getId().toString());
            expenseItemEntryCache.put(arEntryInfo.getId().toString(), arEntryInfo.getExpenseItem().getId().toString());
        }
        if (materialIDs.size() > 0) {
            ProductCodeCollection productMaterialColl = this.getProductCodeCollection(ctx, "material", materialIDs, null);
            size = productMaterialColl.size();
            for (i = 0; i < size; ++i) {
                ProductCodeInfo productCodeInfo = productMaterialColl.get(i);
                key = productCodeInfo.getMaterial().getId().toString() + "_" + productCodeInfo.getTaxRate().stripTrailingZeros().toPlainString();
                if (!productMaterialCache.containsKey(key)) {
                    productMaterialCache.put(key, new ProductCodeCollection());
                }
                ((ProductCodeCollection)((Object)productMaterialCache.get(key))).add(productCodeInfo);
            }
        }
        if (expenseItemIDS.size() > 0) {
            ProductCodeCollection productExpenseItemColl = this.getProductCodeCollection(ctx, "expenseItem", null, expenseItemIDS);
            size = productExpenseItemColl.size();
            for (i = 0; i < size; ++i) {
                ProductCodeInfo productCodeInfo = productExpenseItemColl.get(i);
                key = productCodeInfo.getExpenseItem().getId().toString() + "_" + productCodeInfo.getTaxRate().stripTrailingZeros().toPlainString();
                if (!productExpenseItemCache.containsKey(key)) {
                    productExpenseItemCache.put(key, new ProductCodeCollection());
                }
                ((ProductCodeCollection)((Object)productExpenseItemCache.get(key))).add(productCodeInfo);
            }
        }
        productCache.put("productMaterialCache", productMaterialCache);
        productCache.put("productExpenseItemCache", productExpenseItemCache);
        productCache.put("materialEntryCache", materialEntryCache);
        productCache.put("expenseItemEntryCache", expenseItemEntryCache);
        return productCache;
    }

    protected ProductCodeCollection getProductCodeCollection(Context ctx, String productRelation, Set materialIDs, Set expenseIDS) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if ("material".equals(productRelation)) {
            filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialIDs, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("expenseItem", (Object)expenseIDS, CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isVehicle", (Object)1, CompareType.EQUALS));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("customer.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("expenseItem.id"));
        sic.add(new SelectorItemInfo("taxClassificationCode.mergeCode"));
        sic.add(new SelectorItemInfo("taxClassificationCode.id"));
        sic.add(new SelectorItemInfo("taxClassificationCode.name"));
        sic.add(new SelectorItemInfo("taxClassificationCode.simpleName"));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("customer.id"));
        view.setSorter(sort);
        view.setFilter(filter);
        view.setSelector(sic);
        ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(view);
        return coll;
    }

    private ProductCodeInfo getProductName(Map productCache, String productRelation, String materialExpenseID, UsedCarInvoiceReqInfo UsedCarInfo, BigDecimal taxRate) throws BOSException, IMException {
        Map productMaterialCache = (Map)productCache.get("productMaterialCache");
        Map productExpenseItemCache = (Map)productCache.get("productExpenseItemCache");
        String companyID = "";
        if (UsedCarInfo.getCompany() != null) {
            companyID = UsedCarInfo.getCompany().getId().toString();
        }
        String customerID = "";
        if (UsedCarInfo.getAsstActID() != null) {
            customerID = UsedCarInfo.getAsstActID();
        }
        ProductCodeInfo product = null;
        ProductCodeCollection coll = "material".equals(productRelation) ? (ProductCodeCollection)((Object)productMaterialCache.get(materialExpenseID + "_" + taxRate.stripTrailingZeros().toPlainString())) : (ProductCodeCollection)((Object)productExpenseItemCache.get(materialExpenseID + "_" + taxRate.stripTrailingZeros().toPlainString()));
        if (coll != null && coll.size() > 0) {
            ProductCodeCollection sameCustomer = new ProductCodeCollection();
            ProductCodeCollection sameCompany = new ProductCodeCollection();
            ProductCodeCollection allNull = new ProductCodeCollection();
            for (int i = 0; i < coll.size(); ++i) {
                ProductCodeInfo info = coll.get(i);
                if (info.getCustomer() != null && info.getCompany() != null) {
                    if (!info.getCustomer().getId().toString().equals(customerID) || !info.getCompany().getId().toString().equals(companyID)) continue;
                    return info;
                }
                if (info.getCompany() != null) {
                    if (!info.getCompany().getId().toString().equals(companyID)) continue;
                    sameCompany.add(info);
                    continue;
                }
                if (info.getCustomer() != null) {
                    if (!info.getCustomer().getId().toString().equals(customerID)) continue;
                    sameCustomer.add(info);
                    continue;
                }
                allNull.add(info);
            }
            if (sameCompany.size() > 0) {
                product = sameCompany.get(0);
            } else if (sameCustomer.size() > 0) {
                product = sameCustomer.get(0);
            } else if (allNull.size() > 0) {
                product = allNull.get(0);
            }
        }
        return product;
    }

    protected UsedCarInvoiceReqInfo readNumber(Context ctx, UsedCarInvoiceReqInfo info, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getCompany().getId().toString());
        if (codeRuleInfo == null) {
            if (StringUtils.isEmpty((String)info.getNumber())) {
                info.setNumber("AutoNumberFromBTP_" + info.getId());
            } else if (this.isSameNumber(ctx, null, (IObjectValue)info)) {
                throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{info.getId().toString(), ""});
            }
        } else {
            if (StringUtils.isEmpty((String)strCompanyID)) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "COMPANYISNULL", new String[0])});
            }
            if (codeRuleInfo.isIsaddnewbreak()) {
                info.setNumber(iCodingRuleManager.readNumber((IObjectValue)info, strCompanyID, customString));
            } else if (codeRuleInfo.isIsAddView()) {
                this.getNewNumber(ctx, (IObjectValue)info, strCompanyID, customString);
            }
        }
        return info;
    }

    public SelectorItemCollection getSelectors() {
        return IMSelectorFactory.getUsedCarInvoiceReqSelectors();
    }

    protected String getPermissionItem() {
        return "im_usedCarInvoiceReq_new";
    }

    @Override
    protected void _checkBeforeEdit(Context ctx, String invoiceId) throws BOSException, EASBizException {
        UsedCarInvoiceReqInfo info = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqInfo((IObjectPK)new ObjectUuidPK(invoiceId));
        if (info.getStatus() != null && !MakeInvoiceReqStatusEnum.TEMPSTROE.equals((Object)info.getStatus()) && !MakeInvoiceReqStatusEnum.SUBMITED.equals((Object)info.getStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"CANNOTEDIT", (Locale)ctx.getLocale())});
        }
    }
}

