/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqCollection;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqFactory;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.app.AbstractUsedCarInvoiceReqFacadeControllerBean;
import com.kingdee.eas.tm.im.app.InvoiceReqUtils;
import com.kingdee.eas.tm.im.app.util.UsedCarServerUtil;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UsedCarInvoiceReqFacadeControllerBean
extends AbstractUsedCarInvoiceReqFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.UsedCarInvoiceReqFacadeControllerBean");
    private static final String USEDCARMAKEINVOICE_VALUE = "1";
    private static final String SPECIALMAKEINVOICE_VALUE = "2";
    private static final String ELESPECIALMAKEINVOICE_VALUE = "3";

    @Override
    protected Map _checkBeforeInvoice(Context ctx, Map params) throws BOSException, EASBizException {
        List selectBillIds = (List)params.get("billIds");
        List selectEntryIds = (List)params.get("entryIds");
        boolean isReq = (Boolean)params.get("isReq");
        String invoiceType = (String)params.get("invoiceType");
        HashMap billErrMap = new HashMap();
        HashMap billEntryErrMap = new HashMap();
        HashSet volidBillIds = new HashSet(selectBillIds);
        HashSet volidEntryIds = new HashSet(selectEntryIds);
        this.checkBill(ctx, isReq, invoiceType, volidBillIds, billErrMap);
        this.checkEntry(ctx, invoiceType, volidBillIds, volidEntryIds, billEntryErrMap);
        StringBuffer errorMsg = this.buildErrorMsg(ctx, billErrMap, selectEntryIds, billEntryErrMap);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("volidBillIds", volidBillIds);
        ret.put("volidEntryIds", volidEntryIds);
        ret.put("selectBillIds", selectBillIds);
        ret.put("selectEntryIds", selectEntryIds);
        ret.put("billErrMap", billErrMap);
        ret.put("billEntryErrMap", billEntryErrMap);
        ret.put("errorMsg", errorMsg);
        return ret;
    }

    protected void checkBill(Context ctx, boolean isReq, String invoiceType, Set idSet, Map billErrMap) throws BOSException, EASBizException {
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(IMSelectorFactory.getUsedCarInvoiceReqSelectors());
        UsedCarInvoiceReqCollection coll = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqCollection(ev);
        this.checkInvoicePermission(ctx, isReq, invoiceType, idSet, billErrMap, coll);
        this.checkHasMakeInvoice(ctx, isReq, invoiceType, idSet, billErrMap, coll);
    }

    protected void checkInvoicePermission(Context ctx, boolean isReq, String invoiceType, Set idSet, Map billErrMap, UsedCarInvoiceReqCollection coll) throws BOSException {
        String permItemName = "";
        permItemName = isReq ? (USEDCARMAKEINVOICE_VALUE.equals(invoiceType) ? "im_usedCarInvoiceReq_invoicereqUsedCar" : "im_usedCarInvoiceReq_invoicereqVAT") : (USEDCARMAKEINVOICE_VALUE.equals(invoiceType) ? "im_usedCarInvoiceReq_invoiceUsedCar" : "im_usedCarInvoiceReq_invoiceVAT");
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                UsedCarInvoiceReqInfo info = coll.get(i);
                String id = info.getId().toString();
                try {
                    IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), permItemName);
                }
                catch (EASBizException e) {
                    billErrMap.put(id, e.getMessage());
                    idSet.remove(id);
                }
                if (!MakeInvoiceReqStatusEnum.AUDITED.equals((Object)info.getStatus())) {
                    billErrMap.put(id, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_INVOICE_STATUSERROR", ctx));
                    idSet.remove(id);
                }
                if (SPECIALMAKEINVOICE_VALUE.equals(invoiceType) && !PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getVatInvoiceType())) {
                    billErrMap.put(id, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_INVOICETYPE_ERROR", ctx));
                    idSet.remove(id);
                    continue;
                }
                if (!ELESPECIALMAKEINVOICE_VALUE.equals(invoiceType) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getVatInvoiceType())) continue;
                billErrMap.put(id, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_INVOICETYPE_ERROR", ctx));
                idSet.remove(id);
            }
        }
    }

    protected void checkHasMakeInvoice(Context ctx, boolean isReq, String invoiceType, Set idSet, Map billErrMap, UsedCarInvoiceReqCollection coll) throws BOSException {
        if (idSet.size() == 0) {
            return;
        }
        if (!USEDCARMAKEINVOICE_VALUE.equals(invoiceType)) {
            StringBuffer sb = new StringBuffer();
            sb.append(" select fbizbillid from t_im_makeinvoicerelation t1 ");
            sb.append(" inner join t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid ");
            sb.append(" inner join t_im_usedcarinvoicereq src on t1.fbizbillid = src.fid");
            sb.append(" where t1.fbizbillid in").append(IMUtils.getInStringFromSet(idSet));
            sb.append(" and src.FInvoicedAmt <> 0");
            sb.append(" union  all ");
            sb.append(" select fbizbillid from t_im_makeinvoicerelation t1 ");
            sb.append(" inner join t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid ");
            sb.append(" inner join t_im_usedcarinvoicereq src on t1.fbizbillid = src.fid");
            sb.append(" where t1.fbizbillid in").append(IMUtils.getInStringFromSet(idSet));
            sb.append(" and t2.fid  in  ( SELECT fid FROM  t_im_makeinvoice  where FStatus in ('1','2','3') )");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    String bizId = rs.getString("fbizbillid");
                    billErrMap.put(bizId, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_HAVE_MAKEINVOICE", ctx));
                    idSet.remove(bizId);
                }
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage());
            }
        }
    }

    protected void checkEntry(Context ctx, String invoiceType, Set idSet, Set entryIdSet, Map billEntryErrMap) throws BOSException {
        this.checkHasUsedCarInvoice(ctx, invoiceType, idSet, entryIdSet, billEntryErrMap);
    }

    protected void checkHasUsedCarInvoice(Context ctx, String invoiceType, Set idSet, Set entryIdSet, Map billEntryErrMap) throws BOSException {
        if (idSet.size() == 0 || entryIdSet.size() == 0) {
            return;
        }
        try {
            StringBuffer sb = new StringBuffer();
            if (USEDCARMAKEINVOICE_VALUE.equals(invoiceType)) {
                String entryId;
                sb.append(" select FSrcEntryID from t_im_makeinvoicerelationEntry relationEntry ");
                sb.append(" inner join t_im_usedcarmakeinvoice invoice on relationEntry.FDestObjectID = invoice.fid ");
                sb.append(" inner join t_im_usedcarinvoicereqentry srcEntry on relationEntry.FSrcEntryID = srcEntry.fid");
                sb.append(" where relationEntry.FSrcEntryID in").append(IMUtils.getInStringFromSet(entryIdSet));
                sb.append(" and relationEntry.FSrcObjectID in").append(IMUtils.getInStringFromSet(idSet));
                sb.append(" and srcEntry.FInvoicedAmt <> 0");
                sb.append(" union all  ");
                sb.append(" select FSrcEntryID from t_im_makeinvoicerelationEntry relationEntry ");
                sb.append(" inner join t_im_usedcarmakeinvoice invoice on relationEntry.FDestObjectID = invoice.fid ");
                sb.append(" inner join t_im_usedcarinvoicereqentry srcEntry on relationEntry.FSrcEntryID = srcEntry.fid");
                sb.append(" where relationEntry.FSrcEntryID in").append(IMUtils.getInStringFromSet(entryIdSet));
                sb.append(" and relationEntry.FSrcObjectID in").append(IMUtils.getInStringFromSet(idSet));
                sb.append(" and invoice.FStatus in ('1','2','3')");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                while (rs.next()) {
                    entryId = rs.getString("FSrcEntryID");
                    billEntryErrMap.put(entryId, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_HAVE_USEDCARINVOICE", ctx));
                    entryIdSet.remove(entryId);
                }
                sb.setLength(0);
                if (entryIdSet.size() > 0) {
                    sb.append(" select fid from t_im_usedcarinvoicereqentry where ( FPriceIncludingTax=0 or FPriceIncludingTax is null )");
                    sb.append(" and fid in").append(IMUtils.getInStringFromSet(entryIdSet));
                    rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                    while (rs.next()) {
                        entryId = rs.getString("fid");
                        entryIdSet.remove(entryId);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected StringBuffer buildErrorMsg(Context ctx, Map billErrMap, List entryIds, Map billEntryErrMap) throws BOSException {
        StringBuffer errorMsg = new StringBuffer();
        UsedCarServerUtil.buildBillErrorMsg(ctx, billErrMap, errorMsg, entryIds, billEntryErrMap);
        UsedCarServerUtil.buildEntryErrorMsg(ctx, billEntryErrMap, errorMsg);
        return errorMsg;
    }

    @Override
    protected Map _checkBeforePrint(Context ctx, Map params) throws BOSException, EASBizException {
        HashMap retValue = new HashMap();
        List billIds = (List)params.get("billIds");
        List entryIds = (List)params.get("entryIds");
        String operType = (String)params.get("operType");
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        UsedCarInvoiceReqInfo info = null;
        HashSet<String> companyids = new HashSet<String>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(billIds), CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(sic);
        UsedCarInvoiceReqCollection coll = UsedCarInvoiceReqFactory.getLocalInstance(ctx).getUsedCarInvoiceReqCollection(ev);
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                info = coll.get(i);
                companyids.add(info.getCompany().getId().toString());
            }
        }
        if ("usedCarPrintInvoice".equals(operType)) {
            this.checkBeforePrintUsedCarInvoice(ctx, billIds, entryIds, retValue);
        } else if ("printInvoice".equals(operType)) {
            this.checkBeforePrintVATInvoice(ctx, billIds, entryIds, retValue);
        }
        return retValue;
    }

    protected void checkBeforePrintUsedCarInvoice(Context ctx, List billIds, List entryIds, Map retValue) throws BOSException, EASBizException {
        Set invoiceIds = this.getInvoiceByBills(ctx, billIds, entryIds);
        if (invoiceIds.size() == 0) {
            retValue.put("errorMsg", new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "INVOICE_NOTFOUND", new String[0])}).getMessage());
            return;
        }
        Map result = UsedCarMakeInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforePrint(invoiceIds);
        retValue.putAll(result);
    }

    protected Set getInvoiceByBills(Context ctx, List ids, List entryIds) throws BOSException, EASBizException {
        Set<String> invoiceNoSet = this.getInvoiceNoListByBillIDSet(ctx, entryIds);
        String selectSQL = "SELECT relationEntry.FDestObjectID as invoiceID FROM T_IM_MakeInvoiceRelationEntry as relationEntry  INNER JOIN T_IM_UsedCarMakeInvoice as invoice on invoice.fid = relationEntry.FDestObjectID  WHERE relationEntry.FSrcObjectID IN (" + InvoiceReqUtils.concat(ids) + ")  and relationEntry.FSrcEntryID in (" + InvoiceReqUtils.concat(entryIds) + ") and invoice.FStatus = '4' and invoice.FInvoiceNo in (" + InvoiceReqUtils.concat(invoiceNoSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        HashSet<String> invoiceIds = new HashSet<String>();
        try {
            String invoiceID = null;
            while (rs.next()) {
                invoiceID = rs.getString("invoiceID");
                invoiceIds.add(invoiceID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceIds;
    }

    protected Set<String> getInvoiceNoListByBillIDSet(Context ctx, List billIdSet) throws BOSException {
        try {
            String selectSQL = "select FInvoiceNo from t_im_usedcarinvoicereqentry where fid in (" + InvoiceReqUtils.concat(billIdSet) + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            HashSet<String> invoiceNoSet = new HashSet<String>();
            while (rs.next()) {
                String invoiceNo = rs.getString("FInvoiceNo");
                if (invoiceNo == null || "".equals(invoiceNo)) continue;
                String[] invoiceNoArr = invoiceNo.split(";");
                for (int i = 0; i < invoiceNoArr.length; ++i) {
                    invoiceNoSet.add(invoiceNoArr[i]);
                }
            }
            return invoiceNoSet;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    protected void checkBeforePrintVATInvoice(Context ctx, List billIds, List entryIds, Map retValue) throws BOSException, EASBizException {
        Set invoiceIds = this.getVATInvoiceByBills(ctx, billIds);
        if (invoiceIds.size() == 0) {
            retValue.put("errorMsg", new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "INVOICE_NOTFOUND", new String[0])}).getMessage());
            return;
        }
        Map result = IMInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforePrint(invoiceIds);
        retValue.putAll(result);
    }

    protected Set getVATInvoiceByBills(Context ctx, List billIds) throws BOSException, IMException {
        Set<String> invoiceNoSet = this.getInvoiceNoListByInvoiceReqBillIDSet(ctx, billIds);
        String selectSQL = "SELECT relation.FInvoiceBillID as invoiceID FROM T_IM_MakeInvoiceRelation as relation  INNER JOIN T_IM_MakeInvoice as invoice on invoice.fid = relation.FInvoiceBillID  WHERE relation.FBizBillID IN (" + InvoiceReqUtils.concat(billIds) + ") and invoice.FStatus = '4' and invoice.FInvoiceNo in (" + InvoiceReqUtils.concat(invoiceNoSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        HashSet<String> invoiceIds = new HashSet<String>();
        try {
            String invoiceID = null;
            while (rs.next()) {
                invoiceID = rs.getString("invoiceID");
                invoiceIds.add(invoiceID);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("[UsedCarInvoiceReq_getVATInvoiceByBills]selectSQL:" + selectSQL));
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "QUERYINVOICE_FAILURE", new String[0])});
        }
        return invoiceIds;
    }

    private Set<String> getInvoiceNoListByInvoiceReqBillIDSet(Context ctx, List billIdSet) throws BOSException {
        try {
            String selectSQL = "select FInvoiceNumber from T_IM_UsedCarInvoiceReq where fid in (" + InvoiceReqUtils.concat(billIdSet) + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            HashSet<String> invoiceNoSet = new HashSet<String>();
            while (rs.next()) {
                String invoiceNo = rs.getString("FInvoiceNumber");
                if (invoiceNo == null || "".equals(invoiceNo)) continue;
                String[] invoiceNoArr = invoiceNo.split(";");
                for (int i = 0; i < invoiceNoArr.length; ++i) {
                    invoiceNoSet.add(invoiceNoArr[i]);
                }
            }
            return invoiceNoSet;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvoiceRespInfo _generateVATInvoice(Context ctx, List idList, String invoiceType, boolean isReq, Map combinRule) throws BOSException, EASBizException {
        UsedCarInvoiceReqCollection billColl = UsedCarServerUtil.getUsedCarInvoiceReqCollection(ctx, new HashSet(idList), null);
        String logItemName = isReq ? "im_usedCarInvoiceReq_invoicereqVAT" : "im_usedCarInvoiceReq_invoiceVAT";
        IObjectPK logPk = null;
        HashMap<String, IObjectPK> logMap = new HashMap<String, IObjectPK>();
        UsedCarInvoiceReqInfo info = null;
        int j = billColl.size();
        for (int i = 0; i < j; ++i) {
            info = billColl.get(i);
            logPk = LogUtils.beginLog(ctx, "invoiceReq", BOSObjectType.create((String)"AC368D2D"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), logItemName, info.getCompany().getId().toString());
            logMap.put(info.getId().toString(), logPk);
        }
        InvoiceRespInfo resp = null;
        try {
            IMUtils.tryLock(ctx, idList);
            StringBuffer paramID = new StringBuffer();
            for (int i = 0; i < idList.size(); ++i) {
                paramID.append(idList.get(i)).append(",");
            }
            MakeInvoiceParam param = new MakeInvoiceParam();
            param.setBilBillIds(paramID.toString());
            param.setInvoiceType(invoiceType + "");
            param.setPrint(false);
            param.setReq(isReq);
            param.setRuleIDs(combinRule);
            param.setSrcBosType("0CADF79B");
            param.setSrcSystem(IMConstant.SRCTYPE_IM_USEDCARREQ);
            resp = IMInvoiceFacadeFactory.getLocalInstance(ctx).makeInvoice(param);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            resp = new InvoiceRespInfo();
            resp.setErrorMsg(e.getMessage());
            resp.getBizFailBills().clear();
            resp.getBizFailBills().addAll(idList);
        }
        finally {
            IMUtils.releaseLock(ctx, idList);
        }
        if (logMap.size() > 0) {
            ArrayList bizFailBills = resp.getBizFailBills();
            if (bizFailBills != null && bizFailBills.size() > 0) {
                int j2 = bizFailBills.size();
                for (int i = 0; i < j2; ++i) {
                    logMap.remove(String.valueOf(bizFailBills.get(i)));
                }
            }
            for (Map.Entry entry : logMap.entrySet()) {
                LogUtils.afterLog(null, (IObjectPK)entry.getValue());
            }
        }
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvoiceRespInfo _generateUsedCarInvoice(Context ctx, List idList, List entryIdList, boolean isReq, Map combinRule) throws BOSException, EASBizException {
        UsedCarInvoiceReqCollection billColl = UsedCarServerUtil.getUsedCarInvoiceReqCollection(ctx, new HashSet(idList), new HashSet(entryIdList));
        String logItemName = isReq ? "im_usedCarInvoiceReq_invoicereqUsedCar" : "im_usedCarInvoiceReq_invoiceUsedCar";
        IObjectPK logPk = null;
        HashMap<String, IObjectPK> logMap = new HashMap<String, IObjectPK>();
        UsedCarInvoiceReqInfo info = null;
        UsedCarInvoiceReqEntryInfo entryInfo = null;
        int j = billColl.size();
        for (int i = 0; i < j; ++i) {
            info = billColl.get(i);
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                entryInfo = (UsedCarInvoiceReqEntryInfo)it.next();
                String instanceDetail = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY", ctx.getLocale(), new Object[]{info.getNumber(), entryInfo.getSeq()});
                logPk = LogUtils.beginLog(ctx, "invoiceReq", BOSObjectType.create((String)"0CADF79B"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), instanceDetail, logItemName, info.getCompany().getId().toString());
                logMap.put(entryInfo.getId().toString(), logPk);
            }
        }
        InvoiceRespInfo resp = null;
        try {
            IMUtils.tryLock(ctx, idList);
            MakeInvoiceParam param = new MakeInvoiceParam();
            param.setBilBillIds(CollectionUtil.convertList2String(idList, ",", false));
            param.setBillBillEntryIds(CollectionUtil.convertList2String(entryIdList, ",", false));
            param.setInvoiceType(USEDCARMAKEINVOICE_VALUE);
            param.setPrint(false);
            param.setReq(isReq);
            param.setRuleIDs(combinRule);
            param.setSrcBosType("0CADF79B");
            param.setSrcSystem(IMConstant.SRCTYPE_IM_USEDCARREQ);
            resp = IMInvoiceFacadeFactory.getLocalInstance(ctx).makeInvoice(param);
            if (resp.getMkSucessBillIds().size() > 0) {
                String isShowInvoiceUI = IMFacadeFactory.getLocalInstance(ctx).getParamByKey("isShowInvoiceUI");
                resp.getOtherData().put("isShowInvoiceUI", isShowInvoiceUI);
                if (USEDCARMAKEINVOICE_VALUE.equals(isShowInvoiceUI)) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(resp.getMkSucessBillIds()), CompareType.INCLUDE));
                    String botpFilter = filter.toSql();
                    resp.getOtherData().put("botpFilter", URLEncoder.encode(botpFilter, "utf-8"));
                    resp.getOtherData().put("uipk", "com.kingdee.eas.tm.im.UsedCarMakeInvoiceListPage");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            resp = new InvoiceRespInfo();
            resp.setErrorMsg(e.getMessage());
            resp.getBizFailBills().clear();
            resp.getBizFailBills().addAll(entryIdList);
        }
        finally {
            IMUtils.releaseLock(ctx, idList);
        }
        if (logMap.size() > 0) {
            ArrayList bizFailBills = resp.getBizFailBills();
            if (bizFailBills != null && bizFailBills.size() > 0) {
                int j2 = bizFailBills.size();
                for (int i = 0; i < j2; ++i) {
                    logMap.remove(String.valueOf(bizFailBills.get(i)));
                }
            }
            for (Map.Entry entry : logMap.entrySet()) {
                LogUtils.afterLog(ctx, (IObjectPK)entry.getValue());
            }
        }
        return resp;
    }
}

