/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqStatusEnum;
import com.kingdee.eas.tm.im.VehicleInvoiceReqCollection;
import com.kingdee.eas.tm.im.VehicleInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.VehicleInvoiceReqFactory;
import com.kingdee.eas.tm.im.VehicleInvoiceReqInfo;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.app.AbstractVehicleInvoiceReqFacadeControllerBean;
import com.kingdee.eas.tm.im.app.InvoiceReqUtils;
import com.kingdee.eas.tm.im.app.util.VehicleServerUtil;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VehicleInvoiceReqFacadeControllerBean
extends AbstractVehicleInvoiceReqFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.VehicleInvoiceReqFacadeControllerBean");

    @Override
    protected Map _checkBeforeInvoice(Context ctx, Map params) throws BOSException, EASBizException {
        List selectBillIds = (List)params.get("billIds");
        List selectEntryIds = (List)params.get("entryIds");
        boolean isReq = (Boolean)params.get("isReq");
        HashMap billErrMap = new HashMap();
        HashMap billEntryErrMap = new HashMap();
        HashSet volidBillIds = new HashSet(selectBillIds);
        HashSet volidEntryIds = new HashSet(selectEntryIds);
        this.checkBill(ctx, isReq, volidBillIds, billErrMap);
        this.checkEntry(ctx, volidBillIds, volidEntryIds, billEntryErrMap);
        StringBuffer errorMsg = this.buildErrorMsg(ctx, billErrMap, selectEntryIds, billEntryErrMap);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("volidBillIds", volidBillIds);
        ret.put("volidEntryIds", volidEntryIds);
        ret.put("selectBillIds", selectBillIds);
        ret.put("selectEntryIds", selectEntryIds);
        ret.put("billErrMap", billErrMap);
        ret.put("billEntryErrMap", billEntryErrMap);
        ret.put("errorMsg", errorMsg);
        return ret;
    }

    protected void checkBill(Context ctx, boolean isReq, Set idSet, Map billErrMap) throws BOSException, EASBizException {
        String permItemName;
        if (idSet.size() == 0) {
            return;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(IMSelectorFactory.getVehicleInvoiceReqSelectors());
        VehicleInvoiceReqCollection coll = VehicleInvoiceReqFactory.getLocalInstance(ctx).getVehicleInvoiceReqCollection(ev);
        String string = permItemName = isReq ? "im_vehicleinvoicereq_invoicereq" : "im_vehicleinvoicereq_invoice";
        if (coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                VehicleInvoiceReqInfo info = coll.get(i);
                String id = info.getId().toString();
                try {
                    IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), permItemName);
                }
                catch (EASBizException e) {
                    billErrMap.put(id, e.getMessage());
                    idSet.remove(id);
                }
                if (MakeInvoiceReqStatusEnum.AUDITED.equals((Object)info.getStatus())) continue;
                billErrMap.put(id, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_INVOICE_STATUSERROR", ctx));
                idSet.remove(id);
            }
        }
    }

    protected void checkEntry(Context ctx, Set idSet, Set entryIdSet, Map billEntryErrMap) throws BOSException {
        this.checkHasMakeInvoice(ctx, idSet, entryIdSet, billEntryErrMap);
    }

    protected void checkHasMakeInvoice(Context ctx, Set idSet, Set entryIdSet, Map billEntryErrMap) throws BOSException {
        if (idSet.size() == 0 || entryIdSet.size() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" select FSrcEntryID from t_im_makeinvoicerelationEntry relationEntry ");
        sb.append(" inner join t_im_vehiclemakeinvoice invoice on relationEntry.FDestObjectID = invoice.fid ");
        sb.append(" inner join t_im_vehicleinvoicereqentry srcEntry on relationEntry.FSrcEntryID = srcEntry.fid");
        sb.append(" where relationEntry.FSrcEntryID in").append(IMUtils.getInStringFromSet(entryIdSet));
        sb.append(" and relationEntry.FSrcObjectID in").append(IMUtils.getInStringFromSet(idSet));
        sb.append(" and (");
        sb.append(" srcEntry.FInvoicedAmt <> 0");
        sb.append(" or  ");
        sb.append(" invoice.FStatus in ('1','2','3')");
        sb.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        try {
            while (rs.next()) {
                String entryId = rs.getString("FSrcEntryID");
                billEntryErrMap.put(entryId, IMUtils.getResource("com.kingdee.eas.tm.im.IMBizResource", "MSG_HAVE_INVOICE", ctx));
                entryIdSet.remove(entryId);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    protected StringBuffer buildErrorMsg(Context ctx, Map billErrMap, List entryIds, Map billEntryErrMap) throws BOSException {
        StringBuffer errorMsg = new StringBuffer();
        VehicleServerUtil.buildBillErrorMsg(ctx, billErrMap, errorMsg, entryIds, billEntryErrMap);
        VehicleServerUtil.buildEntryErrorMsg(ctx, billEntryErrMap, errorMsg);
        return errorMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InvoiceRespInfo _generateInvoice(Context ctx, List idList, List entryIdList, boolean isReq, Map combinRule) throws BOSException, EASBizException {
        HashMap<String, IObjectPK> logMap = new HashMap<String, IObjectPK>();
        VehicleInvoiceReqCollection billColl = VehicleServerUtil.getVehicleInvoiceReqCollection(ctx, new HashSet(idList), new HashSet(entryIdList));
        String logItemName = isReq ? "im_vehicleinvoicereq_invoicereq" : "im_vehicleinvoicereq_invoice";
        IObjectPK logPk = null;
        VehicleInvoiceReqInfo info = null;
        VehicleInvoiceReqEntryInfo entryInfo = null;
        int j = billColl.size();
        for (int i = 0; i < j; ++i) {
            info = billColl.get(i);
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                entryInfo = (VehicleInvoiceReqEntryInfo)it.next();
                String instanceDetail = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY", ctx.getLocale(), new Object[]{info.getNumber(), entryInfo.getSeq()});
                logPk = LogUtils.beginLog(ctx, "invoiceReq", BOSObjectType.create((String)"B4E229F6"), (IObjectPK)new ObjectUuidPK(entryInfo.getId().toString()), instanceDetail, logItemName, info.getCompany().getId().toString());
                logMap.put(entryInfo.getId().toString(), logPk);
            }
        }
        InvoiceRespInfo resp = null;
        try {
            IMUtils.tryLock(ctx, idList);
            MakeInvoiceParam param = new MakeInvoiceParam();
            param.setBilBillIds(CollectionUtil.convertList2String(idList, ",", false));
            param.setBillBillEntryIds(CollectionUtil.convertList2String(entryIdList, ",", false));
            param.setInvoiceType("3");
            param.setPrint(false);
            param.setReq(isReq);
            param.setRuleIDs(combinRule);
            param.setSrcBosType("B4E229F6");
            param.setSrcSystem(IMConstant.SRCTYPE_IM_VEHICLEREQ);
            resp = IMInvoiceFacadeFactory.getLocalInstance(ctx).makeInvoice(param);
            if (resp.getMkSucessBillIds().size() > 0) {
                String isShowInvoiceUI = IMFacadeFactory.getLocalInstance(ctx).getParamByKey("isShowInvoiceUI");
                resp.getOtherData().put("isShowInvoiceUI", isShowInvoiceUI);
                if ("1".equals(isShowInvoiceUI)) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(resp.getMkSucessBillIds()), CompareType.INCLUDE));
                    String botpFilter = filter.toSql();
                    resp.getOtherData().put("botpFilter", URLEncoder.encode(botpFilter, "utf-8"));
                    resp.getOtherData().put("uipk", "com.kingdee.eas.tm.im.vehicleMakeInvoiceListPage");
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
            resp = new InvoiceRespInfo();
            resp.setErrorMsg(e.getMessage());
            resp.getBizFailBills().clear();
            resp.getBizFailBills().addAll(entryIdList);
        }
        finally {
            IMUtils.releaseLock(ctx, idList);
        }
        if (logMap.size() > 0) {
            ArrayList bizFailBills = resp.getBizFailBills();
            if (bizFailBills != null && bizFailBills.size() > 0) {
                int j2 = bizFailBills.size();
                for (int i = 0; i < j2; ++i) {
                    logMap.remove(String.valueOf(bizFailBills.get(i)));
                }
            }
            for (Map.Entry entry : logMap.entrySet()) {
                LogUtils.afterLog(ctx, (IObjectPK)entry.getValue());
            }
        }
        return resp;
    }

    @Override
    protected Map _checkBeforePrint(Context ctx, Map params) throws BOSException, EASBizException {
        List billIds = (List)params.get("billIds");
        List entryIds = (List)params.get("entryIds");
        Map<String, String> retValue = new HashMap<String, String>();
        Set invoiceIds = this.getInvoiceByBills(ctx, billIds, entryIds);
        if (invoiceIds.size() == 0) {
            retValue.put("errorMsg", new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "INVOICE_NOTFOUND", new String[0])}).getMessage());
            return retValue;
        }
        retValue = VehicleMakeInvoiceFacadeFactory.getLocalInstance(ctx).checkBeforePrint(invoiceIds);
        return retValue;
    }

    protected Set getInvoiceByBills(Context ctx, List ids, List entryIds) throws BOSException, EASBizException {
        Set<String> invoiceNoSet = this.getInvoiceNoListByBillIDSet(ctx, entryIds);
        String selectSQL = "SELECT relationEntry.FDestObjectID as invoiceID FROM T_IM_MakeInvoiceRelationEntry as relationEntry  INNER JOIN T_IM_VehicleMakeInvoice as invoice on invoice.fid = relationEntry.FDestObjectID  WHERE relationEntry.FSrcObjectID IN (" + InvoiceReqUtils.concat(ids) + ")  and relationEntry.FSrcEntryID in (" + InvoiceReqUtils.concat(entryIds) + ") and invoice.FStatus = '4' and invoice.FInvoiceNo in (" + InvoiceReqUtils.concat(invoiceNoSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        HashSet<String> invoiceIds = new HashSet<String>();
        try {
            String invoiceID = null;
            while (rs.next()) {
                invoiceID = rs.getString("invoiceID");
                invoiceIds.add(invoiceID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceIds;
    }

    protected Set<String> getInvoiceNoListByBillIDSet(Context ctx, List billIds) throws BOSException {
        try {
            String selectSQL = "select FInvoiceNo from t_im_vehicleinvoicereqentry where fid in (" + InvoiceReqUtils.concat(billIds) + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            HashSet<String> invoiceNoSet = new HashSet<String>();
            while (rs.next()) {
                String invoiceNo = rs.getString("FInvoiceNo");
                if (invoiceNo == null || "".equals(invoiceNo)) continue;
                String[] invoiceNoArr = invoiceNo.split(";");
                for (int i = 0; i < invoiceNoArr.length; ++i) {
                    invoiceNoSet.add(invoiceNoArr[i]);
                }
            }
            return invoiceNoSet;
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }
}

