/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.incomeinvoice.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IncomeInvoiceActionTypeEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceException;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.app.incomeinvoice.action.BaseAction;
import com.kingdee.eas.tm.im.param.ActionParam;
import com.kingdee.eas.tm.im.param.ActionResult;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ReceiveInvoiceAction
extends BaseAction {
    public ReceiveInvoiceAction(Context ctx) {
        super(ctx);
    }

    @Override
    public ActionResult execute(IncomeInvoiceActionTypeEnum actionType, ActionParam params) throws EASBizException, BOSException {
        ActionResult result = new ActionResult();
        if (IncomeInvoiceActionTypeEnum.SAME.equals((Object)actionType)) {
            result = this.same(params);
        } else if (IncomeInvoiceActionTypeEnum.REVERSE.equals((Object)actionType)) {
            result = this.reverse(params);
        }
        return result;
    }

    private ActionResult same(ActionParam params) throws EASBizException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getQueryInvoiceSQL(params));
        try {
            StringBuffer sql;
            UserInfo operUser;
            String operDate;
            if (rs.next()) {
                int FIsReceive = rs.getInt("FIsReceive");
                String FStatus = rs.getString("FStatus");
                String FCompanyID = rs.getString("FCompanyID");
                PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission(this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(FCompanyID), "im_incomeInvoice_receive");
                String FReceiveSeq = null;
                IncomeInvoiceInfo invoiceInfo = IncomeInvoiceFactory.getLocalInstance(this.ctx).getIncomeInvoiceInfo((IObjectPK)new ObjectUuidPK(params.getInvoiceId()));
                this.beginLog(rs, "im_incomeInvoice_receive");
                if ("5".equals(FStatus)) {
                    throw new IncomeInvoiceException(IncomeInvoiceException.RETURNINVOICEERROR);
                }
                if (FIsReceive == 1) {
                    throw new IncomeInvoiceException(IncomeInvoiceException.RECEIVEDINVOICEERROR);
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)this.ctx);
                CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)invoiceInfo, FCompanyID, "invoiceType", null);
                if (codingRule != null) {
                    FReceiveSeq = iCodingRuleManager.getNumber((IObjectValue)invoiceInfo, codingRule);
                } else {
                    codingRule = iCodingRuleManager.getCodingRule((IObjectValue)invoiceInfo, FCompanyID);
                    if (codingRule != null) {
                        FReceiveSeq = iCodingRuleManager.getNumber((IObjectValue)invoiceInfo, codingRule);
                    }
                }
                operDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
                operUser = ContextUtil.getCurrentUserInfo((Context)this.ctx);
                sql = new StringBuffer();
                sql.append(" UPDATE t_im_IncomeInvoice set");
                sql.append(" FIsReceive = 1 ,");
                sql.append(" FReceiveDate ={").append(operDate).append("} ,");
                if (FReceiveSeq != null) {
                    sql.append(" FReceiveSeq ='").append(FReceiveSeq).append("' ,");
                }
            } else {
                throw new IncomeInvoiceException(IncomeInvoiceException.NOTEXISTINVOICEERROR);
            }
            sql.append(" FReceiveUserID = '").append(operUser.getId().toString()).append("',");
            sql.append(" FIsReceiveAndAccept = case when FAcceptInvoiceDate is null then 1 else 0 end, ");
            sql.append(" FIsAccept = 1 ,");
            sql.append(" FAcceptInvoiceDate = case when FAcceptInvoiceDate is null then {").append(operDate).append("} else FAcceptInvoiceDate end ,");
            sql.append(" FAcceptUserID = case when FAcceptUserID is null then '").append(operUser.getId().toString()).append("' else FAcceptUserID end ");
            sql.append(this.getQueryInvoiceWhereSQL(params));
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            this.afterLog();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private ActionResult reverse(ActionParam params) throws EASBizException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getQueryInvoiceSQL(params));
        try {
            if (rs.next()) {
                int FIsReceive = rs.getInt("FIsReceive");
                String FAuthenticateStatus = rs.getString("FAuthenticateStatus");
                String FCheckState = rs.getString("FCheckState");
                String FCheckType = rs.getString("FCheckType");
                String FCompanyID = rs.getString("FCompanyID");
                PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission(this.ctx.getCaller(), (IObjectPK)new ObjectUuidPK(FCompanyID), "im_incomeInvoice_cancelreceive");
                this.beginLog(rs, "im_incomeInvoice_cancelreceive");
                if (FIsReceive == 0) {
                    throw new IncomeInvoiceException(IncomeInvoiceException.UNRECEIVEINVOICEERROR);
                }
                if ("2".equals(FAuthenticateStatus)) {
                    throw new IncomeInvoiceException(IncomeInvoiceException.AUTHENTICATEDINVOICEERROR);
                }
                if ("1".equals(FCheckState) && "0".equals(FCheckType)) {
                    throw new IncomeInvoiceException(IncomeInvoiceException.AUTHENTICATEDINVOICEERROR);
                }
            } else {
                throw new IncomeInvoiceException(IncomeInvoiceException.NOTEXISTINVOICEERROR);
            }
            this.recycleNumber(this.ctx, params);
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE t_im_IncomeInvoice set FIsReceive = 0 ,");
            sql.append(" FReceiveDate =null,FReceiveSeq =null,");
            sql.append(" FReceiveUserID = null,");
            sql.append(" FIsAccept = case when FIsReceiveAndAccept = 1 then 0 else FIsAccept end ,");
            sql.append(" FAcceptInvoiceDate = case when FIsReceiveAndAccept = 1 then null else FAcceptInvoiceDate end ,");
            sql.append(" FAcceptUserID = case when FIsReceiveAndAccept = 1 then null else FAcceptUserID end ,");
            sql.append(" FIsReceiveAndAccept = 0 ");
            sql.append(this.getQueryInvoiceWhereSQL(params));
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            this.afterLog();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void recycleNumber(Context ctx, ActionParam params) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT invoiceNumber,invoiceCode,receiveSeq,invoiceType,company.id,cu.id ");
        if (params.getInvoiceId() != null) {
            sql.append(" WHERE id = '").append(params.getInvoiceId()).append("' ");
        } else {
            sql.append(" WHERE invoiceNumber = '").append(params.getInvoiceNumber()).append("' ");
            sql.append(" and  invoiceCode = '").append(params.getInvoiceCode()).append("' ");
        }
        IncomeInvoiceInfo info = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceInfo(sql.toString());
        if (info.getReceiveSeq() != null) {
            String companyID = info.getCompany().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID, "invoiceType", null);
            if (codeRuleInfo == null) {
                codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, companyID);
                if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID) || codeRuleInfo.isIsaddnewbreak())) {
                    iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, info.getReceiveSeq());
                }
            } else if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID, "invoiceType") || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, "invoiceType", "", info.getReceiveSeq());
            }
        }
    }
}

