/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.incomeinvoice.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.IIncomeInvoice;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.app.incomeinvoice.plugin.IRevInv;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractRevInv
implements IRevInv {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.incomeinvoice.processor.AbstractRevInv");
    public static final String SUCCESS_CODE = "0000";

    protected IncomeInvoiceInfo getIncomeInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) throws BOSException {
        IncomeInvoiceInfo invoiceInfo = new IncomeInvoiceInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        IncomeInvoiceCollection coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        if (coll != null && coll.size() > 0) {
            invoiceInfo = coll.get(0);
        } else {
            invoiceInfo.setId(BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"1343913D")));
        }
        return invoiceInfo;
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String taxNumber) throws BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)taxNumber, CompareType.EQUALS));
        view.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        if (coll != null && coll.size() > 0) {
            companyOrgUnitInfo = coll.get(0);
        }
        return companyOrgUnitInfo;
    }

    protected IObjectPK saveOrUpdate(Context ctx, IncomeInvoiceInfo invoiceInfo) {
        IObjectPK pk = null;
        try {
            IIncomeInvoice iIncomeInvoice = IncomeInvoiceFactory.getLocalInstance(ctx);
            if (invoiceInfo.getId() == null || !iIncomeInvoice.exists((IObjectPK)new ObjectUuidPK(invoiceInfo.getId()))) {
                pk = iIncomeInvoice.addnew((CoreBaseInfo)invoiceInfo);
            } else {
                pk = new ObjectUuidPK(invoiceInfo.getId());
                iIncomeInvoice.update(pk, (CoreBaseInfo)invoiceInfo);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return pk;
    }

    protected JSONObject getJSONObject(JSONObject data, String key) {
        JSONObject value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONObject(key);
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected JSONArray getJSONArray(JSONObject data, String key) {
        JSONArray value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONArray(key);
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String getStringValue(JSONObject data, String key) {
        String value = null;
        if (data.has(key)) {
            try {
                String valueStr = data.getString(key);
                if (valueStr != null && valueStr.length() > 0) {
                    value = valueStr;
                }
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected BigDecimal getBigDecimalValue(String valueStr) {
        BigDecimal value = new BigDecimal(0);
        if (valueStr != null && valueStr.length() > 0) {
            value = new BigDecimal(valueStr);
        }
        return value;
    }

    protected Date getDateValue(String valueStr) {
        Date value = null;
        if (valueStr != null && valueStr.length() > 0) {
            try {
                value = new SimpleDateFormat("yyyy-MM-dd").parse(valueStr);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected boolean getBooleanValue(String valueStr) {
        boolean value = false;
        if ("1".equals(valueStr)) {
            value = true;
        }
        return value;
    }
}

