/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.incomeinvoice.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IncomeAuthenticateEnum;
import com.kingdee.eas.tm.im.IncomeAuthenticateStatusEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.app.incomeinvoice.plugin.AbstractRevInv;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceExpenseService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RevInv4BizExpenseAccount
extends AbstractRevInv {
    private static Logger logger = Logger.getLogger((String)RevInv4BizExpenseAccount.class.getName());

    @Override
    public void revInv(Context ctx, Map params) {
        block5: {
            String client_id = (String)params.get("client_id");
            String client_secret = (String)params.get("client_secret");
            String billId = (String)params.get("expense_num");
            String billNumber = (String)params.get("billNumber");
            HashMap<String, String> queryParamMap = new HashMap<String, String>();
            queryParamMap.put("billNumber", billNumber);
            try {
                PwyInvokeParam invokeParam = new PwyInvokeParam();
                invokeParam.setClientId(client_id);
                invokeParam.setClientSecret(client_secret);
                invokeParam.setMsgType("9007");
                invokeParam.setOwnerSystem("2");
                invokeParam.setParams(queryParamMap);
                invokeParam.setInit(true);
                IncomeInvoiceExpenseService pwyService = (IncomeInvoiceExpenseService)PwyServiceHelper.getPwyService(ctx, invokeParam);
                pwyService.invoke();
                JSONObject queryResultJson = new JSONObject(pwyService.getInvokeParam().getRevMsg());
                if (pwyService.isSuccess()) {
                    JSONArray invoiceArray = this.getJSONArray(queryResultJson, "data");
                    if (invoiceArray != null && invoiceArray.length() > 0) {
                        int size = invoiceArray.length();
                        for (int i = 0; i < size; ++i) {
                            IncomeInvoiceInfo invoiceInfo = this.parseHead(ctx, invoiceArray.getJSONObject(i));
                            if (invoiceInfo == null) continue;
                            this.saveOrUpdate(ctx, invoiceInfo);
                            String srcBillID = billId;
                            String srcBosType = "4A44F49F";
                            String destBillID = invoiceInfo.getId().toString();
                            String desBosType = "1343913D";
                            if (srcBillID == null || this.hasBotpRelation(ctx, srcBillID, destBillID, srcBosType, desBosType)) continue;
                            this.traceUpAndDown(ctx, srcBillID, destBillID, srcBosType, desBosType);
                        }
                    }
                    break block5;
                }
                logger.error((Object)"[RevInv4BizExpenseAccount] \u83b7\u53d6\u6536\u7968\u4fe1\u606f\u5931\u8d25\uff01");
                return;
            }
            catch (Exception e) {
                logger.error((Object)"[RevInv4BizExpenseAccount] \u6536\u7968\u5931\u8d25\uff01");
            }
        }
    }

    private boolean hasBotpRelation(Context ctx, String srcID, String destID, String srcEntityID, String destEntityID) throws BOSException {
        boolean hasRelation = false;
        String operateID = "unknown";
        int type = 0;
        String selectSQL = "";
        try {
            selectSQL = " SELECT FID FROM T_BOT_Relation WHERE FSRCENTITYID = '" + srcEntityID + "' and FDESTENTITYID = '" + destEntityID + "' and FOPERATORID = '" + operateID + "' and FTYPE = " + type + " and FDESTOBJECTID ='" + destID + "' and FSRCOBJECTID = '" + srcID + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.next()) {
                hasRelation = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("[RevInv4BizExpenseAccount] sql : " + selectSQL));
            throw new BOSException("excute sql error...");
        }
        return hasRelation;
    }

    private void traceUpAndDown(Context ctx, String srcId, String desId, String srcBosType, String desBosType) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setSrcEntityID(srcBosType);
        info.setDestEntityID(desBosType);
        info.setDestObjectID(desId);
        info.setOperatorID("unknown");
        info.setType(0);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
    }

    public Map getSfrz(String client_id, String client_secret) {
        HashMap<String, String> sfrzMap = new HashMap<String, String>();
        String timestamp = String.valueOf(new Date().getTime());
        timestamp = timestamp.substring(0, 10);
        String sign = this.StringToMD5(client_id + client_secret + timestamp);
        sfrzMap.put("client_id", client_id);
        sfrzMap.put("sign", sign);
        sfrzMap.put("timestamp", timestamp);
        return sfrzMap;
    }

    private String StringToMD5(String input) {
        String md5str = null;
        if (input == null) {
            return "";
        }
        byte[] bytes = input.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = md.digest(bytes);
            md5str = this.bytesToHex(buff);
        }
        catch (Exception e) {
            logger.error((Object)("[RevInv4BizExpenseAccount] " + e.getMessage()));
        }
        return md5str;
    }

    private String bytesToHex(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString();
    }

    private IncomeInvoiceInfo parseHead(Context ctx, JSONObject invoiceObject) {
        IncomeInvoiceInfo invoiceInfo = null;
        try {
            String invoiceCode = this.getStringValue(invoiceObject, "invoiceCode");
            String invoiceNumber = this.getStringValue(invoiceObject, "invoiceNo");
            invoiceInfo = this.getIncomeInvoiceInfo(ctx, invoiceCode, invoiceNumber);
            invoiceInfo.setInvoiceCode(invoiceCode);
            invoiceInfo.setInvoiceNumber(invoiceNumber);
            invoiceInfo.setBizDate(this.getDateValue(this.getStringValue(invoiceObject, "invoiceDate")));
            invoiceInfo.setTaxNumber(this.getStringValue(invoiceObject, "salerTaxNo"));
            invoiceInfo.setBillingCompany(this.getStringValue(invoiceObject, "salerName"));
            invoiceInfo.setContact(this.getStringValue(invoiceObject, "salerAddressPhone"));
            invoiceInfo.setBankInformation(this.getStringValue(invoiceObject, "salerAccount"));
            invoiceInfo.setAmount(this.getBigDecimalValue(this.getStringValue(invoiceObject, "amount")));
            invoiceInfo.setTax(this.getBigDecimalValue(this.getStringValue(invoiceObject, "taxAmount")));
            invoiceInfo.setAmountTax(invoiceInfo.getAmount().add(invoiceInfo.getTax()));
            invoiceInfo.setDescription(this.getStringValue(invoiceObject, "remark"));
            invoiceInfo.setIsIssue(this.getBooleanValue(this.getStringValue(invoiceObject, "proxyMark")));
            invoiceInfo.setPdfUrl(this.getStringValue(invoiceObject, "snapshotUrl"));
            String checkFlag = this.getStringValue(invoiceObject, "checkFlag");
            if ("1".equals(checkFlag)) {
                invoiceInfo.setIsCheck(false);
            } else if ("2".equals(checkFlag)) {
                invoiceInfo.setIsCheck(true);
                invoiceInfo.setCheckDate(this.getDateValue(this.getStringValue(invoiceObject, "checkTime")));
            }
            String authenticateFlag = this.getStringValue(invoiceObject, "authenticateFlag");
            if ("1".equals(authenticateFlag)) {
                invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.UNAUTHORIZED);
            } else if ("2".equals(authenticateFlag)) {
                invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.PASSED);
                invoiceInfo.setAuthenticateWay(IncomeAuthenticateEnum.MANUAL);
                invoiceInfo.setAuthenticateDate(this.getDateValue(this.getStringValue(invoiceObject, "authenticateTime")));
            } else if ("3".equals(authenticateFlag)) {
                invoiceInfo.setAuthenticateWay(IncomeAuthenticateEnum.SCAN);
                invoiceInfo.setAuthenticateStatus(IncomeAuthenticateStatusEnum.PASSED);
                invoiceInfo.setAuthenticateDate(this.getDateValue(this.getStringValue(invoiceObject, "authenticateTime")));
            }
            String buyerTaxNo = this.getStringValue(invoiceObject, "buyerTaxNo");
            CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(ctx, buyerTaxNo);
            invoiceInfo.setCompany(companyInfo);
            if (companyInfo == null) {
                logger.error((Object)("[RevInv4BizExpenseAccount] \u83b7\u53d6\u516c\u53f8\u5931\u8d25\uff01\u8d2d\u65b9\u7a0e\u53f7\uff1a" + buyerTaxNo));
                return null;
            }
            String state = this.getStringValue(invoiceObject, "invoiceStatus");
            if ("0".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.NORMAL);
            } else if ("1".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.LOSECONTROL);
            } else if ("2".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.CANCEL);
            } else if ("3".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.CREDIT);
            } else if ("4".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.UNUSUAL);
            } else if ("5".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.UNNORMAL);
            } else if ("6".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.UNCONFIRMRED);
            } else if ("7".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.PARTLYRED);
            } else if ("8".equals(state)) {
                invoiceInfo.setStatus(IncomeStatusEnum.FULLRED);
            }
            PwyHelper.setInvoiceType(invoiceInfo, this.getStringValue(invoiceObject, "invoiceType"));
            invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
            invoiceInfo.setIsInTax(true);
            invoiceInfo.setCurrentAccountType(CurrentAccountType.SUPPLIER);
            JSONArray itemsJsonArray = this.getJSONArray(invoiceObject, "items");
            if (itemsJsonArray != null && itemsJsonArray.length() > 0) {
                invoiceInfo.getEntries().clear();
                int size = itemsJsonArray.length();
                for (int j = 0; j < size; ++j) {
                    IncomeInvoiceEntryInfo entryInfo = this.parseEntry(itemsJsonArray.getJSONObject(j));
                    if (entryInfo == null) continue;
                    invoiceInfo.getEntries().add(entryInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"[RevInv4BizExpenseAccount] \u89e3\u6790\u53d1\u7968\u62a5\u9519\uff01");
        }
        return invoiceInfo;
    }

    private IncomeInvoiceEntryInfo parseEntry(JSONObject entryObject) {
        IncomeInvoiceEntryInfo entryInfo = null;
        try {
            entryInfo = new IncomeInvoiceEntryInfo();
            entryInfo.setProductName(this.getStringValue(entryObject, "goodsName"));
            entryInfo.setUnitName(this.getStringValue(entryObject, "unit"));
            entryInfo.setSpecs(this.getStringValue(entryObject, "specModel"));
            entryInfo.setQuantity(this.getBigDecimalValue(this.getStringValue(entryObject, "num")));
            String taxRate = this.getStringValue(entryObject, "taxRate");
            if (taxRate != null) {
                entryInfo.setTaxRate(this.getBigDecimalValue(taxRate));
            } else {
                entryInfo.setTaxRate(BigDecimal.ZERO);
            }
            entryInfo.setTaxExcluded(this.getBigDecimalValue(this.getStringValue(entryObject, "unitPrice")));
            entryInfo.setMoney(this.getBigDecimalValue(this.getStringValue(entryObject, "detailAmount")));
            entryInfo.setTaxAmt(this.getBigDecimalValue(this.getStringValue(entryObject, "taxAmount")));
            entryInfo.setTaxTotal(entryInfo.getMoney().add(entryInfo.getTaxAmt()));
            if (entryInfo.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
                entryInfo.setTaxPrice(entryInfo.getTaxTotal().divide(entryInfo.getQuantity()));
            } else {
                entryInfo.setTaxPrice(BigDecimal.ZERO);
            }
        }
        catch (Exception e) {
            logger.error((Object)"[RevInv4BizExpenseAccount] \u89e3\u6790\u53d1\u7968\u5206\u5f55\u62a5\u9519\uff01");
        }
        return entryInfo;
    }
}

