/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.plugin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.tm.im.InvoiceReqInfo;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginUtil;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import com.kingdee.eas.tm.im.basedata.ParamConfigBizBillTypeEnum;
import com.kingdee.eas.tm.im.basedata.util.InvoiceParamConfigUtil;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class InvoicePluginContext {
    private Context ctx = null;
    private InvoiceReqInfo invoiceReq = null;
    private ParamConfigBizBillTypeEnum bizBillType = null;
    private Map<String, InvoiceParamConfigInfo> paramConfigCache = new HashMap<String, InvoiceParamConfigInfo>();
    private Map<String, MultiMeasureUnitInfo> mutiMeasureUnitCache = new HashMap<String, MultiMeasureUnitInfo>();
    private Map<String, String> srcMap = new HashMap<String, String>();
    private Map<String, String> destMap = new HashMap<String, String>();
    private Map<String, BigDecimal> discountAmtMap = new HashMap<String, BigDecimal>();
    private int splitLimitAmtMaxCount = 10000;

    public InvoicePluginContext(Context ctx, InvoiceReqInfo invoiceReq) {
        this.ctx = ctx;
        this.invoiceReq = invoiceReq;
        if (IMConstant.SRCTYPE_FI_AR.equals(invoiceReq.getSrcSystem())) {
            this.bizBillType = ParamConfigBizBillTypeEnum.AROtherBill;
        } else if (IMConstant.SRCTYPE_IM_INVOICEREQ.equals(invoiceReq.getSrcSystem())) {
            this.bizBillType = ParamConfigBizBillTypeEnum.MakeInvoiceReq;
        }
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public InvoiceReqInfo getInvoiceReq() {
        return this.invoiceReq;
    }

    public void setInvoiceReq(InvoiceReqInfo invoiceReq) {
        this.invoiceReq = invoiceReq;
    }

    public ParamConfigBizBillTypeEnum getBizBillType() {
        return this.bizBillType;
    }

    public void setBizBillType(ParamConfigBizBillTypeEnum bizBillType) {
        this.bizBillType = bizBillType;
    }

    public MultiMeasureUnitInfo getMutiMeasureUnit(String materialID, String unitID) throws BOSException {
        if (this.mutiMeasureUnitCache.size() == 0) {
            Set<String> materialIDs = InvoicePluginUtil.getMaterialIDs(this.invoiceReq);
            this.mutiMeasureUnitCache = InvoicePluginUtil.betchFetchMutiMeasureUnit(this.ctx, materialIDs);
        }
        return this.mutiMeasureUnitCache.get(materialID + "_" + unitID);
    }

    public MeasureUnitInfo getBaseUnit(String materialID) throws BOSException {
        MultiMeasureUnitInfo multiMeasureUnitInfo;
        if (this.mutiMeasureUnitCache.size() == 0) {
            Set<String> materialIDs = InvoicePluginUtil.getMaterialIDs(this.invoiceReq);
            this.mutiMeasureUnitCache = InvoicePluginUtil.betchFetchMutiMeasureUnit(this.ctx, materialIDs);
        }
        return (multiMeasureUnitInfo = this.mutiMeasureUnitCache.get(materialID)) != null ? multiMeasureUnitInfo.getMeasureUnit() : null;
    }

    public InvoiceParamConfigInfo getInvoiceParam(String companyID) throws BOSException {
        String key = companyID + "_" + this.bizBillType.getValue();
        InvoiceParamConfigInfo paramConfigInfo = this.paramConfigCache.get(key);
        if (paramConfigInfo == null) {
            paramConfigInfo = InvoiceParamConfigUtil.getInvoiceParam(this.ctx, companyID, this.bizBillType);
            this.paramConfigCache.put(key, paramConfigInfo);
        }
        return paramConfigInfo;
    }

    public Map<String, String> getSrcMap() {
        return this.srcMap;
    }

    public void setSrcMap(Map<String, String> srcMap) {
        this.srcMap = srcMap;
    }

    public Map<String, String> getDestMap() {
        return this.destMap;
    }

    public void setDestMap(Map<String, String> destMap) {
        this.destMap = destMap;
    }

    public Map<String, BigDecimal> getDiscountAmtMap() {
        return this.discountAmtMap;
    }

    public void setDiscountAmtMap(Map<String, BigDecimal> discountAmtMap) {
        this.discountAmtMap = discountAmtMap;
    }

    public int getSplitLimitAmtMaxCount() {
        return this.splitLimitAmtMaxCount;
    }

    public void setSplitLimitAmtMaxCount(int splitLimitAmtMaxCount) {
        this.splitLimitAmtMaxCount = splitLimitAmtMaxCount;
    }
}

