/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.plugin.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.BillEntryReqInfo;
import com.kingdee.eas.tm.im.BillReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.app.plugin.IUnitConvertPlugin;
import com.kingdee.eas.tm.im.app.plugin.InvoicePluginContext;
import com.kingdee.eas.tm.im.basedata.InvoiceParamConfigInfo;
import com.kingdee.eas.tm.im.basedata.MeasureUnitCarryTypeEnum;
import com.kingdee.eas.tm.im.basedata.util.InvoiceParamConfigUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class UnitConvertPlugin
implements IUnitConvertPlugin {
    private static Logger logger = Logger.getLogger((String)"UnitConvertPlugin");
    protected InvoicePluginContext pluginContext = null;

    @Override
    public void setPluginContext(InvoicePluginContext pluginContext) {
        this.pluginContext = pluginContext;
    }

    @Override
    public void unitConvert(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryInfo entry, BillReqInfo billReq, BillEntryReqInfo entryReq) throws EASBizException, BOSException {
        String companyID = billReq.getCompanyID();
        InvoiceParamConfigInfo paramConfigInfo = this.pluginContext.getInvoiceParam(companyID);
        if (paramConfigInfo.getBizBillType() == null && MeasureUnitCarryTypeEnum.SourceBill.equals((Object)paramConfigInfo.getMeasureUnitCarryType())) {
            return;
        }
        MeasureUnitInfo oldMeasureUnitInfo = entry.getMeasureUnit();
        MeasureUnitInfo measureUnitInfo = null;
        if (MeasureUnitCarryTypeEnum.SourceBill.equals((Object)paramConfigInfo.getMeasureUnitCarryType())) {
            String measureUnitField = paramConfigInfo.getMeasureUnitField();
            if (InvoiceParamConfigUtil.bizBillTypeMap.get(paramConfigInfo.getBizBillType().getValue()).getDefaultMeasureUnit().equals(measureUnitField)) {
                return;
            }
            measureUnitInfo = (MeasureUnitInfo)entryReq.getObjectValue().get(measureUnitField.split("\\.")[1]);
        } else if (MeasureUnitCarryTypeEnum.ProductCode.equals((Object)paramConfigInfo.getMeasureUnitCarryType()) && entry.getEntryName() != null) {
            measureUnitInfo = entry.getEntryName().getUnit();
        }
        if (oldMeasureUnitInfo == null || measureUnitInfo == null) {
            if (measureUnitInfo != null) {
                entry.setMeasureUnit(measureUnitInfo);
                entry.setMakeInvoiceUnit(measureUnitInfo.getName());
            } else {
                entry.setMeasureUnit(null);
                entry.setMakeInvoiceUnit(null);
            }
            return;
        }
        entry.setMeasureUnit(measureUnitInfo);
        entry.setMakeInvoiceUnit(measureUnitInfo.getName());
        String materialID = entryReq.getMaterialID();
        if (StringUtils.isEmpty((String)materialID)) {
            return;
        }
        if (entry.getQuantity().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        if (RowType.DISCOUNT_ROW.equals((Object)entry.getBillRowType())) {
            return;
        }
        if (IMUtils.isEqual(oldMeasureUnitInfo, measureUnitInfo)) {
            return;
        }
        MultiMeasureUnitInfo oldMultiMeasureUnitInfo = this.pluginContext.getMutiMeasureUnit(entryReq.getMaterialID(), oldMeasureUnitInfo.getId().toString());
        MultiMeasureUnitInfo multiMeasureUnitInfo = this.pluginContext.getMutiMeasureUnit(entryReq.getMaterialID(), measureUnitInfo.getId().toString());
        if (oldMultiMeasureUnitInfo == null || multiMeasureUnitInfo == null) {
            return;
        }
        boolean calQtyByBaseQty = true;
        if (entryReq.getObjectValue() instanceof MakeInvoiceReqEntryInfo) {
            MakeInvoiceReqEntryInfo entryInfo = (MakeInvoiceReqEntryInfo)entryReq.getObjectValue();
            MeasureUnitInfo baseUnit = this.pluginContext.getBaseUnit(entryReq.getMaterialID());
            if (entryInfo.getBaseUnit() != null && baseUnit != null && !IMUtils.isEqual(baseUnit, entryInfo.getBaseUnit())) {
                calQtyByBaseQty = false;
            }
        }
        if (calQtyByBaseQty) {
            entry.setQuantity(entryReq.getBaseQty().divide(multiMeasureUnitInfo.getBaseConvsRate(), multiMeasureUnitInfo.getQtyPrecision(), 5));
        } else {
            entry.setQuantity(entry.getQuantity().multiply(oldMultiMeasureUnitInfo.getBaseConvsRate()).divide(multiMeasureUnitInfo.getBaseConvsRate()).setScale(multiMeasureUnitInfo.getQtyPrecision(), 5));
        }
        entry.setNoTaxPrice(entry.getNoTaxAmt().divide(entry.getQuantity(), 10, 4));
        entry.setPrice(entry.getPriceTax().divide(entry.getQuantity(), 10, 4));
    }
}

