/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.app.util.InvoiceScanUtil;
import com.kingdee.eas.tm.im.basedata.InvoiceScanException;
import com.kingdee.eas.tm.im.basedata.QrGenerateRecordFactory;
import com.kingdee.eas.tm.im.basedata.QrGenerateRecordInfo;
import com.kingdee.eas.tm.im.basedata.QrKeyRelationFactory;
import com.kingdee.eas.tm.im.basedata.QrKeyRelationInfo;
import com.kingdee.eas.tm.im.common.comm.service.util.CommUtil;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.PrecisionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceScanService {
    private static Logger logger = Logger.getLogger((String)InvoiceScanService.class.getName());

    public Map checkBeforeInvoiceScan(Context ctx, Map param) throws BOSException, EASBizException {
        List ids = (List)param.get("ids");
        if (ids == null || ids.size() == 0) {
            throw new InvoiceScanException(InvoiceScanException.EXP_PARAM_ERROR);
        }
        IObjectCollection bills = this.getObjectCollection(ctx, ids);
        if (bills.size() == 0) {
            throw new InvoiceScanException(InvoiceScanException.EXP_OBJECT_NOTFLOUD);
        }
        IObjectValue objectValue = null;
        CompanyOrgUnitInfo company = null;
        String bosType = BOSUuid.read((String)ids.get(0).toString()).getType().toString();
        ArrayList<String> printIds = new ArrayList<String>();
        HashSet<String> dimSet = new HashSet<String>();
        IObjectPK logPk = null;
        String printId = null;
        String billId = null;
        int size = bills.size();
        for (int i = 0; i < size; ++i) {
            objectValue = bills.getObject(i);
            company = (CompanyOrgUnitInfo)objectValue.getObjectValue("company");
            if (company == null) {
                throw new InvoiceScanException(InvoiceScanException.EXP_COMANY_ISNULL);
            }
            billId = objectValue.get("id").toString();
            logPk = LogUtils.beginLog(ctx, "invoiceScan", BOSObjectType.create((String)bosType), (IObjectPK)new ObjectUuidPK(billId), objectValue.getString("number"), this.getLogItem(bosType), company.getId().toString());
            printId = billId + "_" + (logPk != null ? logPk.toString() : "");
            printIds.add(printId);
            dimSet.add(InvoiceScanUtil.buildKey(objectValue, this.getHeadProp()));
        }
        if (dimSet.size() > 1) {
            throw new InvoiceScanException(InvoiceScanException.EXP_NOTSAME_COU_ACCT);
        }
        if (StringUtils.isEmpty((String)company.getTaxNumber())) {
            throw new InvoiceScanException(InvoiceScanException.EXP_TAXNUMBER_ISNULL, new Object[]{company.getName()});
        }
        IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(company.getId().toString(), this.getPermItem(bosType));
        this.initEnvironment(ctx, company, param);
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>();
        result.put("printIds", printIds);
        return result;
    }

    protected IObjectCollection getObjectCollection(Context ctx, List ids) throws BOSException, EASBizException {
        String bosType = BOSUuid.read((String)ids.get(0).toString()).getType().toString();
        ICoreBase iCoreBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelector(bosType));
        CoreBaseCollection coll = iCoreBase.getCollection(view);
        return coll;
    }

    protected SelectorItemCollection getSelector(String bosType) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.taxNumber"));
        int size = this.getHeadProp().size();
        for (int i = 0; i < size; ++i) {
            sic.add(new SelectorItemInfo(this.getHeadProp().get(i)));
        }
        sic.add(new SelectorItemInfo(this.getAmountField(bosType)));
        return sic;
    }

    protected String getAmountField(String bosType) {
        String amountField = "priceIncludingTaxLocal";
        if ("FC910EF3".equals(bosType)) {
            amountField = "amountLocal";
        }
        return amountField;
    }

    protected String getLogItem(String bosType) {
        String logItem = "im_makeInvoiceReq_invoiceScan";
        if ("FC910EF3".equals(bosType)) {
            logItem = "ar_otherbill_invoiceScan";
        }
        return logItem;
    }

    protected String getPermItem(String bosType) {
        String permItem = "im_makeInvoiceReq_invoiceScan";
        if ("FC910EF3".equals(bosType)) {
            permItem = "fi_ar_ArOtherbill_invoiceScan";
        }
        return permItem;
    }

    protected void initEnvironment(Context ctx, CompanyOrgUnitInfo company, Map param) throws EASBizException, BOSException {
        InvoiceScanUtil.initCloud(ctx, company, param);
        InvoiceScanUtil.syncQrKey(ctx, company, param);
    }

    protected List<String> getHeadProp() {
        ArrayList<String> headProp = new ArrayList<String>();
        headProp.add("company");
        headProp.add("asstActID");
        return headProp;
    }

    public Map getInvoiceScanData(Context ctx, Map param) throws BOSException, EASBizException {
        List printIds = (List)param.get("printIds");
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> logIds = new ArrayList<String>();
        String[] printIdValues = null;
        int size = printIds.size();
        for (int i = 0; i < size; ++i) {
            printIdValues = printIds.get(i).toString().split("_");
            ids.add(printIdValues[0]);
            logIds.add(printIdValues[1]);
        }
        if (ids.size() == 0) {
            throw new InvoiceScanException(InvoiceScanException.EXP_PARAM_ERROR);
        }
        IObjectCollection bills = this.getObjectCollection(ctx, ids);
        if (bills.size() == 0) {
            throw new InvoiceScanException(InvoiceScanException.EXP_OBJECT_NOTFLOUD);
        }
        String bosType = BOSUuid.read((String)((String)ids.get(0)).toString()).getType().toString();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)bills.getObject(0).getObjectValue("company");
        String qrKey = InvoiceScanUtil.getQrKeyFromCache(ctx, company.getTaxNumber());
        BigDecimal totalAmount = BigDecimal.ZERO;
        IObjectValue objectValue = null;
        int size2 = bills.size();
        for (int i = 0; i < size2; ++i) {
            objectValue = bills.getObject(i);
            totalAmount = totalAmount.add(IMUtils.isNullToZero(objectValue.getBigDecimal(this.getAmountField(bosType))));
        }
        QrGenerateRecordInfo recordInfo = new QrGenerateRecordInfo();
        recordInfo.setBillNo(CommUtil.nextId());
        recordInfo.setNumber(recordInfo.getBillNo());
        recordInfo.setBillType(InvoiceScanUtil.getBillType(bosType));
        recordInfo.setBillIDs(CollectionUtil.convertList2String(ids, ";", false));
        recordInfo.setTotalAmount(totalAmount);
        recordInfo.setCompany(company);
        recordInfo.setTaxNumber(company.getTaxNumber());
        recordInfo.setQrKey(qrKey);
        InvoiceScanUtil.generateQrUrl(ctx, recordInfo);
        QrGenerateRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)recordInfo);
        ObjectUuidPK logId = null;
        int size3 = logIds.size();
        for (int i = 0; i < size3; ++i) {
            logId = new ObjectUuidPK((String)logIds.get(i));
            LogUtils.afterLog(ctx, (IObjectPK)logId);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("recordInfo", recordInfo);
        result.put("totalAmount", IMUtils.getString("com.kingdee.eas.tm.im.basedata.InvoiceScanResource", "MSG_ReqAmount", ctx.getLocale(), new Object[]{PrecisionUtil.formatDecimal(recordInfo.getTotalAmount(), 2)}));
        return result;
    }

    public Map initCloudReWrite(Context ctx, Map param) throws EASBizException, BOSException {
        String serviceNumber = (String)param.get("serviceNumber");
        String publicKey = (String)param.get("publicKey");
        StringBuilder sql = new StringBuilder();
        sql.append(" update T_TM_RemoteService set FState = ?, FPublicKey = ? where Fnumber = ?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"2", publicKey, serviceNumber});
        return null;
    }

    public Map syncQrKeyReWrite(Context ctx, Map param) throws EASBizException, BOSException {
        List qrList = (List)param.get("qrList");
        if (qrList != null && qrList.size() > 0) {
            String[] qrValues = qrList.get(0).toString().split("_");
            QrKeyRelationInfo relationInfo = new QrKeyRelationInfo();
            relationInfo.setQrKey(qrValues[0]);
            relationInfo.setTaxNumber(qrValues[1]);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)relationInfo.getTaxNumber(), CompareType.EQUALS));
            if (!QrKeyRelationFactory.getLocalInstance(ctx).exists(filter)) {
                QrKeyRelationFactory.getLocalInstance(ctx).addnew(relationInfo);
            }
        }
        return null;
    }

    public String purchaseTitleCallBack(Context ctx, String dataJSON) throws EASBizException, BOSException {
        return InvoiceScanUtil.parsePurchaseTitle(ctx, dataJSON);
    }
}

