/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollBillBaseInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.InvoiceUpdateParams;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.constant.PoolSyncConstant;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncPwyHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class PoolSync4ExpenseService {
    public static TMTraceLogger logger = TMLoggerFactory.getTraceLogger((String)"PoolSync4ExpenseService");

    public void updateVoucherInfo(Map params) throws Exception {
        InvoiceUpdateParams updateParams = (InvoiceUpdateParams)params.get("params");
        if (!StringUtils.isEmpty((String)updateParams.getVoucherID())) {
            this.deleteVoucherInfo(params);
            this.saveVoucherInfo(params);
        } else {
            this.deleteVoucherInfo(params);
        }
    }

    protected void saveVoucherInfo(Map params) throws BOSException, EASBizException {
        Context ctx = (Context)params.get("ctx");
        String bizBillID = (String)params.get("bizBillID");
        InvoiceUpdateParams updateParams = (InvoiceUpdateParams)params.get("params");
        BizCollBillBaseInfo objectValue = this.getBillInfo(ctx, bizBillID);
        String companyId = objectValue.getApplierCompany().getId().toString();
        String bizBillNumber = objectValue.getNumber();
        List serialNoArray = this.getInvoiceSerialNoArray(ctx, bizBillID);
        VoucherInfo voucherInfo = this.getVoucherInfo(ctx, updateParams.getVoucherID());
        voucherInfo.setNumber(updateParams.getVoucherNumber());
        ArrayList<String> expenseIdArray = new ArrayList<String>();
        expenseIdArray.add(bizBillID);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("expenseIdArray", expenseIdArray);
        paramMap.put("voucherInfo", PoolSyncPwyHelper.getVoucherInfoMap(voucherInfo));
        paramMap.put("serialNoArray", serialNoArray);
        paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.EXPENSE);
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_SAVE_VOUCHER);
        actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
        actionParam.setBillId(bizBillID);
        actionParam.setBillNumber(bizBillNumber);
        actionParam.setOrgId(companyId);
        actionParam.setParams(paramMap);
        PoolSyncUtil.poolAsyncCall(ctx, actionParam);
    }

    protected void deleteVoucherInfo(Map params) throws BOSException, EASBizException {
        Context ctx = (Context)params.get("ctx");
        String bizBillID = (String)params.get("bizBillID");
        Map oldVoucherMap = (Map)params.get("oldVoucherMap");
        if (StringUtils.isEmpty((String)((String)oldVoucherMap.get("voucherId")))) {
            return;
        }
        BizCollBillBaseInfo objectValue = this.getBillInfo(ctx, bizBillID);
        String companyId = objectValue.getApplierCompany().getId().toString();
        String bizBillNumber = objectValue.getNumber();
        ArrayList<String> expenseIdArray = new ArrayList<String>();
        expenseIdArray.add(bizBillID);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("expenseIdArray", expenseIdArray);
        paramMap.put("voucherId", oldVoucherMap.get("voucherId"));
        paramMap.put("voucherNumber", oldVoucherMap.get("voucherNumber"));
        paramMap.put("sourceType", PoolSyncConstant.SourceTypeEnum.EXPENSE);
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_FPZS_DEL_VOUCHER);
        actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
        actionParam.setBillId(bizBillID);
        actionParam.setBillNumber(bizBillNumber);
        actionParam.setOrgId(companyId);
        actionParam.setParams(paramMap);
        PoolSyncUtil.poolAsyncCall(ctx, actionParam);
    }

    protected BizCollBillBaseInfo getBillInfo(Context ctx, String bizBillID) throws BOSException {
        HashSet<String> billIdSet = new HashSet<String>();
        billIdSet.add(bizBillID);
        IObjectCollection billCollection = PoolSyncUtil.getBillCollection(ctx, billIdSet, this.getBillSelectors());
        BizCollBillBaseInfo objectValue = null;
        if (billCollection.size() > 0) {
            objectValue = (BizCollBillBaseInfo)billCollection.getObject(0);
        }
        if (objectValue == null) {
            String msg = "BizCollBillBaseInfo not Found,bizBillID:" + bizBillID;
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        if (objectValue.getApplierCompany() == null) {
            String msg = "BizCollBillBaseInfo applierCompany is null,bizBillID:" + bizBillID;
            logger.error((Object)msg);
            throw new BOSException(msg);
        }
        return objectValue;
    }

    protected List getInvoiceSerialNoArray(Context ctx, String bizBillID) throws BOSException {
        HashSet<String> billIdSet = new HashSet<String>();
        billIdSet.add(bizBillID);
        List invoiceList = PoolSyncUtil.getInvoiceList(ctx, billIdSet);
        Map invoiceObject = null;
        String serialNo = null;
        ArrayList<String> serialNoArray = new ArrayList<String>();
        for (int i = 0; i < invoiceList.size(); ++i) {
            invoiceObject = (Map)invoiceList.get(i);
            serialNo = (String)invoiceObject.get("FSERIALNO");
            serialNoArray.add(serialNo);
        }
        return serialNoArray;
    }

    protected VoucherInfo getVoucherInfo(Context ctx, String voucherId) throws BOSException {
        HashSet<String> voucherIdSet = new HashSet<String>();
        voucherIdSet.add(voucherId);
        VoucherCollection voucherCollection = PoolSyncUtil.getVoucherCollection(ctx, voucherIdSet);
        VoucherInfo voucherInfo = null;
        if (voucherCollection.size() > 0) {
            voucherInfo = voucherCollection.get(0);
        }
        return voucherInfo;
    }

    protected SelectorItemCollection getBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("applierCompany"));
        return sic;
    }
}

