/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolSyncUtil;
import org.apache.log4j.Logger;

public class PoolSyncJobHandler
implements IJobHandler {
    private static Logger logger = Logger.getLogger(PoolSyncJobHandler.class);

    public Object execute(Job job) throws Exception {
        Context ctx = job.getContext();
        try {
            this.processTaskWithNewTx(ctx, job);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            String title = job.getTitle();
            String msgBody = this.getExceptionStackTrace(e);
            this.sendMsg(ctx, title, msgBody);
            throw e;
        }
        return null;
    }

    protected void processTaskWithNewTx(Context ctx, Job job) throws Exception {
        EJBTransactionProxy.invokeByManual((Object)new PoolSyncJobHandler(), (String)"processTask", (Class[])new Class[]{Context.class, Job.class}, (Object[])new Object[]{ctx, job}, (int)3);
    }

    protected void processTask(Context ctx, Job job) throws Exception {
        JobParam jobParam = (JobParam)job.getParameters();
        PwyActionParam actionParam = (PwyActionParam)jobParam.getBizParam();
        PoolSyncUtil.poolSyncCall(ctx, actionParam);
    }

    protected String getExceptionStackTrace(Exception e) {
        while (e.getCause() != null) {
            e = (Exception)e.getCause();
        }
        StackTraceElement[] stack = e.getStackTrace();
        StringBuilder sb = new StringBuilder(5000);
        sb.append("LocalTaskJobHandler execute failure !\r\n");
        sb.append(e.getMessage() + "\r\n");
        return sb.toString();
    }

    protected void sendMsg(Context ctx, String title, String msgBody) throws EASBizException, BOSException {
    }
}

