/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.MatchTccStrategyEnum;
import com.kingdee.eas.tm.im.util.LCSUtil;
import org.apache.log4j.Logger;

public class ProductCodeMatchTccCodeStrategy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.app.service.ProductCodeMatchTccCodeStrategy");

    public TaxClassificationCodeInfo getProductTccCode(ProductCodeInfo product, TaxClassificationCodeCollection taxCodeColl, MatchTccStrategyEnum matchTccStrategy) {
        TaxClassificationCodeInfo tccInfo = null;
        if (MatchTccStrategyEnum.ExactMatch.equals((Object)matchTccStrategy)) {
            if (taxCodeColl.size() == 1) {
                tccInfo = taxCodeColl.get(0);
            }
        } else if (MatchTccStrategyEnum.KeyMatch.equals((Object)matchTccStrategy)) {
            if (taxCodeColl.size() == 1) {
                tccInfo = taxCodeColl.get(0);
            } else if (taxCodeColl.size() > 1) {
                String productName = product.getName();
                int lcsLength = 0;
                TaxClassificationCodeInfo info = null;
                int size = taxCodeColl.size();
                for (int i = 0; i < size; ++i) {
                    info = taxCodeColl.get(i);
                    lcsLength = LCSUtil.lcsLength(productName, info.getKey());
                    info.setInt("lcsLength", lcsLength);
                }
                taxCodeColl.sort("lcsLength");
                TaxClassificationCodeInfo last = taxCodeColl.get(taxCodeColl.size() - 1);
                TaxClassificationCodeInfo pre = taxCodeColl.get(taxCodeColl.size() - 2);
                if (last.getInt("lcsLength") > pre.getInt("lcsLength")) {
                    tccInfo = taxCodeColl.get(taxCodeColl.size() - 1);
                }
            }
        } else if (MatchTccStrategyEnum.firstMatch.equals((Object)matchTccStrategy) && taxCodeColl.size() > 0) {
            tccInfo = taxCodeColl.get(0);
        }
        return tccInfo;
    }
}

