/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.csinterface.webservice.WSBillMappingInfo;
import com.kingdee.eas.csinterface.webservice.app.handler.user.IERPUserHandler;
import com.kingdee.eas.csinterface.webservice.app.webservice.model.ReturnModel;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.util.IMConvertUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class RequestBillRelationService
extends IERPUserHandler {
    private static Logger logger = Logger.getLogger(RequestBillRelationService.class);
    private Map recRelationMap;
    private List<Set<String>> invoiceGroup = new ArrayList<Set<String>>();
    private List<String> recDataKeyList;
    private Map<String, String> sysInvSupMap = new HashMap<String, String>();
    private Map<String, String> cqInvSupMap = new HashMap<String, String>();
    private String dataString = "";
    private Set<String> unConfirmInvoiceBill = new HashSet<String>();
    private static final String NEXTLINE = ";\r\n";
    private static Map<String, Class> classMap = new HashMap<String, Class>();
    private IncomeInvoiceCollection coll = null;

    public Object handleOriginal(Context ctx, Object data) throws Exception {
        ArrayList idsList = (ArrayList)data;
        HashSet idSet = IMUtils.list2Set(idsList);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("invoiceCode"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        this.coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        return this.coll;
    }

    public List<ReturnModel> handleResult(Context ctx, WSBillMappingInfo wsb, Object data, String pkField) throws BOSException {
        if (data == null) {
            ctx.put((Object)"RequestBillRelationMsg", (Object)ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"CQPurCloud_DataIsNull", (Locale)ctx.getLocale()));
            return null;
        }
        this.recRelationMap = new HashMap();
        this.invoiceGroup = new ArrayList<Set<String>>();
        this.recDataKeyList = new ArrayList<String>();
        this.sysInvSupMap = new HashMap<String, String>();
        this.cqInvSupMap = new HashMap<String, String>();
        Map parseMap = null;
        try {
            parseMap = this.parseJsonData(ctx, data);
        }
        catch (Exception e) {
            logger.error((Object)("[RequestBillRelation]parseDataError:" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (parseMap.get("errorMsg") != null) {
            ctx.put((Object)"RequestBillRelationMsg", (Object)parseMap.get("errorMsg").toString());
            return null;
        }
        Set invoiceNoSet = new HashSet();
        invoiceNoSet = (Set)parseMap.get("invoiceNoSet");
        if (invoiceNoSet.size() == 0) {
            if (this.unConfirmInvoiceBill.size() > 0) {
                String unconfirmError = this.removeUnConfirmInvoice(ctx);
                ArrayList<Integer> successFailCount = new ArrayList<Integer>();
                successFailCount.add(0);
                successFailCount.add(this.unConfirmInvoiceBill.size());
                ctx.put((Object)"successFailCount", successFailCount);
                ctx.put((Object)"RequestBillRelationDetailMsg", (Object)unconfirmError);
                return null;
            }
            ctx.put((Object)"RequestBillRelationMsg", (Object)ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceDataMayLost", (Locale)ctx.getLocale()));
            return null;
        }
        Map msgMap = this.handleBizResult(ctx, parseMap, data);
        String mainMsg = "";
        String detailMsg = "";
        if (msgMap.get("mainMsg") != null) {
            mainMsg = msgMap.get("mainMsg").toString();
            ctx.put((Object)"RequestBillRelationMsg", (Object)mainMsg);
        }
        if (msgMap.get("successFailCount") != null) {
            ctx.put((Object)"successFailCount", msgMap.get("successFailCount"));
        }
        if (msgMap.get("detailMsg") != null) {
            detailMsg = msgMap.get("detailMsg").toString();
            ctx.put((Object)"RequestBillRelationDetailMsg", (Object)detailMsg);
        }
        return null;
    }

    public Map handleBizResult(Context ctx, Map paramMap, Object data) throws BOSException {
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        Map classifyMap = this.classifyInvoice(ctx, paramMap);
        if (classifyMap.get("errorMsg") != null) {
            msgMap.put("mainMsg", classifyMap.get("errorMsg").toString());
            return msgMap;
        }
        HashSet<String> unpassInvoice = new HashSet();
        Set systemExists = new HashSet();
        unpassInvoice = (Set)classifyMap.get("systemNotExists");
        systemExists = (Set)classifyMap.get("systemExists");
        String compareSupplierMsg = "";
        ArrayList<Set<String>> invoiceFullGroup = new ArrayList<Set<String>>();
        invoiceFullGroup.addAll(this.invoiceGroup);
        int invoiceNotEnough = 0;
        compareSupplierMsg = this.compareSupplier(ctx, unpassInvoice);
        if (unpassInvoice.size() > 0) {
            ArrayList<Integer> unpassGroupIndex = new ArrayList<Integer>();
            String key = "";
            Iterator iter = unpassInvoice.iterator();
            block2: while (iter.hasNext()) {
                key = iter.next().toString();
                int j = this.invoiceGroup.size();
                for (int i = 0; i < j; ++i) {
                    if (!this.invoiceGroup.get(i).contains(key)) continue;
                    unpassGroupIndex.add(i);
                    continue block2;
                }
            }
            if (unpassGroupIndex.size() > 0) {
                LinkedHashSet hashSet = new LinkedHashSet(unpassGroupIndex);
                ArrayList listNoDuplicates = new ArrayList(hashSet);
                invoiceNotEnough = listNoDuplicates.size();
                int j = listNoDuplicates.size();
                for (int i = 0; i < j; ++i) {
                    this.recRelationMap.remove(this.recDataKeyList.get((Integer)listNoDuplicates.get(i)));
                    invoiceFullGroup.remove((Integer)listNoDuplicates.get(i));
                }
                this.writeLog("[RequestBillRelation]:recDataKeyList:" + this.recDataKeyList.toString() + "  listNoDuplicates:" + listNoDuplicates.toString());
            }
        }
        String unconfirmError = this.removeUnConfirmInvoice(ctx);
        String msg = "";
        Object createAPReturn = null;
        try {
            if (this.recRelationMap.size() > 0) {
                String dataToAP = this.reBuildJsonObject(ctx);
                String createAPClass = "com.kingdee.eas.fi.arap.fromeip.impl.CreatApReceive";
                Class clazz = this.getClass(createAPClass);
                if (clazz == null) {
                    msg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"updateARAPPatch", (Locale)ctx.getLocale());
                    msgMap.put("mainMsg", msg);
                    return msgMap;
                }
                Object instance = clazz.newInstance();
                Method method = instance.getClass().getMethod("handleOriginal", Context.class, Object.class);
                createAPReturn = method.invoke(instance, ctx, dataToAP);
            }
            this.writeLog("[createAPReturn][recRelationMap]Size:" + this.recRelationMap.size() + "  [return]:" + createAPReturn);
            msg = this.buildErrorMsg(ctx, createAPReturn, compareSupplierMsg, invoiceFullGroup, unconfirmError);
        }
        catch (Exception e) {
            this.writeLog("[createAPReturn]:genAPOtherBillFailed:" + createAPReturn);
            logger.error((Object)("[createAPReturn]:genAPFailedCause:" + e.getMessage()), (Throwable)e);
            msg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"AP_GenAPOtherBillError", (Locale)ctx.getLocale());
            msgMap.put("mainMsg", msg);
            return msgMap;
        }
        ArrayList<Integer> successFailCount = new ArrayList<Integer>();
        successFailCount.add(this.recRelationMap.size() - invoiceFullGroup.size());
        successFailCount.add(invoiceNotEnough + this.unConfirmInvoiceBill.size() + invoiceFullGroup.size());
        msgMap.put("successFailCount", successFailCount);
        msgMap.put("detailMsg", msg);
        return msgMap;
    }

    private Map parseJsonData(Context ctx, Object data) throws BOSException {
        this.writeLog("[RequestBillRelation]:parseData start");
        HashMap<String, Object> parseMap = new HashMap<String, Object>();
        Map receiveMap = IMConvertUtils.convertJsonToMap(ctx, data);
        this.dataString = receiveMap.get("message").toString();
        Map dataMap = IMConvertUtils.convertJsonToMap(ctx, this.dataString);
        dataMap = (Map)dataMap.get("data");
        if (dataMap.get("instock") != null) {
            this.recRelationMap = (Map)dataMap.get("instock");
        }
        if (dataMap.get("receipt") != null) {
            this.recRelationMap = (Map)dataMap.get("receipt");
        }
        HashMap billGroupData = new HashMap();
        if (this.recRelationMap == null || this.recRelationMap.size() == 0) {
            parseMap.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"BillRelationIsNull", (Locale)ctx.getLocale()));
            return parseMap;
        }
        HashSet<String> invoiceCodeNoSet = new HashSet<String>();
        HashSet invoiceNoSet = new HashSet();
        this.invoiceGroup = new ArrayList<Set<String>>();
        HashSet<String> sameGroup = new HashSet<String>();
        HashSet<String> companyNumberSet = new HashSet<String>();
        String companyNumber = "";
        Iterator it = this.recRelationMap.keySet().iterator();
        Map relation = new HashMap();
        String key = "";
        List invoiceCode = new ArrayList();
        List invoiceNo = new ArrayList();
        String supplierNumber = null;
        while (it.hasNext()) {
            key = it.next().toString();
            relation = (Map)this.recRelationMap.get(key);
            int isConfirm = Double.valueOf(relation.get("isConfirm").toString()).intValue();
            if (isConfirm == 0) {
                this.unConfirmInvoiceBill.add(key);
                continue;
            }
            this.recDataKeyList.add(key);
            companyNumber = relation.get("companyNumber").toString();
            companyNumberSet.add(companyNumber);
            invoiceCode = (List)relation.get("invoiceCode");
            invoiceNo = (List)relation.get("invoiceNo");
            supplierNumber = (String)relation.get("supplierNumber");
            sameGroup = new HashSet();
            int j = invoiceCode.size();
            for (int i = 0; i < j; ++i) {
                sameGroup.add((String)invoiceCode.get(i) + "_" + (String)invoiceNo.get(i));
                invoiceCodeNoSet.add((String)invoiceCode.get(i) + "_" + (String)invoiceNo.get(i));
                this.cqInvSupMap.put((String)invoiceCode.get(i) + "_" + (String)invoiceNo.get(i), supplierNumber);
                invoiceNoSet.add(invoiceNo.get(i));
            }
            this.invoiceGroup.add(sameGroup);
        }
        parseMap.put("invoiceCodeNoSet", invoiceCodeNoSet);
        parseMap.put("invoiceNoSet", invoiceNoSet);
        this.writeLog("[RequestBillRelation]:parseData end");
        return parseMap;
    }

    protected String reBuildJsonObject(Context ctx) throws BOSException {
        HashMap parseMap = new HashMap();
        Map receiveMap = IMConvertUtils.convertJsonToMap(ctx, this.dataString);
        Map dataMap = (Map)receiveMap.get("data");
        dataMap.put("instock", this.recRelationMap);
        JSONObject json = JSONObject.fromObject((Object)receiveMap);
        return json.toString();
    }

    protected String buildErrorMsg(Context ctx, Object createAPReturn, String compareSupplierMsg, List<Set<String>> invoiceFullGroup, String unconfirmError) throws BOSException {
        Iterator<Object> it;
        StringBuffer msgSB = new StringBuffer();
        StringBuffer genAPFailedSB = new StringBuffer();
        String reason = null;
        String invCodeNo = "";
        HashMap<String, String> reasonMap = new HashMap<String, String>();
        String key = "";
        String[] invCodeNoSplit = null;
        if (createAPReturn != null) {
            Map createAPMap = IMConvertUtils.convertJsonToMap(ctx, createAPReturn);
            Map receiptMap = (Map)createAPMap.get("receipt");
            Map instockMap = (Map)createAPMap.get("instock");
            Map mainMap = new HashMap();
            if (receiptMap != null) {
                mainMap = receiptMap;
            }
            if (instockMap != null) {
                mainMap = instockMap;
            }
            Map tempMap = new HashMap();
            List invoiceCodeList = new ArrayList();
            List invoiceNoList = new ArrayList();
            String apOtherBillNumber = "";
            it = mainMap.keySet().iterator();
            block0: while (it.hasNext()) {
                key = it.next().toString();
                tempMap = (Map)mainMap.get(key);
                invoiceCodeList = (List)tempMap.get("invoiceCode");
                invoiceNoList = (List)tempMap.get("invoiceNo");
                reason = (String)tempMap.get("reason");
                if (StringUtils.isEmpty((String)reason)) {
                    if (invoiceCodeList.size() <= 0 || invoiceNoList.size() <= 0) continue;
                    invCodeNo = (String)invoiceCodeList.get(0) + "_" + (String)invoiceNoList.get(0);
                    int j = invoiceFullGroup.size();
                    for (int i = 0; i < j; ++i) {
                        if (!invoiceFullGroup.get(i).contains(invCodeNo)) continue;
                        invoiceFullGroup.remove(i);
                        continue block0;
                    }
                    continue;
                }
                if (invoiceCodeList.size() <= 0 || invoiceNoList.size() <= 0) continue;
                invCodeNo = (String)invoiceCodeList.get(0) + "_" + (String)invoiceNoList.get(0);
                reasonMap.put(invCodeNo, reason);
            }
        }
        if (!StringUtils.isEmpty((String)compareSupplierMsg)) {
            msgSB.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"supplierNotSameWithCQ", (Locale)ctx.getLocale())).append(NEXTLINE);
            msgSB.append(compareSupplierMsg).append(NEXTLINE);
        }
        if (!StringUtils.isEmpty((String)unconfirmError)) {
            msgSB.append(unconfirmError).append(NEXTLINE);
        }
        if (invoiceFullGroup.size() > 0 && createAPReturn != null) {
            StringBuffer invoiceCodeNoSB = new StringBuffer();
            genAPFailedSB.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"genAPOtherBillStepFailed", (Locale)ctx.getLocale())).append(NEXTLINE);
            String invoiceCoNo = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceCodeOrNumber", (Locale)ctx.getLocale());
            int j = invoiceFullGroup.size();
            for (int i = 0; i < j; ++i) {
                invoiceCodeNoSB.setLength(0);
                it = invoiceFullGroup.get(i).iterator();
                reason = "";
                while (it.hasNext()) {
                    invCodeNo = it.next().toString();
                    if (reasonMap.containsKey(invCodeNo)) {
                        reason = (String)reasonMap.get(invCodeNo);
                    }
                    invCodeNoSplit = invCodeNo.split("_");
                    invoiceCodeNoSB.append(invCodeNoSplit[0] + "  " + invCodeNoSplit[1]).append(NEXTLINE);
                }
                genAPFailedSB.append(reason).append(NEXTLINE);
                genAPFailedSB.append(invoiceCoNo).append(NEXTLINE);
                genAPFailedSB.append(invoiceCodeNoSB.toString()).append(NEXTLINE);
            }
            if (msgSB.length() > 0) {
                msgSB.append(NEXTLINE);
            }
            msgSB.append(genAPFailedSB.toString());
        }
        return msgSB.toString();
    }

    public Map classifyInvoice(Context ctx, Map paramMap) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        Set invoiceCodeNoSet = (Set)paramMap.get("invoiceCodeNoSet");
        Set invoiceNoSet = (Set)paramMap.get("invoiceNoSet");
        HashSet<String> systemNotExists = new HashSet<String>();
        HashSet<String> systemExists = new HashSet<String>();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceCode"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("currAcctSupplier.id"));
        sic.add(new SelectorItemInfo("currAcctSupplier.number"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNoSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        IncomeInvoiceCollection invoiceColl = null;
        try {
            invoiceColl = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(viewInfo);
        }
        catch (BOSException e) {
            retMap.put("errorMsg", e.getCause().toString());
            this.writeLog("[classifyInvoice]:" + e.getCause().toString());
            return retMap;
        }
        if (invoiceColl == null || invoiceColl.size() == 0) {
            retMap.put("errorMsg", ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceDataMayLost", (Locale)ctx.getLocale()));
            this.writeLog("[classifyInvoice]:invoiceColl size is zero");
            return retMap;
        }
        HashSet<String> searchInvoiceSet = new HashSet<String>();
        IncomeInvoiceInfo info = null;
        int j = invoiceColl.size();
        for (int i = 0; i < j; ++i) {
            info = invoiceColl.get(i);
            searchInvoiceSet.add(info.getInvoiceCode() + "_" + info.getInvoiceNumber());
            if (info.getCurrAcctSupplier() == null) {
                this.sysInvSupMap.put(info.getInvoiceCode() + "_" + info.getInvoiceNumber(), "");
                continue;
            }
            this.sysInvSupMap.put(info.getInvoiceCode() + "_" + info.getInvoiceNumber(), info.getCurrAcctSupplier().getNumber());
        }
        Iterator iter = invoiceCodeNoSet.iterator();
        String key = "";
        while (iter.hasNext()) {
            key = iter.next().toString();
            if (searchInvoiceSet.contains(key)) {
                systemExists.add(key);
                continue;
            }
            systemNotExists.add(key);
        }
        this.writeLog("[systemExists]:" + ((Object)systemExists).toString());
        retMap.put("systemExists", systemExists);
        this.writeLog("[systemNotExists]:" + ((Object)systemNotExists).toString());
        retMap.put("systemNotExists", systemNotExists);
        return retMap;
    }

    public Class getClass(String className) {
        Class<?> clazz = classMap.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                classMap.put(className, clazz);
            }
            catch (Exception e) {
                logger.error((Object)("[RequestBillRelation]className:" + className + "  ClassNotFound"));
            }
        }
        return clazz;
    }

    protected String compareSupplier(Context ctx, Set<String> unpassInvoice) {
        String compareSupplierMsg = "";
        Iterator<String> it = this.sysInvSupMap.keySet().iterator();
        String key = "";
        String sysSupplierNumber = "";
        String cqInvSupplierNumber = "";
        StringBuffer errorSB = new StringBuffer();
        String[] invoiceSplit = null;
        while (it.hasNext()) {
            key = it.next().toString();
            sysSupplierNumber = this.sysInvSupMap.get(key);
            if (sysSupplierNumber.equals(cqInvSupplierNumber = this.cqInvSupMap.get(key))) continue;
            unpassInvoice.add(key);
            invoiceSplit = key.split("_");
            errorSB.append(invoiceSplit[0] + "  " + invoiceSplit[1]).append(NEXTLINE);
        }
        if (errorSB.length() > 0) {
            compareSupplierMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"InvoiceCodeOrNumber", (Locale)ctx.getLocale()) + NEXTLINE + errorSB.toString();
        }
        return compareSupplierMsg;
    }

    protected String removeUnConfirmInvoice(Context ctx) {
        String errorMsg = null;
        StringBuffer errorSB = new StringBuffer();
        Iterator<String> it = this.unConfirmInvoiceBill.iterator();
        String invNumber = null;
        while (it.hasNext()) {
            invNumber = it.next().toString();
            this.recRelationMap.remove(invNumber);
            errorSB.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"invoiceBillNumber", (Locale)ctx.getLocale(), (Object[])new Object[]{invNumber})).append(NEXTLINE);
        }
        if (errorSB.length() > 0) {
            errorMsg = ResourceBase.getString((String)"com.kingdee.eas.tm.im.IncomeInvoiceResource", (String)"genAPFailed_invoiceUnReceived", (Locale)ctx.getLocale()) + NEXTLINE + errorSB.toString();
        }
        return errorMsg;
    }

    protected void writeLog(String log) {
        logger.error((Object)log);
    }
}

