/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.common.model.SplitLimitAmtParams;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class SplitLimitAmtService {
    private static Logger logger = Logger.getLogger(SplitLimitAmtService.class);
    private SplitLimitAmtParams params = null;

    public SplitLimitAmtService(SplitLimitAmtParams params) {
        this.params = params;
    }

    public abstract void splitLimitAmtEntry(MakeInvoiceInfo var1, MakeInvoiceEntryCollection var2, MakeInvoiceEntryCollection var3, MakeInvoiceEntryInfo var4, MakeInvoiceEntryInfo var5) throws EASBizException, BOSException;

    protected void splitDiscountEntry(MakeInvoiceInfo makeInvoice, MakeInvoiceEntryCollection oldEntrys, MakeInvoiceEntryCollection newEntrs, MakeInvoiceEntryInfo oldEntry, MakeInvoiceEntryInfo newEntry, BigDecimal beforeAmt, MakeInvoiceEntryCollection curNewEntrs) {
        String id = oldEntry.getId().toString();
        String discountEntryID = this.params.getSrcMap().get(id);
        if (discountEntryID == null) {
            return;
        }
        MakeInvoiceEntryCollection entrys = makeInvoice.getEntries();
        MakeInvoiceEntryInfo entry = null;
        for (int i = 0; i < entrys.size() && !discountEntryID.equals((entry = entrys.get(i)).getId().toString()); ++i) {
        }
        if (entry == null) {
            return;
        }
        MakeInvoiceEntryInfo finaEntry = null;
        for (int i = 0; i < oldEntrys.size() && !discountEntryID.equals((finaEntry = oldEntrys.get(i)).getId().toString()); ++i) {
        }
        if (finaEntry == null) {
            return;
        }
        MakeInvoiceEntryInfo discountEntry = (MakeInvoiceEntryInfo)entry.clone();
        BigDecimal ratio = newEntry.getPriceTax().divide(beforeAmt, 20, 4);
        discountEntry.setPriceTax(finaEntry.getPriceTax().multiply(ratio).setScale(2, 4));
        discountEntry.setNoTaxAmt(discountEntry.getPriceTax().divide(discountEntry.getTaxRate().add(BigDecimal.ONE), 2, 4));
        discountEntry.setTaxAmt(discountEntry.getPriceTax().subtract(discountEntry.getNoTaxAmt()));
        discountEntry.setId(BOSUuid.create((String)"5A63A7BA"));
        discountEntry.setSourceBillEntryId(newEntry.getId().toString());
        discountEntry.setSpecs(null);
        discountEntry.setMeasureUnit(null);
        discountEntry.setMakeInvoiceUnit(null);
        entry.setPriceTax(entry.getPriceTax().subtract(discountEntry.getPriceTax()));
        entry.setNoTaxAmt(entry.getNoTaxAmt().subtract(discountEntry.getNoTaxAmt()));
        entry.setTaxAmt(entry.getTaxAmt().subtract(discountEntry.getTaxAmt()));
        entry.setSpecs(null);
        entry.setMeasureUnit(null);
        entry.setMakeInvoiceUnit(null);
        newEntrs.add(discountEntry);
        curNewEntrs.add(discountEntry);
        this.params.getSrcMap().put(newEntry.getId().toString(), discountEntry.getId().toString());
        this.params.getDestMap().put(discountEntry.getId().toString(), newEntry.getId().toString());
        this.params.getDiscountAmtMap().put(entry.getSourceBillEntryId(), entry.getAmtBySplitType(makeInvoice));
        this.params.getDiscountAmtMap().put(discountEntry.getSourceBillEntryId(), discountEntry.getAmtBySplitType(makeInvoice));
    }

    protected void calInvoiceEntryFields(MakeInvoiceEntryInfo entry) {
        BigDecimal notTaxPrice = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal noTaxAmt = entry.getNoTaxAmt();
        BigDecimal priceTax = entry.getPriceTax();
        BigDecimal tax = entry.getPriceTax().subtract(noTaxAmt);
        if (entry.getQuantity().compareTo(BigDecimal.ZERO) != 0) {
            notTaxPrice = noTaxAmt.divide(entry.getQuantity(), 10, 4);
            price = priceTax.divide(entry.getQuantity(), 10, 4);
        }
        entry.setNoTaxAmt(noTaxAmt.setScale(2, 4));
        entry.setPriceTax(entry.getPriceTax().setScale(2, 4));
        entry.setTaxAmt(tax.setScale(2, 4));
        entry.setNoTaxPrice(notTaxPrice);
        entry.setPrice(price);
    }

    protected void doEntryDiffer(MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entry, MakeInvoiceEntryCollection curNewEntrs) throws EASBizException, BOSException {
        if (curNewEntrs.size() == 0) {
            return;
        }
        if (RowType.DISCOUNT_ROW.equals((Object)entry.getBillRowType())) {
            return;
        }
        if (RowType.DISCOUNTED_ROW.equals((Object)entry.getBillRowType())) {
            int i;
            HashMap<String, MakeInvoiceEntryInfo> entryMap = new HashMap<String, MakeInvoiceEntryInfo>();
            MakeInvoiceEntryInfo entryInfo = null;
            int size = invoice.getEntries().size();
            for (i = 0; i < size; ++i) {
                entryInfo = invoice.getEntries().get(i);
                entryMap.put(entryInfo.getId().toString(), entryInfo);
            }
            size = curNewEntrs.size();
            for (i = 0; i < size; ++i) {
                entryInfo = curNewEntrs.get(i);
                entryMap.put(entryInfo.getId().toString(), entryInfo);
            }
            this.allocEntryDiffer(invoice, entry, curNewEntrs, entryMap, RowType.DISCOUNTED_ROW);
            this.allocEntryDiffer(invoice, entry, curNewEntrs, entryMap, RowType.DISCOUNT_ROW);
        } else if (RowType.NORMAL_ROW.equals((Object)entry.getBillRowType())) {
            this.allocEntryDiffer(invoice, entry, curNewEntrs, null, RowType.NORMAL_ROW);
        }
    }

    protected abstract void allocEntryDiffer(MakeInvoiceInfo var1, MakeInvoiceEntryInfo var2, MakeInvoiceEntryCollection var3, Map<String, MakeInvoiceEntryInfo> var4, RowType var5) throws EASBizException, BOSException;

    protected boolean isNotSatisfyRelations(MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entry) {
        BigDecimal totalDiffAmount;
        if (invoice.isIsDiffTax()) {
            return IMUtils.isDiffNotSatisfyRelations(invoice, entry);
        }
        if (invoice.getGoldenTaxControl() == 1 && (totalDiffAmount = invoice.getTotalDiffAmount(entry)).abs().compareTo(BigDecimal.valueOf(0.01)) > 0) {
            return true;
        }
        return IMUtils.isNotSatisfyRelations(invoice, entry);
    }

    protected int getQuantitySplitPrecision() {
        int quantitySplitPrecision = 1;
        if (this.params.getParamConfigInfo() != null) {
            quantitySplitPrecision = this.params.getParamConfigInfo().getQuantitySplitPrecision();
        }
        return quantitySplitPrecision;
    }

    public SplitLimitAmtParams getParams() {
        return this.params;
    }

    public void setParams(SplitLimitAmtParams params) {
        this.params = params;
    }
}

