/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceForDepFacadeFactory;
import com.kingdee.eas.tm.im.ProductCodeCollection;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceFactory;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.common.app.service.IMBizService;
import com.kingdee.eas.tm.im.util.TCCUtil;
import com.kingdee.eas.tm.im.util.VehicleMakeInvoiceFilterFactory;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class VehicleMakeInvoiceBizService
extends IMBizService {
    public void mainOrgUnitChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String companyId = (String)params.get("companyId");
        VehicleMakeInvoiceFilterFactory filterFactory = VehicleMakeInvoiceFilterFactory.getInstance();
        result.put("customerFilter", filterFactory.getCustomerFilter(companyId).toString());
        result.put("supplierFilter", filterFactory.getSupplierFilter(companyId).toString());
        result.put("buyerNameFilter", filterFactory.getBuyerNameFilter(companyId, null).toString());
        result.put("productCodeFilter", filterFactory.getProductCodeFilter(companyId, null).toString());
        VehicleMakeInvoiceInfo model = (VehicleMakeInvoiceInfo)VehicleMakeInvoiceFactory.getLocalInstance(ctx).createNewData(companyId, null);
        result.put("model", model);
    }

    public void customerChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String companyId = (String)params.get("companyId");
        String customerId = (String)params.get("customerId");
        VehicleMakeInvoiceFilterFactory filterFactory = VehicleMakeInvoiceFilterFactory.getInstance();
        result.put("buyerNameFilter", filterFactory.getBuyerNameFilter(companyId, customerId).toString());
        result.put("productCodeFilter", filterFactory.getProductCodeFilter(companyId, customerId).toString());
        CustomerTaxInfo customerTax = null;
        if (!StringUtils.isEmpty((String)customerId)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("isVehicle", "1");
            map.put("customerId", customerId);
            map.put("companyId", companyId);
            Map retValue = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(map);
            customerTax = (CustomerTaxInfo)retValue.get("value");
        }
        result.put("customerTax", customerTax);
    }

    public void supplierChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String supplierId = (String)params.get("supplierId");
        SupplierInfo supplierInfo = null;
        if (!StringUtils.isEmpty((String)supplierId)) {
            supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierId));
        }
        result.put("supplier", supplierInfo);
    }

    public void buyerNameChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String customerTaxId = (String)params.get("customerTaxId");
        CustomerTaxInfo customerTax = null;
        if (!StringUtils.isEmpty((String)customerTaxId)) {
            customerTax = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo((IObjectPK)new ObjectUuidPK(customerTaxId));
        }
        result.put("customerTax", customerTax);
    }

    public void productCodeChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String productCodeId = (String)params.get("productCodeId");
        String companyId = (String)params.get("companyId");
        String customerId = (String)params.get("customerId");
        ProductCodeInfo productCode = null;
        if (!StringUtils.isEmpty((String)productCodeId)) {
            TaxClassificationCodeInfo taxClassificationCode;
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("taxClassificationCode.*"));
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)productCodeId, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            ProductCodeCollection coll = ProductCodeFactory.getLocalInstance(ctx).getProductCodeCollection(viewInfo);
            if (coll.size() > 0 && (productCode = coll.get(0)) != null && (taxClassificationCode = productCode.getTaxClassificationCode()) != null) {
                TCCUtil.initTaxClassificationCode(result, taxClassificationCode, productCode.isHasPreferential());
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("customerId", StringUtils.isEmpty((String)customerId) ? "empty" : customerId);
            map.put("companyId", companyId);
            map.put("isVehicle", "1");
            Map retValue = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(map);
            CustomerTaxInfo customerTax = (CustomerTaxInfo)retValue.get("value");
            if (customerTax != null && customerTax.getVehicleManage() != null) {
                MakeInvoiceForDepFacadeFactory.getLocalInstance(ctx).carryVehicleManageInfo((IObjectValue)productCode, customerTax.getVehicleManage().getId().toString());
            }
        }
        result.put("productCode", productCode);
    }

    public void taxClassificationCodeChange(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String taxClassificationCodeId = (String)params.get("taxClassificationCodeId");
        TaxClassificationCodeInfo taxClassificationCode = null;
        if (!StringUtils.isEmpty((String)taxClassificationCodeId)) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            viewInfo.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)taxClassificationCodeId, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            TaxClassificationCodeCollection coll = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(viewInfo);
            if (coll.size() > 0 && (taxClassificationCode = coll.get(0)) != null) {
                TCCUtil.initTaxClassificationCode(result, taxClassificationCode, false);
            }
        }
        result.put("taxClassificationCode", taxClassificationCode);
    }

    public void checkBeforeRed(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String billId = (String)params.get("billId");
        try {
            VehicleMakeInvoiceFactory.getLocalInstance(ctx).checkBeforeRed(billId);
        }
        catch (EASBizException e) {
            result.put("errorMsg", e.getMessage());
        }
    }

    public void checkBeforeRedInvoice(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String billID = (String)params.get("billID");
        try {
            Map retValue = VehicleMakeInvoiceFactory.getLocalInstance(ctx).checkBeforeRedInvoice(billID, params);
            result.putAll(retValue);
        }
        catch (EASBizException e) {
            result.put("errorMsg", e.getMessage());
        }
    }

    public void redInvoice(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String billID = (String)params.get("billID");
        VehicleMakeInvoiceFactory.getLocalInstance(ctx).redInvoice(billID, params);
    }

    public void checkBeforeCopy(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String billID = (String)params.get("billID");
        try {
            VehicleMakeInvoiceFactory.getLocalInstance(ctx).checkBeforeCopy(billID);
        }
        catch (EASBizException e) {
            result.put("errorMsg", e.getMessage());
        }
    }

    public void checkBeforeEdit(Context ctx, Map result, Map params) throws EASBizException, BOSException {
        String billID = (String)params.get("billID");
        try {
            VehicleMakeInvoiceFactory.getLocalInstance(ctx).checkBeforeEdit(billID);
        }
        catch (EASBizException e) {
            result.put("errorMsg", e.getMessage());
        }
    }
}

