/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.VehicleInvoiceReqCollection;
import com.kingdee.eas.tm.im.VehicleInvoiceReqEntryCollection;
import com.kingdee.eas.tm.im.VehicleInvoiceReqEntryFactory;
import com.kingdee.eas.tm.im.VehicleInvoiceReqEntryInfo;
import com.kingdee.eas.tm.im.VehicleInvoiceReqFactory;
import com.kingdee.eas.tm.im.VehicleInvoiceReqInfo;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VehicleServerUtil {
    public static VehicleInvoiceReqCollection getVehicleInvoiceReqCollection(Context ctx, Set idSet, Set entryIdSet) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.setSelector(IMSelectorFactory.getVehicleInvoiceReqSelectors());
        VehicleInvoiceReqCollection coll = VehicleInvoiceReqFactory.getLocalInstance(ctx).getVehicleInvoiceReqCollection(ev);
        VehicleInvoiceReqCollection bizColl = new VehicleInvoiceReqCollection();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            VehicleInvoiceReqInfo info = (VehicleInvoiceReqInfo)it.next();
            VehicleInvoiceReqEntryInfo entryInfo = null;
            VehicleInvoiceReqEntryCollection newEntries = new VehicleInvoiceReqEntryCollection();
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                entryInfo = info.getEntries().get(i);
                if (!entryIdSet.contains(entryInfo.getId().toString())) continue;
                newEntries.add(entryInfo);
            }
            if (newEntries.size() <= 0) continue;
            info.getEntries().clear();
            info.getEntries().addCollection(newEntries);
            bizColl.add(info);
        }
        return bizColl;
    }

    public static void buildBillErrorMsg(Context ctx, Map billErrMap, StringBuffer errorMsg, List entryIds, Map billEntryErrMap) throws BOSException {
        Iterator iterator = billErrMap.keySet().iterator();
        HashSet<String> idSet = new HashSet<String>();
        while (iterator.hasNext()) {
            String billid = iterator.next().toString();
            idSet.add(billid);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("number");
        sic.add("entries.id");
        ev.setSelector(sic);
        VehicleInvoiceReqCollection bizColl = VehicleInvoiceReqFactory.getLocalInstance(ctx).getVehicleInvoiceReqCollection(ev);
        String billType = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VehicleInvoiceReq", ctx.getLocale());
        for (int i = 0; i < bizColl.size(); ++i) {
            VehicleInvoiceReqInfo info = bizColl.get(i);
            String id = info.getId().toString();
            errorMsg.append(billType + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_BILL_ERROR", ctx.getLocale(), new Object[]{info.getNumber(), billErrMap.get(id)})).append("\r\n");
            if (entryIds == null || billEntryErrMap == null) continue;
            Iterator it = info.getEntries().iterator();
            while (it.hasNext()) {
                VehicleInvoiceReqEntryInfo entryInfo = (VehicleInvoiceReqEntryInfo)it.next();
                if (!entryIds.contains(entryInfo.getId().toString())) continue;
                billEntryErrMap.put(entryInfo.getId().toString(), null);
            }
        }
    }

    public static void buildEntryErrorMsg(Context ctx, Map billEntryErrMap, StringBuffer errorMsg) throws BOSException {
        HashSet<String> entryIdSet = new HashSet<String>();
        Iterator it = billEntryErrMap.keySet().iterator();
        while (it.hasNext()) {
            String entryId = it.next().toString();
            entryIdSet.add(entryId);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.number");
        sic.add("seq");
        ev.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("parent.number"));
        sort.add(new SorterItemInfo("seq"));
        ev.setSorter(sort);
        VehicleInvoiceReqEntryCollection bizEntryColl = VehicleInvoiceReqEntryFactory.getLocalInstance(ctx).getVehicleInvoiceReqEntryCollection(ev);
        String billType = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VehicleInvoiceReq", ctx.getLocale());
        for (int i = 0; i < bizEntryColl.size(); ++i) {
            VehicleInvoiceReqEntryInfo info = bizEntryColl.get(i);
            String id = info.getId().toString();
            if (billEntryErrMap.get(id) == null) continue;
            errorMsg.append(billType + IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_ERROR", ctx.getLocale(), new Object[]{info.getParent().getNumber(), info.getSeq(), billEntryErrMap.get(id)})).append("\r\n");
        }
    }
}

