/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.basedata.CustomerMailingCollection;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryFactory;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingException;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerMailingInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingStatusEnum;
import com.kingdee.eas.tm.im.basedata.ICustomerMailingEntry;
import com.kingdee.eas.tm.im.basedata.MailTypeEnum;
import com.kingdee.eas.tm.im.common.billimport.IMBillImportBase;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class CustomerMailingImport
extends IMBillImportBase {
    private Hashtable firstData = null;

    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CustomerMailingFactory.getLocalInstance(ctx);
        }
        catch (BOSException ex) {
            Logger.error((Throwable)ex);
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        ICoreBase iCoreBase = this.getController(ctx);
        try {
            this.setEntryDefault((CustomerMailingInfo)coreBaseInfo);
            if (coreBaseInfo.getId() == null || !iCoreBase.exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                iCoreBase.addnew(coreBaseInfo);
            } else {
                iCoreBase.update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
    }

    private void setEntryDefault(CustomerMailingInfo head) {
        boolean isDefault = false;
        int defaultIndex = 0;
        for (int i = 0; i < head.getEntries().size(); ++i) {
            if (head.getEntries().get(i).isIsDefault()) {
                defaultIndex = i;
                isDefault = true;
            }
            if (!isDefault || defaultIndex == i) continue;
            head.getEntries().get(i).setIsDefault(false);
        }
        if (!isDefault && head.getMailType().equals((Object)MailTypeEnum.ReceiveMail)) {
            head.getEntries().get(0).setIsDefault(false);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        CustomerMailingInfo head = new CustomerMailingInfo();
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        boolean hasDefault = false;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    String number = ((DataToken)lineData.get((Object)"FNumber")).data.toString();
                    if (null == number || number.trim().length() == 0) {
                        throw new TaskExternalException(this.getResource(ctx, "Number_NOT_NULL"));
                    }
                    if (number.trim().length() > 88) {
                        throw new TaskExternalException(this.getResource(ctx, "NUMBER_LARGER"));
                    }
                    head = this.getHeadInfo(ctx, mode, number);
                    head = this.parseHead(lineData, ctx, head);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
            CustomerMailingEntryInfo entryInfo = null;
            String fseq = ((DataToken)lineData.get((Object)"FEntries_seq")).data.toString();
            entryInfo = this.getEntryInfo(ctx, mode, head, fseq);
            entryInfo = this.parseEntry(lineData, ctx, head, entryInfo);
            if (hasDefault && entryInfo.isIsDefault()) {
                throw new TaskExternalException(this.getResource(ctx, "MULTIPLEDEFAULT"));
            }
            if (!hasDefault) {
                hasDefault = entryInfo.isIsDefault();
            }
            this.afterBuildEntry(head, entryInfo);
        }
        if (head.getEntries().size() >= 1 && !hasDefault && head.getMailType().equals((Object)MailTypeEnum.ReceiveMail)) {
            for (int j = 0; j < head.getEntries().size(); ++j) {
                CustomerMailingEntryInfo entryInfo = head.getEntries().get(j);
                if (entryInfo.getSeq() != 1) continue;
                entryInfo.setIsDefault(true);
            }
        }
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        head.setCU(cu);
        return head;
    }

    private void afterBuildEntry(CustomerMailingInfo head, CustomerMailingEntryInfo entryInfo) {
        int seq = head.getEntries().size() + 1;
        entryInfo.setSeq(seq);
        entryInfo.setParent(head);
        head.getEntries().add(entryInfo);
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        String yes = IMUtils.getResource("com.kingdee.eas.tm.im.app.IMImportResource", "YES", ctx);
        String no = IMUtils.getResource("com.kingdee.eas.tm.im.app.IMImportResource", "NO", ctx);
        Hashtable result = new Hashtable();
        try {
            DataImportTools.putToHashtable(result, (Object)"FNumber", (Object)rs.getString("number"));
            DataImportTools.putToHashtable(result, (Object)"FMailType", (Object)((Object)MailTypeEnum.getEnum(rs.getString("mailType"))));
            DataImportTools.putToHashtable(result, (Object)"FCustomer_number", (Object)rs.getString("customer.number"));
            DataImportTools.putToHashtable(result, (Object)"FCompany_number", (Object)rs.getString("company.number"));
            DataImportTools.putToHashtable(result, (Object)"FStatus", (Object)((Object)CustomerMailingStatusEnum.getEnum(rs.getString("status"))));
            DataImportTools.putToHashtable(result, (Object)"FEntries_companyName", (Object)rs.getString("entries.companyName"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_address", (Object)rs.getString("entries.address"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_postalcode", (Object)rs.getString("entries.postalcode"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_mailbox", (Object)rs.getString("entries.mailbox"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_express", (Object)rs.getString("entries.express"));
            DataImportTools.putToHashtable(result, (Object)"FEntries$contactsUser_number", (Object)rs.getString("contactsUser.number"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_contacts", (Object)rs.getString("entries.contacts"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_telephone", (Object)rs.getString("entries.telephone"));
            DataImportTools.putToHashtable(result, (Object)"FEntries_isDefault", (Object)(Boolean.parseBoolean(rs.getString("entries.isDefault")) ? yes : no));
            DataImportTools.putToHashtable(result, (Object)"FEntries_seq", (Object)rs.getString("entries.seq"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.im.basedata.CustomerMailingImportQuery";
    }

    private CustomerMailingInfo getHeadInfo(Context ctx, int mode, String number) throws BOSException, EASBizException, TaskExternalException {
        CustomerMailingInfo mailInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        CustomerMailingCollection mailColl = CustomerMailingFactory.getLocalInstance(ctx).getCustomerMailingCollection(view);
        if (mailColl.size() > 0) {
            mailInfo = mailColl.get(0);
        }
        if (mode == 8) {
            if (mailInfo != null) {
                throw new TaskExternalException(this.getResource(ctx, "Record_HasExists"));
            }
            mailInfo = new CustomerMailingInfo();
            mailInfo.setNumber(number);
            return mailInfo;
        }
        if (mailInfo == null) {
            mailInfo = new CustomerMailingInfo();
            mailInfo.setNumber(number);
        } else if (CustomerMailingStatusEnum.Active == mailInfo.getStatus()) {
            throw new TaskExternalException(this.getResource(ctx, "CANT_UPDATE_USING"));
        }
        return mailInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CustomerMailingInfo parseHead(Hashtable hsData, Context ctx, CustomerMailingInfo head) throws TaskExternalException, BOSException, EASBizException {
        String status;
        String mailType = ((DataToken)hsData.get((Object)"FMailType")).data.toString();
        MailTypeEnum mailTypeEnum = null;
        if (mailType.equals(MailTypeEnum.SendMail.getAlias())) {
            mailTypeEnum = MailTypeEnum.SendMail;
        } else if (mailType.equals(MailTypeEnum.ReceiveMail.getAlias())) {
            mailTypeEnum = MailTypeEnum.ReceiveMail;
        } else {
            try {
                mailTypeEnum = MailTypeEnum.getEnum(mailType);
                if (mailTypeEnum == null) {
                    throw new CustomerMailingException(CustomerMailingException.MAILTYPEERROR);
                }
            }
            catch (Exception e) {
                throw new CustomerMailingException(CustomerMailingException.MAILTYPEERROR);
            }
        }
        head.setMailType(mailTypeEnum);
        if (mailTypeEnum.equals((Object)MailTypeEnum.SendMail)) {
            CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, hsData);
            if (companyInfo == null) throw new TaskExternalException(this.getResource(ctx, "Company_NOT_NULL"));
            head.setCompany(companyInfo);
        } else if (mailTypeEnum.equals((Object)MailTypeEnum.ReceiveMail)) {
            CustomerInfo customerInfo = this.getCustomer(ctx, hsData);
            CompanyOrgUnitInfo companyInfo = this.getCompanyInfo(ctx, hsData);
            if (companyInfo != null) {
                head.setCompany(companyInfo);
            }
            if (customerInfo == null) throw new TaskExternalException(this.getResource(ctx, "Customer_NOT_NULL"));
            head.setCustomer(customerInfo);
        }
        if (null == (status = ((DataToken)hsData.get((Object)"FStatus")).data.toString()) || status.length() <= 0) throw new TaskExternalException(this.getResource(ctx, "Status_NOT_NULL"));
        CustomerMailingStatusEnum mailingStatus = null;
        if (status.equals(CustomerMailingStatusEnum.Active.getAlias())) {
            mailingStatus = CustomerMailingStatusEnum.Active;
        } else if (status.equals(CustomerMailingStatusEnum.InActive.getAlias())) {
            mailingStatus = CustomerMailingStatusEnum.InActive;
        } else {
            mailingStatus = CustomerMailingStatusEnum.getEnum(status);
            if (mailingStatus != CustomerMailingStatusEnum.Active && mailingStatus != CustomerMailingStatusEnum.InActive) {
                throw new CustomerMailingException(CustomerMailingException.STATEERROR);
            }
        }
        head.setStatus(mailingStatus);
        head.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        return head;
    }

    private CustomerMailingEntryInfo getEntryInfo(Context ctx, int mode, CustomerMailingInfo head, String FSeq) throws TaskExternalException {
        if (mode == 16 || mode == 128) {
            if (head.getId() == null || FSeq == null) {
                return new CustomerMailingEntryInfo();
            }
            try {
                ICustomerMailingEntry iIncomeInvoiceEntry = CustomerMailingEntryFactory.getLocalInstance(ctx);
                CustomerMailingEntryCollection coll = iIncomeInvoiceEntry.getCustomerMailingEntryCollection("where parent.id = '" + head.getId().toString() + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new CustomerMailingEntryInfo();
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
        }
        if (mode == 8) {
            return new CustomerMailingEntryInfo();
        }
        return new CustomerMailingEntryInfo();
    }

    private CustomerMailingEntryInfo parseEntry(Hashtable hsData, Context ctx, CustomerMailingInfo head, CustomerMailingEntryInfo entry) throws TaskExternalException {
        String telephone;
        String contacts;
        UserInfo contactsUser;
        String express;
        String mailbox;
        String postalcode;
        String address;
        String companyName = ((DataToken)hsData.get((Object)"FEntries_companyName")).data.toString();
        if (companyName != null && companyName.length() > 0) {
            if (companyName.trim().length() > 255) {
                throw new TaskExternalException(this.getResource(ctx, "COMPANYNAME_LARGER"));
            }
            entry.setCompanyName(companyName);
        }
        if ((address = ((DataToken)hsData.get((Object)"FEntries_address")).data.toString()) != null && address.length() != 0) {
            if (address.trim().length() > 255) {
                throw new TaskExternalException(this.getResource(ctx, "ADDRESS_LARGER"));
            }
            entry.setAddress(address);
        }
        if ((postalcode = ((DataToken)hsData.get((Object)"FEntries_postalcode")).data.toString()) != null && postalcode.length() > 0) {
            if (postalcode.trim().length() > 44) {
                throw new TaskExternalException(this.getResource(ctx, "POSTALCODE_LARGER"));
            }
            entry.setPostalcode(postalcode);
        }
        if ((mailbox = ((DataToken)hsData.get((Object)"FEntries_mailbox")).data.toString()) != null && mailbox.length() > 0) {
            if (mailbox.trim().length() > 88) {
                throw new TaskExternalException(this.getResource(ctx, "MAILBOX_LARGER"));
            }
            entry.setMailbox(mailbox);
        }
        if ((express = ((DataToken)hsData.get((Object)"FEntries_express")).data.toString()) != null && express.length() > 0) {
            if (express.trim().length() > 255) {
                throw new TaskExternalException(this.getResource(ctx, "EXPRESS_LARGER"));
            }
            entry.setExpress(express);
        }
        if ((contactsUser = this.getContactsUserInfo(ctx, hsData)) != null) {
            entry.setContactsUser(contactsUser);
            entry.setContacts(contactsUser.getName());
        }
        if ((contacts = ((DataToken)hsData.get((Object)"FEntries_contacts")).data.toString()) != null && contacts.length() > 0) {
            if (contacts.trim().length() > 44) {
                throw new TaskExternalException(this.getResource(ctx, "CONTACTS_LARGER"));
            }
            entry.setContacts(contacts);
        }
        if ((telephone = ((DataToken)hsData.get((Object)"FEntries_telephone")).data.toString()) != null && telephone.length() > 0) {
            if (telephone.trim().length() > 44) {
                throw new TaskExternalException(this.getResource(ctx, "TELEPHONE_LARGER"));
            }
            entry.setTelephone(telephone);
        }
        if (head.getMailType().equals((Object)MailTypeEnum.ReceiveMail)) {
            String isDefault = ((DataToken)hsData.get((Object)"FEntries_isDefault")).data.toString();
            if (isDefault != null && isDefault.length() > 0) {
                entry.setIsDefault(this.getBooleanValue(ctx, "FIsHidden", isDefault));
            }
        } else {
            entry.put("isDefault", null);
        }
        return entry;
    }

    private boolean getBooleanValue(Context ctx, String colName, Object value) throws TaskExternalException {
        if (value != null && !value.equals("")) {
            return value.equals(this.getResource(ctx, "True_Alias")) || value.equals("1") || value.equals("true");
        }
        return false;
    }

    private CustomerInfo getCustomer(Context ctx, Hashtable hsData) throws TaskExternalException {
        CustomerInfo customerInfo = null;
        String FCustomerNumber = ((DataToken)hsData.get((Object)"FCustomer_number")).data.toString();
        String sql = "select top 1 fid,fnumber,fname_l2 from T_BD_Customer where fnumber = ?";
        if (FCustomerNumber != null && FCustomerNumber.length() > 0) {
            try {
                if (FCustomerNumber.trim().length() > 80) {
                    throw new TaskExternalException(this.getResource(ctx, "CUSTOMERNUMBER_LARGER"));
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCustomerNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(this.getResource(ctx, "Customer_NOT_Exists"));
                }
                customerInfo = new CustomerInfo();
                customerInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                customerInfo.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return customerInfo;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        CompanyOrgUnitInfo companyInfo = null;
        String FCompanyNumber = ((DataToken)hsData.get((Object)"FCompany_number")).data.toString();
        String sql = "select top 1 fid,fnumber,fname_l2 from T_ORG_COMPANY where fnumber = ?";
        if (FCompanyNumber != null && FCompanyNumber.length() > 0) {
            if (FCompanyNumber.trim().length() > 80) {
                throw new TaskExternalException(this.getResource(ctx, "COMPANYNUMBER_LARGER"));
            }
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FCompanyNumber});
                if (rs == null || !rs.next()) {
                    throw new TaskExternalException(this.getResource(ctx, "Company_NOT_Exists"));
                }
                companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                companyInfo.setName(rs.getString("fname_l2"));
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return companyInfo;
    }

    private UserInfo getContactsUserInfo(Context ctx, Hashtable hsData) throws TaskExternalException {
        UserInfo userInfo = null;
        String FUserNumber = ((DataToken)hsData.get((Object)"FEntries$contactsUser_number")).data.toString();
        if (FUserNumber != null && FUserNumber.length() > 0) {
            if (FUserNumber.trim().length() > 255) {
                throw new TaskExternalException(this.getResource(ctx, "USERNUMBER_LARGER"));
            }
            String sql = "select top 1 fid,fnumber,fname_l2  from T_PM_USER where fnumber = ?";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{FUserNumber});
                if (rs != null && rs.next()) {
                    userInfo = new UserInfo();
                    userInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                    userInfo.setNumber(rs.getString("fnumber"));
                    userInfo.setName(rs.getString("fname_l2"));
                }
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            catch (UuidException e) {
                Logger.error((Throwable)e);
            }
            catch (SQLException e) {
                Logger.error((Throwable)e);
            }
        }
        return userInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        if (this.firstData != null) {
            firstNumber = (DataToken)this.firstData.get(this.getMainField());
        }
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        this.firstData = currentData;
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private String getResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerMailingResource", (String)key, (Locale)ctx.getLocale());
    }
}

