/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingFactory;
import com.kingdee.eas.tm.im.basedata.AutoIncomeInvoiceOpTypeEnum;
import com.kingdee.eas.tm.im.basedata.AutoIncomeInvoiceSchemeFactory;
import com.kingdee.eas.tm.im.basedata.AutoIncomeInvoiceSchemeInfo;
import com.kingdee.eas.tm.im.basedata.app.AbstractAutoIncomeInvoiceFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.MakeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.msg.result.PoolDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.AbstractPwyService;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoiceBillQueryBaseService;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolPwyHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.DateUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.ObjectUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AutoIncomeInvoiceFacadeControllerBean
extends AbstractAutoIncomeInvoiceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.AutoIncomeInvoiceFacadeControllerBean");
    private static final String WEB = "Web";
    private static final String DISK = "Disk";
    private static final String EMPTYSTR = "";
    private static final int ZERO = 0;

    @Override
    protected Map _downloadIncomeInvoice(Context ctx, IObjectValue autoIncomeInvoiceScheme, IObjectCollection companyRange) throws BOSException, EASBizException {
        logger.debug((Object)"enter method _downloadIncomeInvoice.");
        ArrayList<Map> resultList = new ArrayList<Map>();
        Map ret = new HashMap();
        Context newCtx = null;
        try {
            newCtx = (Context)ObjectUtils.createCopy((Object)ctx);
            UserInfo userInfo = new UserInfo();
            userInfo.setId(BOSUuid.read((String)"256c221a-0106-1000-e000-10d7c0a813f413B7DE7F"));
            newCtx.put((Object)"UserInfo", (Object)userInfo);
            newCtx.put((Object)"currentUserID", ctx.getCaller() == null ? userInfo.getId() : ctx.getCaller());
            newCtx.setCaller((IObjectPK)new ObjectUuidPK(userInfo.getId()));
        }
        catch (CloneNotSupportedException e1) {
            throw new BOSException((Throwable)e1);
        }
        AutoIncomeInvoiceSchemeInfo schemeInfo = (AutoIncomeInvoiceSchemeInfo)autoIncomeInvoiceScheme;
        if (schemeInfo == null || StringUtils.isEmpty((String)schemeInfo.getId().toString())) {
            this.sendBMCMsg(newCtx, "failed", EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AUTO_NULL"), 0);
            return this.handleRetMap(ret, 0, 0, 0, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_AUTO_NULL"));
        }
        schemeInfo = AutoIncomeInvoiceSchemeFactory.getLocalInstance(newCtx).getAutoIncomeInvoiceSchemeInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getId()), this.getSelectors());
        newCtx.put((Object)"billName", (Object)schemeInfo.getName());
        if (companyRange == null) {
            this.sendBMCMsg(newCtx, "failed", EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"COMPANY_ISNULL"), 0);
            return ret;
        }
        if (!StringUtils.isEmpty((String)schemeInfo.getInvoiceStatus())) {
            schemeInfo.setInvoiceStatus(schemeInfo.getInvoiceStatus().replace("4", "4,5"));
        }
        try {
            Map webMap = this.downloadInvoice(newCtx, schemeInfo, AutoIncomeInvoiceFacadeControllerBean.getCompanyIds(companyRange));
            resultList.add(webMap);
            if (schemeInfo.getOpType().equals((Object)AutoIncomeInvoiceOpTypeEnum.DownIncomeInvoice)) {
                ret = this.handleIncomeResultAndShowMsg(newCtx, resultList);
            } else if (schemeInfo.getOpType().equals((Object)AutoIncomeInvoiceOpTypeEnum.DownMakeInvoice)) {
                ret = this.handleMakeResultAndShowMsg(newCtx, resultList);
            }
        }
        catch (Exception e) {
            this.sendBMCMsg(newCtx, "failed", e.getMessage(), 0);
        }
        return ret;
    }

    private void sendBMCMsg(Context newCtx, String errorMsg, String msg, int sucessMkBill) throws EASBizException, BOSException {
        String result = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"ERROR");
        if (sucessMkBill > 0 && errorMsg.length() > 0) {
            result = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"PARTIAL_SUCCESS");
        } else if (errorMsg.length() == 0) {
            result = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"SUCCESS");
        }
        String title = EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoIncomeInvoiceSchemeResource", (String)"AUTO_INCOMEINVOICE_TITLE", (Object[])new Object[]{(String)newCtx.get((Object)"billName"), result});
        IMUtils.sendBMCMsg(newCtx, msg, title, newCtx.get((Object)"currentUserID").toString());
        logger.error((Object)"exit AutoIncomeInvoiceFacadeControllerBean sendBMCMsg.");
    }

    public static Set<String> getCompanyIds(IObjectCollection companyRange) {
        HashSet<String> companySet = new HashSet<String>();
        for (IObjectValue companyInfo : companyRange) {
            if (null == companyInfo.get("id")) continue;
            companySet.add(companyInfo.get("id").toString());
        }
        return companySet;
    }

    private Map downloadInvoice(Context ctx, AutoIncomeInvoiceSchemeInfo scheme, Set companyIDs) throws BOSException, EASBizException {
        HashMap ret = new HashMap();
        List paramList = new ArrayList();
        if (scheme.getOpType().equals((Object)AutoIncomeInvoiceOpTypeEnum.DownIncomeInvoice)) {
            this.buildIncomePwyParam(ctx, scheme, companyIDs, WEB, paramList);
            this.buildIncomePwyParam(ctx, scheme, companyIDs, DISK, paramList);
        } else if (scheme.getOpType().equals((Object)AutoIncomeInvoiceOpTypeEnum.DownMakeInvoice)) {
            paramList = this.buildMakePwyParam(ctx, scheme, companyIDs);
        }
        if (paramList.isEmpty()) {
            return ret;
        }
        HashMap params = new HashMap();
        params.put("paramList", paramList);
        List list = PwyServiceFacadeFactory.getLocalInstance(ctx).buildPwyParam(paramList);
        ArrayList resultList = new ArrayList();
        ArrayList<String> errorMsg = new ArrayList<String>();
        PwyInvokeParam invokeParam = null;
        Map invokeActionMap = null;
        for (int i = 0; i < list.size(); ++i) {
            IPwyService pwyService;
            invokeParam = (PwyInvokeParam)list.get(i);
            if (invokeParam.isError()) {
                errorMsg.add(invokeParam.getExceptionMsg());
                continue;
            }
            if (scheme.getOpType().equals((Object)AutoIncomeInvoiceOpTypeEnum.DownIncomeInvoice)) {
                pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
                pwyService.invoke();
                if (!pwyService.isSuccess()) {
                    errorMsg.add(pwyService.getInvokeParam().getDescription());
                    continue;
                }
                invokeActionMap = pwyService.getInvokeParam().getInvokeActionMap();
                for (Object result : invokeActionMap.values()) {
                    resultList.add(result);
                }
                continue;
            }
            pwyService = (MakeInvoiceBillQueryBaseService)PwyServiceHelper.getPwyService(ctx, invokeParam);
            ((AbstractPwyService)pwyService).invoke();
            if (!((AbstractPwyService)pwyService).isSuccess()) {
                errorMsg.add(((AbstractPwyService)pwyService).getInvokeParam().getDescription());
                continue;
            }
            resultList.addAll((Collection)((MakeInvoiceBillQueryBaseService)pwyService).getInvokeActionMap().get("result"));
        }
        ret.put("errorMsg", errorMsg);
        ret.put("resultList", resultList);
        return ret;
    }

    private List buildMakePwyParam(Context ctx, AutoIncomeInvoiceSchemeInfo scheme, Set<String> companyIDs) throws EASBizException, BOSException {
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        PwyActionParam actionParam = null;
        for (String orgId : companyIDs) {
            actionParam = new PwyActionParam();
            actionParam.setMsgType(PwyServiceType.OPR_WEB_DOWNLOAD_MAKEINV);
            actionParam.setOwnerSystem(TransSrcSystemEnum.easgui);
            actionParam.setOrgId(orgId);
            actionParam.setParams(this.buildMakeParam(ctx, scheme, orgId));
            paramList.add(actionParam);
        }
        return paramList;
    }

    private Map buildMakeParam(Context ctx, AutoIncomeInvoiceSchemeInfo scheme, String orgId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String taxNo = company.getTaxNumber();
        if (!StringUtils.isEmpty((String)taxNo)) {
            taxNo = taxNo.trim();
        }
        HashMap<String, Object> accountData = new HashMap<String, Object>();
        List<String> pwyInvoiceTypeList = this.getPwyInvoiceType(scheme);
        accountData.put("invoiceType", IMUtils.getStringFromList(pwyInvoiceTypeList));
        accountData.put("taxNo", taxNo);
        this.getDateFilter(scheme, accountData);
        accountData.put("pageNo", 1);
        accountData.put("pageSize", 50);
        return accountData;
    }

    private List<String> getPwyInvoiceType(AutoIncomeInvoiceSchemeInfo scheme) {
        String invoiceType = scheme.getInvoiceType();
        String[] invoiceTypeStr = invoiceType.split(",");
        ArrayList<String> pwyInvoiceTypeList = new ArrayList<String>();
        for (String str : invoiceTypeStr) {
            if (str.equals("2")) {
                pwyInvoiceTypeList.add("1");
                continue;
            }
            if (str.equals("1")) {
                pwyInvoiceTypeList.add("4");
                continue;
            }
            if (str.equals("0")) {
                pwyInvoiceTypeList.add("3");
                pwyInvoiceTypeList.add("5");
                continue;
            }
            if (str.equals("3")) {
                pwyInvoiceTypeList.add("2");
                continue;
            }
            if (str.equals("4")) {
                pwyInvoiceTypeList.add("26");
                continue;
            }
            if (!str.equals("5")) continue;
            pwyInvoiceTypeList.add("27");
        }
        return pwyInvoiceTypeList;
    }

    private List buildIncomePwyParam(Context ctx, AutoIncomeInvoiceSchemeInfo scheme, Set companyIDs, String type, List paramList) throws EASBizException, BOSException {
        String supplierIDs = scheme.getCurrAcctSupplierID();
        HashSet<String> supplierTaxNo = new HashSet();
        if (!StringUtils.isEmpty((String)supplierIDs)) {
            supplierTaxNo = new HashSet<String>(Arrays.asList(supplierIDs.split(",")));
        }
        String invoiceCode = scheme.getInvoiceCode();
        String invoiceNo = scheme.getInvoiceNo();
        ArrayList<HashMap> bodyList = new ArrayList<HashMap>();
        PwyServiceType msgType = null;
        if (WEB.equals(type)) {
            this.addWebDownloadParams(supplierTaxNo, scheme, bodyList);
            msgType = PwyServiceType.OPR_POOL_WEB_DOWNLOAD;
        } else {
            this.addDiskDownloadParams(supplierTaxNo, scheme, bodyList);
            msgType = PwyServiceType.OPR_POOL_DISK_DOWNLOAD;
        }
        PwyActionParam actionParam = null;
        Map resultMap = PwySettingFactory.getLocalInstance(ctx).getTaxNoSumResult(companyIDs);
        for (String taxNo : resultMap.keySet()) {
            for (HashMap pwyData : bodyList) {
                CompanyOrgUnitInfo company;
                HashMap tempParam = new HashMap();
                HashMap<String, String> newPwyData = new HashMap<String, String>();
                newPwyData.putAll(pwyData);
                tempParam.put("sumRet", resultMap.get(taxNo));
                if (scheme.getInvoiceStatus().contains(",")) {
                    tempParam.put("status", scheme.getInvoiceStatus());
                }
                if (!StringUtils.isEmpty((String)(company = ((TaxNoSumResult)resultMap.get(taxNo)).getDefaultCompany()).getTaxNumber())) {
                    newPwyData.put("buyerTaxNo", company.getTaxNumber().trim());
                }
                tempParam.put("pwyData", newPwyData);
                tempParam.put("isPoolDownload", true);
                actionParam = new PwyActionParam(msgType, TransSrcSystemEnum.easgui, company.getId().toString(), tempParam);
                paramList.add(actionParam);
            }
        }
        return paramList;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("invoiceType.*"));
        return sic;
    }

    protected void addDiskDownloadParams(Set<String> supplierTaxNo, AutoIncomeInvoiceSchemeInfo scheme, List<HashMap> bodyList) {
        HashMap<String, String> searchOpt = new HashMap<String, String>();
        this.getDateFilter(scheme, searchOpt);
        searchOpt.put("authenticateFlags", scheme.getCheckStatus());
        if (!scheme.getInvoiceStatus().contains(",")) {
            searchOpt.put("invoiceStatus", scheme.getInvoiceStatus());
        }
        ArrayList<String> invoiceTypList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)scheme.getInvoiceType())) {
            String[] invoiceTypeStr;
            for (String str : invoiceTypeStr = scheme.getInvoiceType().split(",")) {
                if (!"2".equals(str) && !"4".equals(str) && !"15".equals(str) && !"12".equals(str) && !"27".equals(str)) continue;
                invoiceTypList.add(str);
            }
        }
        if (invoiceTypList.isEmpty()) {
            return;
        }
        searchOpt.put("invoiceType", IMUtils.getStringFromList(invoiceTypList));
        if (supplierTaxNo.isEmpty()) {
            searchOpt.put("salerTaxNo", EMPTYSTR);
            List diskDownloadParams = PoolPwyHelper.getDiskDownloadParams(searchOpt, EMPTYSTR, 0, EMPTYSTR);
            bodyList.addAll(diskDownloadParams);
        } else {
            for (String taxNo : supplierTaxNo) {
                searchOpt.put("salerTaxNo", taxNo);
                List diskDownloadParams = PoolPwyHelper.getDiskDownloadParams(searchOpt, EMPTYSTR, 0, EMPTYSTR);
                bodyList.addAll(diskDownloadParams);
            }
        }
    }

    protected void addWebDownloadParams(Set<String> supplierTaxNo, AutoIncomeInvoiceSchemeInfo scheme, List<HashMap> bodyList) {
        HashMap pwyData = this.getWebPwyData(scheme);
        if (scheme.getCheckStatus() != null) {
            pwyData.put("authenticateFlags", scheme.getCheckStatus());
        }
        bodyList.add(pwyData);
    }

    protected HashMap getWebPwyData(AutoIncomeInvoiceSchemeInfo scheme) {
        HashMap<String, Object> pwyData = new HashMap<String, Object>();
        this.getDateFilter(scheme, pwyData);
        if (!scheme.getInvoiceStatus().contains(",")) {
            pwyData.put("invoiceStatus", scheme.getInvoiceStatus());
        }
        pwyData.put("invoiceTypes", scheme.getInvoiceType());
        pwyData.put("pageNo", 1);
        pwyData.put("pageSize", 50);
        return pwyData;
    }

    protected void getDateFilter(AutoIncomeInvoiceSchemeInfo scheme, HashMap pwyData) {
        int dateVal = Integer.parseInt(scheme.getDateRange().getValue());
        String beginDate = null;
        String endDate = null;
        String dateFormat = "yyyy-MM-dd";
        switch (dateVal) {
            case 0: {
                beginDate = DateUtils.date2String(DateUtils.getDayBegin(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getDayEnd(), dateFormat);
                break;
            }
            case 1: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfWeek(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfWeek(), dateFormat);
                break;
            }
            case 2: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfMonth(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 3: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastThreeMonth(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 4: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastHalfYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 5: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 6: {
                beginDate = DateUtils.date2String(scheme.getStartDate(), dateFormat);
                endDate = DateUtils.date2String(scheme.getEndDate(), dateFormat);
            }
        }
        pwyData.put("startTime", beginDate);
        pwyData.put("endTime", endDate);
    }

    private Map handleIncomeResultAndShowMsg(Context ctx, ArrayList<Map> resultList) throws EASBizException, BOSException {
        ArrayList downloadResultList = new ArrayList();
        ArrayList<String> errList = new ArrayList<String>();
        for (Map map : resultList) {
            if (map.get("resultList") != null) {
                downloadResultList.addAll((List)map.get("resultList"));
            }
            if (map.get("errorMsg") == null) continue;
            errList.addAll((List)map.get("errorMsg"));
        }
        HashMap<String, PoolDownloadResult> companyTotalMap = new HashMap<String, PoolDownloadResult>();
        PoolDownloadResult result = null;
        PoolDownloadResult curResult = null;
        for (int i = 0; i < downloadResultList.size(); ++i) {
            result = (PoolDownloadResult)downloadResultList.get(i);
            if (result == null) continue;
            if (companyTotalMap.containsKey(result.getCompany().getId().toString())) {
                curResult = (PoolDownloadResult)companyTotalMap.get(result.getCompany().getId().toString());
                curResult.merge(result);
                continue;
            }
            companyTotalMap.put(result.getCompany().getId().toString(), result);
        }
        String detailRes = this.getResource("Msg_DownloadDetail");
        MessageFormat format = new MessageFormat(detailRes);
        BigDecimal totalSuccessCount = BigDecimal.ZERO;
        StringBuffer detailMsg = new StringBuffer();
        for (String key : companyTotalMap.keySet()) {
            result = (PoolDownloadResult)companyTotalMap.get(key);
            result.calculate();
            if (result.getErrMsgList().size() > 0) {
                errList.addAll(result.getErrMsgList());
            }
            detailMsg.append(format.format(new Object[]{result.getCompany().getName()}));
            Map<String, Map<String, BigDecimal>> invoiceTypeTotalMap = result.getInvoiceTypeTotalMap();
            if (invoiceTypeTotalMap.isEmpty()) {
                String summaryMsg = this.getResource("DownloadMsg", new Object[]{totalSuccessCount});
                detailMsg.append(summaryMsg);
                continue;
            }
            for (String invoiceTypeKey : invoiceTypeTotalMap.keySet()) {
                Map<String, BigDecimal> invoiceTypeMap = invoiceTypeTotalMap.get(invoiceTypeKey);
                String[] fields = result.getTotalFields(invoiceTypeKey);
                detailMsg.append(this.getResource("InvoiceTypeDetailDownLoadMsg", new Object[]{TMInvoiceType.getEnum((String)invoiceTypeKey).getAlias(), IMUtils.isNullToZero(invoiceTypeMap.get("billCount")), invoiceTypeMap.get(fields[0]), fields.length > 1 ? invoiceTypeMap.get(fields[1]) : Integer.valueOf(0), IMUtils.isNullToZero(invoiceTypeMap.get("billEntryCount"))}));
                totalSuccessCount = totalSuccessCount.add(IMUtils.isNullToZero(invoiceTypeMap.get("billCount")));
            }
        }
        if (errList.size() > 0) {
            this.sendBMCMsg(ctx, "failed", detailMsg.toString() + "\r\n" + IMUtils.buildErrorMsg(errList), totalSuccessCount.intValue());
        } else {
            this.sendBMCMsg(ctx, EMPTYSTR, detailMsg.toString(), totalSuccessCount.intValue());
        }
        HashMap hashMap = new HashMap();
        return this.handleRetMap(hashMap, totalSuccessCount.intValue() != 0 ? 1 : 0, totalSuccessCount.intValue(), 0, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"VC_RESULT"));
    }

    private Map handleMakeResultAndShowMsg(Context ctx, ArrayList<Map> resultList) throws EASBizException, BOSException {
        ArrayList downloadResultList = new ArrayList();
        ArrayList<String> errList = new ArrayList<String>();
        for (Map map : resultList) {
            if (map.get("resultList") != null) {
                downloadResultList.addAll((List)map.get("resultList"));
            }
            if (map.get("errorMsg") == null) continue;
            errList.addAll((List)map.get("errorMsg"));
        }
        HashMap<String, MakeInvoiceDownloadResult> companyTotalMap = new HashMap<String, MakeInvoiceDownloadResult>();
        MakeInvoiceDownloadResult result = null;
        MakeInvoiceDownloadResult curResult = null;
        for (int i = 0; i < downloadResultList.size(); ++i) {
            result = (MakeInvoiceDownloadResult)downloadResultList.get(i);
            if (companyTotalMap.containsKey(result.getCompany().getId().toString())) {
                curResult = (MakeInvoiceDownloadResult)companyTotalMap.get(result.getCompany().getId().toString());
                curResult.setSuccessCount(curResult.getSuccessCount() + result.getSuccessCount());
                curResult.setTaxAmt(curResult.getTaxAmt().add(result.getTaxAmt()));
                curResult.setPriceTax(curResult.getPriceTax().add(result.getPriceTax()));
                continue;
            }
            companyTotalMap.put(result.getCompany().getId().toString(), result);
        }
        int successCount = 0;
        StringBuffer detailMsg = new StringBuffer();
        for (String companyID : companyTotalMap.keySet()) {
            result = (MakeInvoiceDownloadResult)companyTotalMap.get(companyID);
            String companyName = result.getCompany().getName();
            if (result.getSuccessCount() == 0) {
                detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "NotDownloadInvoice", IMUtils.getLocale(), new Object[]{companyName}) + "\r\n");
                continue;
            }
            successCount = result.getSuccessCount();
            detailMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "DownloadInvoice", IMUtils.getLocale(), new Object[]{companyName, successCount, result.getTaxAmt(), result.getPriceTax()}) + "\r\n");
        }
        if (errList.size() > 0) {
            this.sendBMCMsg(ctx, "failed", detailMsg.toString() + "\r\n" + IMUtils.buildErrorMsg(errList), successCount);
        } else {
            this.sendBMCMsg(ctx, EMPTYSTR, detailMsg.toString(), successCount);
        }
        HashMap hashMap = new HashMap();
        return this.handleRetMap(hashMap, successCount != 0 ? 1 : 0, successCount, 0, EASResource.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"VC_RESULT"));
    }

    private Map handleRetMap(Map ret, int state, int success, int failure, String error) {
        ret.put("state", state);
        ret.put("success", success);
        ret.put("failure", failure);
        ret.put("error", error);
        return ret;
    }

    private String getResource(String key) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale());
    }

    private String getResource(String key, Object[] params) {
        return IMUtils.getString("com.kingdee.eas.tm.im.IncomeInvoiceResource", key, IMUtils.getLocale(), params);
    }
}

