/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.AutoIncomeInvoiceSchemeInfo;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeException;
import com.kingdee.eas.tm.im.basedata.AutoSchemeStatusEnum;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.ICustomerTax;
import com.kingdee.eas.tm.im.basedata.app.AbstractAutoIncomeInvoiceSchemeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AutoIncomeInvoiceSchemeControllerBean
extends AbstractAutoIncomeInvoiceSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.AutoIncomeInvoiceSchemeControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AutoIncomeInvoiceSchemeInfo info = this.getAutoIncomeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoIncomeInvoice_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.USING) {
            throw new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.CHECK_USING, new Object[]{info.getNumber()});
        }
        if (info != null && info.isIsDefault()) {
            throw new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.CHECK_ISDEFAULT, new Object[]{info.getNumber()});
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoIncomeInvoiceSchemeInfo info = this.getAutoIncomeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoIncomeInvoice_unActive");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.FORBIDDEN) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + IMUtils.getIMResource(ctx, "CANNOT_INACTIVE", new String[0])});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.USING) {
            info.setStatus(AutoSchemeStatusEnum.FORBIDDEN);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoIncomeInvoiceSchemeInfo info = this.getAutoIncomeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoIncomeInvoice_active");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.USING) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + IMUtils.getIMResource(ctx, "CANNOT_ACTIVE", new String[0])});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.FORBIDDEN) {
            info.setStatus(AutoSchemeStatusEnum.USING);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoIncomeInvoiceSchemeInfo info = this.getAutoIncomeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoIncomeInvoice_update");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AutoIncomeInvoiceSchemeInfo info = (AutoIncomeInvoiceSchemeInfo)model;
        super._checkNumberDup(ctx, (IObjectValue)info);
        info.setName(this.trimStr(info.getName()));
        info.setNumber(this.trimStr(info.getNumber()));
        info.setDescription(this.trimStr(info.getDescription()));
        this.setNewNumber(ctx, info);
        this.checkBeforeSave(ctx, info);
        return super._save(ctx, model);
    }

    public void setNewNumber(Context ctx, AutoIncomeInvoiceSchemeInfo info) throws EASBizException, BOSException {
        if (info.getNumber() != null) {
            return;
        }
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNumer(ctx, info);
            info.setNumber(number);
        }
    }

    private String getNumer(Context ctx, AutoIncomeInvoiceSchemeInfo info) throws BOSException, EASBizException {
        ICustomerTax iCustomerTax = CustomerTaxFactory.getLocalInstance(ctx);
        String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
        if (codingRule == null) {
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{""});
        }
        String number = (String)info.get("number");
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        while (number == null || number.equals("") || iCustomerTax.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, cuID);
            filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        }
        return number;
    }

    private String trimStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.trim();
    }

    private void checkBeforeSave(Context ctx, AutoIncomeInvoiceSchemeInfo info) throws IMException {
        StringBuffer errorMsg = new StringBuffer();
        if (StringUtils.isEmpty((String)info.getName())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"NAME", (Locale)ctx.getLocale()));
        }
        if (errorMsg.length() > 0) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"NOT_NULL", (Locale)ctx.getLocale()));
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString().substring(1, errorMsg.toString().length())});
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }
}

