/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceBillInfo;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeException;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeFactory;
import com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeInfo;
import com.kingdee.eas.tm.im.basedata.AutoSchemeStatusEnum;
import com.kingdee.eas.tm.im.basedata.IAutoMakeInvoiceScheme;
import com.kingdee.eas.tm.im.basedata.app.AbstractAutoMakeInvoiceSchemeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AutoMakeInvoiceSchemeControllerBean
extends AbstractAutoMakeInvoiceSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.AutoMakeInvoiceSchemeControllerBean");

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        AutoMakeInvoiceSchemeInfo info = this.getAutoMakeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoMakeInvocie_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.USING) {
            throw new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.CHECK_USING, new Object[]{info.getNumber()});
        }
        if (info != null && info.isIsDefault()) {
            throw new AutoMakeInvoiceSchemeException(AutoMakeInvoiceSchemeException.CHECK_ISDEFAULT, new Object[]{info.getNumber()});
        }
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
        super._delete(ctx, pk);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoMakeInvoiceSchemeInfo info = this.getAutoMakeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoMakeInvocie_unActive");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.FORBIDDEN) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "CANNOT_INACTIVE", new String[0])});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.USING) {
            info.setStatus(AutoSchemeStatusEnum.FORBIDDEN);
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataSourceBill.*"));
        AutoMakeInvoiceSchemeInfo info = this.getAutoMakeInvoiceSchemeInfo(ctx, pk, sic);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoMakeInvocie_active");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{e.getMessage()});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.USING) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getIMResource(ctx, "CANNOT_ACTIVE", new String[0])});
        }
        if (info != null && info.getStatus() == AutoSchemeStatusEnum.FORBIDDEN) {
            info.setStatus(AutoSchemeStatusEnum.USING);
        }
        this.checkBeforeSubmit(ctx, info);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AutoMakeInvoiceSchemeInfo info = this.getAutoMakeInvoiceSchemeInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "bd_autoMakeInvocie_update");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        super._update(ctx, pk, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AutoMakeInvoiceSchemeInfo info = (AutoMakeInvoiceSchemeInfo)model;
        info.setName(this.trimStr(info.getName()));
        info.setNumber(this.trimStr(info.getNumber()));
        info.setDescription(this.trimStr(info.getDescription()));
        this.checkBeforeSubmit(ctx, info);
        if (info.getId() == null) {
            info.setIsDefault(false);
        }
        return super._submit(ctx, model);
    }

    private String trimStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.trim();
    }

    private void checkBeforeSubmit(Context ctx, AutoMakeInvoiceSchemeInfo info) throws EASBizException, BOSException {
        StringBuffer errorMsg = new StringBuffer();
        AutoMakeInvoiceBillInfo billInfo = info.getDataSourceBill();
        this.checkNumber(ctx, info.getNumber(), info);
        if (StringUtils.isEmpty((String)info.getNumber())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"NUMBER", (Locale)ctx.getLocale()));
        }
        if (StringUtils.isEmpty((String)info.getName())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"NAME", (Locale)ctx.getLocale()));
        }
        if (billInfo == null) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"DATASOURCEBILL", (Locale)ctx.getLocale()));
        }
        if (StringUtils.isEmpty((String)info.getDateFiled())) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"DATEFILED", (Locale)ctx.getLocale()));
        }
        if (errorMsg.length() > 0) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"NOT_NULL", (Locale)ctx.getLocale()));
        }
        if (!(billInfo == null || info.getSrcCombinRule() != null && info.getDestCombinRule() != null || "412A6F98".equals(billInfo.getBillBosType()))) {
            errorMsg.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"CHECK_RULE", (Locale)ctx.getLocale()));
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString().substring(1, errorMsg.toString().length())});
        }
    }

    private void checkNumber(Context ctx, String number, AutoMakeInvoiceSchemeInfo info) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)number)) {
            boolean exists;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (exists = AutoMakeInvoiceSchemeFactory.getLocalInstance(ctx).exists(filterInfo)) {
                String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource", (String)"EXIST_SAME_NUMBER", (Locale)ctx.getOriginLocale());
                throw new IMException(IMException.ERRORMSG, new Object[]{str});
            }
        } else {
            info.setNumber(this.getNewNumber(ctx, info, null, false));
        }
    }

    private String getNewNumber(Context ctx, AutoMakeInvoiceSchemeInfo info, String cuID, boolean addNew) throws EASBizException, BOSException {
        IAutoMakeInvoiceScheme iAutoMakeInvoiceScheme = AutoMakeInvoiceSchemeFactory.getLocalInstance(ctx);
        if (cuID == null || cuID.isEmpty()) {
            cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
        if (addNew && (codingRule == null || !codingRule.isIsAddView())) {
            return "";
        }
        String number = (String)info.get("number");
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        while (number == null || number.equals("") || iAutoMakeInvoiceScheme.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, cuID);
            filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        }
        return number;
    }
}

