/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.app.util.IMServiceCache;
import com.kingdee.eas.tm.im.basedata.BDSyncPropertyCollection;
import com.kingdee.eas.tm.im.basedata.BDSyncPropertyFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncPropertyInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleFactory;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleSegmentInfo;
import com.kingdee.eas.tm.im.basedata.BaseDataStatusEnum;
import com.kingdee.eas.tm.im.basedata.app.AbstractBDSyncRuleControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class BDSyncRuleControllerBean
extends AbstractBDSyncRuleControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.BDSyncRuleControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BDSyncRuleInfo info = (BDSyncRuleInfo)model;
        this.doNumber(ctx, info);
        this.clearTrimInfo(ctx, (IObjectValue)info);
        this.checkBeforeSubmit(ctx, (IObjectValue)info);
        return super._submit(ctx, (IObjectValue)info);
    }

    protected void doNumber(Context ctx, BDSyncRuleInfo info) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)info.getNumber())) {
            String number = this.getNewNumber(ctx, info, info.getCU().getId().toString());
            info.setNumber(number);
        }
        if (info.getNumber() != null) {
            info.setNumber(info.getNumber().trim());
        }
    }

    private String getNewNumber(Context ctx, BDSyncRuleInfo info, String cuID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
        if (codingRule == null) {
            throw new CodingRuleException(CodingRuleException.ERROR_CR_NOTEXIST, new Object[]{""});
        }
        String number = (String)info.get("number");
        int maxCycleNum = 100;
        String filterFormat = "where number = '%s'" + (info.get("id") == null ? "" : "and id !='" + info.get("id") + "'");
        String filterString = null;
        while (true) {
            if (maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            filterString = String.format(filterFormat, number);
            if (!StringUtils.isEmpty((String)number) && !BDSyncRuleFactory.getLocalInstance(ctx).exists(filterString)) break;
            number = iCodingRuleManager.getNumber((IObjectValue)info, cuID);
            --maxCycleNum;
        }
        return number;
    }

    protected void clearTrimInfo(Context ctx, IObjectValue info) {
        String[] fields = new String[]{"number", "description"};
        IMServerUtil.clearTrimInfo(info, fields);
    }

    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        BDSyncRuleInfo info = (BDSyncRuleInfo)model;
        String[] fields = new String[]{"number", "mapping"};
        IMServerUtil.checkEmptyFields(ctx, (IObjectValue)info, fields, null);
        this.checkEmptyPropertyFields(ctx, info);
        this.checkLength(ctx, (IObjectValue)info, null);
        super._checkNumberDup(ctx, (IObjectValue)info);
    }

    private void checkEmptyPropertyFields(Context ctx, BDSyncRuleInfo info) throws BOSException, IMException {
        if (info.getMapping() == null) {
            return;
        }
        BDSyncPropertyCollection coll = BDSyncPropertyFactory.getLocalInstance(ctx).getBDSyncPropertyCollection();
        BDSyncPropertyInfo propertyField = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            propertyField = coll.get(i);
            if (info.getMapping().getBOSType().equals((Object)propertyField.getBillBosType())) break;
        }
        if (propertyField == null || StringUtils.isEmpty((String)propertyField.getRequiredField())) {
            return;
        }
        StringBuffer errorMsg = new StringBuffer();
        BDSyncRuleSegmentInfo entryInfo = null;
        EntityObjectInfo entity = null;
        PropertyInfo property = null;
        StringBuffer emptyFields = null;
        List<String> requiredFieldList = Arrays.asList(propertyField.getRequiredField().split(","));
        int size2 = info.getRuleSegments().size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = info.getRuleSegments().get(i);
            if (!requiredFieldList.contains(entryInfo.getDestPropertyName()) || !StringUtils.isEmpty((String)entryInfo.getSrcExpr())) continue;
            entity = IMServiceCache.getEntity(ctx, info.getMapping().getDestBosType());
            property = entity.getPropertyByName(entryInfo.getDestPropertyName());
            emptyFields = new StringBuffer();
            emptyFields.append(property.getAlias(ctx.getLocale())).append("\u3001");
            errorMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "MSG_ENTRY_NOTNULL", ctx.getLocale(), new Object[]{i + 1, emptyFields.substring(0, emptyFields.length() - 1)})).append("\n");
        }
        if (errorMsg.length() > 0) {
            throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg.toString()});
        }
    }

    protected void checkLength(Context ctx, IObjectValue info, String[] fields) throws EASBizException, BOSException {
        String[] lengthFields = new String[]{"number", "description"};
        String[] checkFields = fields == null ? lengthFields : fields;
        IMServerUtil.checkLengthFields(ctx, info, checkFields);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BDSyncRuleInfo info = this.getBDSyncRuleInfo(ctx, pk);
        if (BaseDataStatusEnum.USING.equals((Object)info.getState())) {
            String str = IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_CANNOT_REMOVE", ctx.getLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        if (info.isIsScheduled()) {
            String str = IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_SCHDULED_CANNOT_REMOVE", ctx.getLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        this.recycleNumber(ctx, pk, info);
        super._delete(ctx, pk);
    }

    private void recycleNumber(Context ctx, IObjectPK pk, BDSyncRuleInfo info) throws EASBizException, BOSException {
        if (info == null || info.getNumber() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("cu.id");
            info = BDSyncRuleFactory.getLocalInstance(ctx).getBDSyncRuleInfo(pk, sic);
        }
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BDSyncRuleInfo info = this.getBDSyncRuleInfo(ctx, pk);
        if (!BaseDataStatusEnum.FORBIDDEN.equals((Object)info.getState())) {
            String str = IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_HAS_USING", ctx.getLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        info.setState(BaseDataStatusEnum.USING);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BDSyncRuleInfo info = this.getBDSyncRuleInfo(ctx, pk);
        if (!BaseDataStatusEnum.USING.equals((Object)info.getState())) {
            String str = IMUtils.getString("com.kingdee.eas.tm.im.basedata.BDSyncRuleResource", "MSG_HAS_FORBIDDEN", ctx.getLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        info.setState(BaseDataStatusEnum.FORBIDDEN);
        this._update(ctx, pk, (IObjectValue)info);
    }
}

