/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.utils.TMCommonUtil;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.basedata.CustomerTaxCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryCollection;
import com.kingdee.eas.tm.im.basedata.CustomerTaxEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.CustomerTaxSourceTypeEnum;
import com.kingdee.eas.tm.im.basedata.CustomerTaxStatusEnum;
import com.kingdee.eas.tm.im.basedata.DiscountTypeEnum;
import com.kingdee.eas.tm.im.basedata.ICustomerTax;
import com.kingdee.eas.tm.im.basedata.IsPrintListEnum;
import com.kingdee.eas.tm.im.basedata.VehicleManageInfo;
import com.kingdee.eas.tm.im.basedata.app.AbstractCustomerTaxControllerBean;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CustomerTaxControllerBean
extends AbstractCustomerTaxControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.CustomerTaxControllerBean");

    @Override
    protected ArrayList _active(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        CustomerTaxCollection coll = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxCollection(view);
        CustomerTaxInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            IObjectPK logPk = LogUtils.beginLog(ctx, "active", BOSObjectType.create((String)"3A8078A7"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_customerTax_active", info.getCU().getId().toString());
            if (!CustomerTaxStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
                errors.add(info.getNumber() + " : " + IMUtils.getIMResource(ctx, "CANNOT_ACTIVE", new String[0]));
                continue;
            }
            Map ret = new HashMap();
            if (info.isIsDefault() && ((Boolean)(ret = this.checkIsDefault(ctx, info.getId().toString(), info.getCompany())).get("hasDefault")).booleanValue()) {
                this._updateDefaultStatus(ctx, (List)ret.get("ids"));
            }
            if (IMUtils.getStringlength(info.getAddressTel()) > 100) {
                errors.add(info.getNumber() + " : " + ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"AddressTel_OverLength", (Locale)ctx.getOriginLocale()));
                continue;
            }
            if (IMUtils.getStringlength(info.getBankAccount()) > 100) {
                errors.add(info.getNumber() + " : " + ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"BANKACCOUNT_OVER_LENGTH", (Locale)ctx.getOriginLocale()));
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("update T_TM_CustomerTax set FStatus = '0' where FID ='" + info.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            LogUtils.afterLog(ctx, logPk);
        }
        return errors;
    }

    private Map checkIsDefault(Context ctx, String id, CompanyOrgUnitInfo company) throws BOSException {
        StringBuffer sql = new StringBuffer();
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        boolean hasDefault = false;
        String cusOrSuppID = null;
        String currentAccountType = null;
        ArrayList<String> ids = new ArrayList<String>();
        sql.append("select FCustomerID,FSupplierID,FCurrentAccountType from T_TM_CustomerTax where fid ='" + id + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("FCurrentAccountType") == null) continue;
                currentAccountType = rs.getString("FCurrentAccountType");
                if ("1".equals(currentAccountType) && rs.getString("FCustomerID") != null) {
                    cusOrSuppID = rs.getString("FCustomerID");
                    continue;
                }
                if (!"2".equals(currentAccountType) || rs.getString("FSupplierID") == null) continue;
                cusOrSuppID = rs.getString("FSupplierID");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append("select fid from T_TM_CustomerTax where FStatus = '0' and FIsDefault  = 1 and Fid !='" + id + "' ");
        if (currentAccountType != null && "1".equals(currentAccountType)) {
            sql.append(" and FCurrentAccountType ='").append(currentAccountType).append("' ");
            if (cusOrSuppID == null) {
                sql.append(" and FCustomerID is null ");
            } else {
                sql.append(" and FCustomerID ='").append(cusOrSuppID).append("' ");
            }
        } else if (currentAccountType != null && "2".equals(currentAccountType)) {
            sql.append(" and FCurrentAccountType ='").append(currentAccountType).append("' ");
            if (cusOrSuppID == null) {
                sql.append(" and FSupplierID is null ");
            } else {
                sql.append(" and FSupplierID ='").append(cusOrSuppID).append("' ");
            }
        } else {
            sql.append(" and FCurrentAccountType is null and FCustomerID is null and FSupplierID is null ");
        }
        if (company == null) {
            sql.append(" and fcompanyid is null ");
        } else {
            sql.append(" and fcompanyid  ='").append(company.getId().toString()).append("' ");
        }
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("fid") == null) continue;
                ids.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.size() > 0) {
            hasDefault = true;
        }
        ret.put("hasDefault", Boolean.valueOf(hasDefault));
        ret.put("ids", ids);
        return ret;
    }

    @Override
    protected ArrayList _inActive(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        CustomerTaxCollection coll = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxCollection(view);
        CustomerTaxInfo info = null;
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            IObjectPK logPk = LogUtils.beginLog(ctx, "unActive", BOSObjectType.create((String)"3A8078A7"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), info.getNumber(), "im_customerTax_unactive", info.getCU().getId().toString());
            if (!CustomerTaxStatusEnum.USING.equals((Object)info.getStatus())) {
                errors.add(info.getNumber() + " : " + IMUtils.getIMResource(ctx, "CANNOT_INACTIVE", new String[0]));
                continue;
            }
            StringBuffer sb = new StringBuffer();
            sb.append("update T_TM_CustomerTax set FStatus = '1' where FID ='" + info.getId().toString() + "'");
            DbUtil.execute((Context)ctx, (String)sb.toString());
            LogUtils.afterLog(ctx, logPk);
        }
        return errors;
    }

    @Override
    protected ArrayList _batchDelete(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < ids.size(); ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)ids.get(i).toString()));
            CustomerTaxInfo info = this.getCustomerTaxInfo(ctx, (IObjectPK)pk);
            if (CustomerTaxStatusEnum.USING.equals((Object)info.getStatus())) {
                errors.add(ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"CANNOTDELETE_USING", (Locale)ctx.getOriginLocale(), (Object[])new String[]{info.getNumber()}));
                continue;
            }
            super.delete(ctx, (IObjectPK)pk);
        }
        return errors;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CustomerTaxInfo customerTaxInfo = (CustomerTaxInfo)model;
        if (StringUtils.isEmpty((String)customerTaxInfo.getNumber())) {
            String number = "";
            number = this.getNewNumber(ctx, customerTaxInfo, String.valueOf(customerTaxInfo.getCU().getId()), false);
            if (!StringUtils.isEmpty((String)number)) {
                customerTaxInfo.setNumber(number);
            }
        }
        if (customerTaxInfo.getNumber() != null) {
            customerTaxInfo.setNumber(customerTaxInfo.getNumber().trim());
        }
        if (customerTaxInfo.getRecCompanyName() != null) {
            customerTaxInfo.setRecCompanyName(customerTaxInfo.getRecCompanyName().trim());
        }
        if (customerTaxInfo.getAddressTel() != null) {
            customerTaxInfo.setAddressTel(customerTaxInfo.getAddressTel().trim());
        }
        if (customerTaxInfo.getBankAccount() != null) {
            customerTaxInfo.setBankAccount(customerTaxInfo.getBankAccount().trim());
        }
        if (customerTaxInfo.getOrgCode() != null) {
            customerTaxInfo.setOrgCode(customerTaxInfo.getOrgCode().trim());
        }
        if (IMUtils.getStringlength(customerTaxInfo.getAddressTel()) > 100) {
            throw new IMException(IMException.ERRORMSG, new Object[]{customerTaxInfo.getNumber() + " : " + ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"AddressTel_OverLength", (Locale)ctx.getOriginLocale())});
        }
        if (IMUtils.getStringlength(customerTaxInfo.getBankAccount()) > 100) {
            throw new IMException(IMException.ERRORMSG, new Object[]{customerTaxInfo.getNumber() + " : " + ResourceBase.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"BANKACCOUNT_OVER_LENGTH", (Locale)ctx.getOriginLocale())});
        }
        FilterInfo idFilterInfo = new FilterInfo();
        idFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)customerTaxInfo.getId()));
        boolean exists = CustomerTaxFactory.getLocalInstance(ctx).exists(idFilterInfo);
        this.checkNumber(ctx, customerTaxInfo.getNumber(), customerTaxInfo);
        this.checkEntryIsDefault(ctx, customerTaxInfo.getNumber(), customerTaxInfo);
        String[] lengthFields = new String[]{"number", "recCompanyName", "TaxNumber", "addressTel", "bankAccount", "orgCode"};
        IMServerUtil.checkLengthFields(ctx, (IObjectValue)customerTaxInfo, lengthFields);
        if (exists) {
            return super._submit(ctx, (IObjectValue)customerTaxInfo);
        }
        return super._save(ctx, (IObjectValue)customerTaxInfo);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._submit(ctx, model);
    }

    private void checkEntryIsDefault(Context ctx, String number, CustomerTaxInfo info) throws BOSException, EASBizException {
        CustomerTaxEntryCollection entries = info.getEntries();
        CustomerTaxEntryInfo entryInfo = null;
        int entryIsdefault = 0;
        for (int i = 0; i < entries.size(); ++i) {
            entryInfo = entries.get(i);
            if (!entryInfo.isIsDefault()) continue;
            ++entryIsdefault;
        }
        if (entryIsdefault > 1) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EntryIsDefaultError", (Locale)ctx.getOriginLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
    }

    private void checkNumber(Context ctx, String number, CustomerTaxInfo info) throws BOSException, EASBizException {
        if (number != null && !"".equals(number.trim())) {
            boolean exists;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (exists = CustomerTaxFactory.getLocalInstance(ctx).exists(filterInfo)) {
                String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.CustomerTaxResource", (String)"EXIST_SAME_NUMBER", (Locale)ctx.getOriginLocale());
                throw new IMException(IMException.ERRORMSG, new Object[]{str});
            }
        } else {
            info.setNumber(this.getNewNumber(ctx, info, null, false));
        }
        if (StringUtils.isEmpty((String)number)) {
            String numberAlias = IMUtils.getString("com.kingdee.eas.tm.im.basedata.CustomerTaxResource", "NUMBER", ctx.getLocale());
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{numberAlias});
        }
    }

    private String getNewNumber(Context ctx, CustomerTaxInfo info, String cuID, boolean addNew) throws EASBizException, BOSException {
        ICustomerTax iCustomerTax = CustomerTaxFactory.getLocalInstance(ctx);
        if (cuID == null || cuID.isEmpty()) {
            cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
        if (addNew && (codingRule == null || !codingRule.isIsAddView())) {
            return "";
        }
        if (codingRule == null) {
            return "";
        }
        String number = (String)info.get("number");
        int maxCycleNum = 100;
        String filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        while (number == null || number.equals("") || iCustomerTax.exists(filterString)) {
            if (--maxCycleNum == 0) {
                throw new CodingRuleException(CodingRuleException.ERROR_REFERENCE_INVALID);
            }
            number = iCodingRuleManager.getNumber((IObjectValue)info, cuID);
            filterString = "where number = '" + number + "' " + (info.get("id") != null ? "and id !='" + info.get("id") + "'" : "");
        }
        return number;
    }

    @Override
    protected String _getNewNumber(Context ctx, CustomerTaxInfo info, String cuID) throws BOSException, EASBizException {
        return this.getNewNumber(ctx, info, cuID, true);
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBaseInfo value = this.getValue(ctx, pk);
        return value.getLogInfo();
    }

    @Override
    protected Map _isHasDefault(Context ctx, String cusOrSupId, String customerTaxId, String companyId, String currentAccountType) throws BOSException, EASBizException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        ArrayList<String> ids = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT  fid FROM T_TM_CustomerTax where FIsDefault=1 and FStatus='0' ");
        if ("1".equals(currentAccountType)) {
            sql.append(" and FCurrentAccountType ='").append(currentAccountType).append("' ");
            if (StringUtils.isEmpty((String)cusOrSupId)) {
                sql.append(" and FCustomerID is null ");
            } else {
                sql.append(" and FCustomerID='").append(cusOrSupId).append("' ");
            }
        } else if ("2".equals(currentAccountType)) {
            sql.append(" and FCurrentAccountType ='").append(currentAccountType).append("' ");
            if (StringUtils.isEmpty((String)cusOrSupId)) {
                sql.append(" and FSupplierID is null ");
            } else {
                sql.append(" and FSupplierID='").append(cusOrSupId).append("' ");
            }
        }
        if (companyId == null) {
            sql.append(" and fcompanyid is null ");
        } else {
            sql.append(" and fcompanyid  ='").append(companyId).append("' ");
        }
        if (customerTaxId != null && !customerTaxId.isEmpty()) {
            sql.append(" and fid !='").append(customerTaxId).append("' ");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("fid") == null) continue;
                ids.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (ids.size() == 0) {
            map.put("result", Boolean.valueOf(false));
        } else {
            map.put("result", Boolean.valueOf(true));
        }
        map.put("ids", ids);
        return map;
    }

    @Override
    protected void _updateDefaultStatus(Context ctx, List ids) throws BOSException, EASBizException {
        String updateSql = "update T_TM_CustomerTax set FIsDefault = 0 where fid in (" + CollectionUtil.convertList2String(ids) + ")";
        DBUtil.executeUpdate((Context)ctx, (String)updateSql, null);
    }

    @Override
    protected Map _getCustomerTaxInfo(Context ctx, Map params) throws BOSException, EASBizException {
        CustomerTaxInfo taxInfo;
        HashMap<String, CustomerTaxInfo> ret = new HashMap<String, CustomerTaxInfo>();
        String custOrSuppId = (String)params.get("customerId");
        String bosType = "";
        if (!(StringUtils.isEmpty((String)custOrSuppId) || "CUSTOMER_EMPTY".equals(custOrSuppId) || "CUSTOMER_EMPTY".equals(custOrSuppId))) {
            try {
                bosType = BOSUuid.read((String)custOrSuppId).getType().toString();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                return ret;
            }
        }
        String invoiceType = (String)params.get("invoiceType");
        String taxNumber = (String)params.get("taxNumber");
        String companyId = (String)params.get("companyId");
        String recCompany = (String)params.get("receiveCompany");
        String isVehicle = null;
        if (params.get("isVehicle") instanceof String) {
            isVehicle = (String)params.get("isVehicle");
        } else if (params.get("isVehicle") instanceof Boolean) {
            isVehicle = (Boolean)params.get("isVehicle") != false ? "1" : "0";
        }
        ArrayList<CustomerTaxInfo> customerTaxColl = new ArrayList<CustomerTaxInfo>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT CUSTOMERTAX.FID AS FID,CUSTOMERTAX.FRecCompanyName AS RECCOMPANYNAME,");
        sql.append(" CUSTOMERTAX.FTaxNumber AS TAXNUMBER, CUSTOMERTAX.FAddressTel AS ADDRESSTEL, CUSTOMERTAX.FBankAccount AS BANKACCOUNT,CUSTOMERTAX.FOrgCode AS ORGCODE,");
        sql.append(" CUSTOMERTAX.FIsDefault AS IsDefault,CUSTOMERTAX.FIsValueAdded AS IsValueAdded,CUSTOMERTAX.FCompanyID AS COMPANYID,");
        sql.append(" ENTRIES.FLimitAmt AS LimitAmt,ENTRIES.FDiscountType AS DiscountType,");
        sql.append(" ENTRIES.FIsPrintList AS IsPrintList,ENTRIES.FIsDefault AS EntryIsDefault,ENTRIES.FInvoiceType AS invoiceType,CUSTOMERTAX.FVehicleManageID as FVehicleManageID ");
        if ("37C67DFC".equals(bosType)) {
            sql.append(" ,CUSTOMERTAX.FSupplierID AS SUPPLIERID,SUPPLIER.FName_l2 AS SUPPLIERNAME ");
        } else if ("BF0C040E".equals(bosType)) {
            sql.append(" ,CUSTOMERTAX.FCustomerID AS CUSTOMERID,CUSTOMER.FName_l2 AS CUSTOMERNAME ");
        }
        sql.append(" FROM T_TM_CustomerTax AS CUSTOMERTAX ");
        if ("37C67DFC".equals(bosType)) {
            sql.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON CUSTOMERTAX.FSupplierID = SUPPLIER.FID ");
        } else if ("BF0C040E".equals(bosType)) {
            sql.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON CUSTOMERTAX.FCustomerID = CUSTOMER.FID ");
        }
        sql.append(" LEFT OUTER JOIN T_TM_CustomerTaxEntry AS ENTRIES ON CUSTOMERTAX.FID = ENTRIES.FParentID ");
        sql.append(" where 1=1");
        if (!StringUtils.isEmpty((String)invoiceType) && !"-1".equals(invoiceType)) {
            sql.append(" and ENTRIES.FInvoiceType='" + invoiceType + "' ");
        }
        if ("CUSTOMER_EMPTY".equals(custOrSuppId)) {
            sql.append(" and CUSTOMERTAX.FSupplierID is null ");
        } else if ("CUSTOMER_EMPTY".equals(custOrSuppId)) {
            sql.append(" and CUSTOMERTAX.FCustomerID is null ");
        } else if ("37C67DFC".equals(bosType)) {
            sql.append(" and CUSTOMERTAX.FSupplierID='" + custOrSuppId + "'");
        } else if ("BF0C040E".equals(bosType)) {
            sql.append(" and CUSTOMERTAX.FCustomerID='" + custOrSuppId + "'");
        }
        if (!StringUtils.isEmpty((String)taxNumber)) {
            sql.append("  and FTaxNumber='" + taxNumber + "' ");
        }
        if (!StringUtils.isEmpty((String)companyId)) {
            sql.append(" and (CUSTOMERTAX.FCompanyId ='" + companyId + "' or CUSTOMERTAX.FCompanyId is null)");
        } else {
            sql.append(" and CUSTOMERTAX.FCompanyId is null");
        }
        if (recCompany != null && !recCompany.trim().isEmpty()) {
            sql.append(" and CUSTOMERTAX.FRecCompanyName='" + recCompany + "' ");
        }
        if (!StringUtils.isEmpty((String)isVehicle)) {
            sql.append(" and  CUSTOMERTAX.FIsVehicle = " + isVehicle);
        }
        sql.append(" and CUSTOMERTAX.FStatus ='0' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                taxInfo = new CustomerTaxInfo();
                CustomerTaxEntryInfo entryInfo = new CustomerTaxEntryInfo();
                taxInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                if ("37C67DFC".equals(bosType)) {
                    if (!StringUtils.isEmpty((String)rs.getString("SUPPLIERID"))) {
                        SupplierInfo supplier = new SupplierInfo();
                        supplier.setId(BOSUuid.read((String)rs.getString("SUPPLIERID")));
                        supplier.setName(rs.getString("SUPPLIERNAME"));
                        taxInfo.setSupplier(supplier);
                    }
                } else if ("BF0C040E".equals(bosType) && !StringUtils.isEmpty((String)rs.getString("CUSTOMERID"))) {
                    CustomerInfo customer = new CustomerInfo();
                    customer.setId(BOSUuid.read((String)rs.getString("CUSTOMERID")));
                    customer.setName(rs.getString("CUSTOMERNAME"));
                    taxInfo.setCustomer(customer);
                }
                taxInfo.setRecCompanyName(rs.getString("RECCOMPANYNAME"));
                taxInfo.setTaxNumber(rs.getString("TAXNUMBER"));
                taxInfo.setAddressTel(rs.getString("ADDRESSTEL"));
                taxInfo.setBankAccount(rs.getString("BANKACCOUNT"));
                taxInfo.setOrgCode(rs.getString("ORGCODE"));
                taxInfo.setIsDefault(rs.getInt("IsDefault") == 1);
                taxInfo.setIsValueAdded(rs.getInt("IsValueAdded") == 1);
                String vehicleManageId = rs.getString("FVehicleManageID");
                if (!StringUtils.isEmpty((String)vehicleManageId)) {
                    VehicleManageInfo vehicleManageInfo = new VehicleManageInfo();
                    vehicleManageInfo.setId(BOSUuid.read((String)vehicleManageId));
                    taxInfo.setVehicleManage(vehicleManageInfo);
                }
                if (!StringUtils.isEmpty((String)rs.getString("COMPANYID"))) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)rs.getString("COMPANYID")));
                    taxInfo.setCompany(company);
                }
                entryInfo.setInvoiceType(PayInvoiceTypeEnum.getEnum((String)rs.getString("invoiceType")));
                String discount = rs.getString("DiscountType");
                if ("2".equals(discount)) {
                    entryInfo.setDiscountType(DiscountTypeEnum.NOTSPLIT);
                } else if ("1".equals(discount)) {
                    entryInfo.setDiscountType(DiscountTypeEnum.SPLIT);
                } else {
                    entryInfo.setDiscountType(DiscountTypeEnum.NULL);
                }
                String isPrintList = rs.getString("IsPrintList");
                if ("1".equals(isPrintList)) {
                    entryInfo.setIsPrintList(IsPrintListEnum.PRINTLIST);
                } else if ("2".equals(isPrintList)) {
                    entryInfo.setIsPrintList(IsPrintListEnum.NOPRINTLIST);
                } else {
                    entryInfo.setIsPrintList(IsPrintListEnum.NULL);
                }
                entryInfo.setIsDefault(rs.getInt("EntryIsDefault") == 1);
                entryInfo.setLimitAmt(rs.getBigDecimal("LimitAmt"));
                taxInfo.getEntries().add(entryInfo);
                customerTaxColl.add(taxInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        taxInfo = null;
        if (customerTaxColl.size() <= 0) {
            ret.put("value", taxInfo);
            return ret;
        }
        taxInfo = (CustomerTaxInfo)customerTaxColl.get(0);
        boolean isDeafult = true;
        for (CustomerTaxInfo ctInfo : customerTaxColl) {
            if (ctInfo.isIsDefault()) {
                isDeafult = false;
                if (ctInfo.getEntries().get(0).isIsDefault()) {
                    taxInfo = ctInfo;
                    break;
                }
                taxInfo = ctInfo;
            }
            if (!isDeafult || !ctInfo.getEntries().get(0).isIsDefault()) continue;
            taxInfo = ctInfo;
        }
        boolean isDeafultByCompany = true;
        boolean isEntryDeafultByCompany = true;
        if (!StringUtils.isEmpty((String)companyId)) {
            for (CustomerTaxInfo ctInfo : customerTaxColl) {
                if (ctInfo.getCompany() == null || !companyId.equals(ctInfo.getCompany().getId().toString())) continue;
                if (ctInfo.isIsDefault()) {
                    isDeafultByCompany = false;
                    if (ctInfo.getEntries().get(0).isIsDefault()) {
                        taxInfo = ctInfo;
                        break;
                    }
                    taxInfo = ctInfo;
                }
                if (!isDeafultByCompany) continue;
                if (ctInfo.getEntries().get(0).isIsDefault()) {
                    isEntryDeafultByCompany = false;
                    taxInfo = ctInfo;
                }
                if (!isEntryDeafultByCompany) continue;
                taxInfo = ctInfo;
            }
        }
        ret.put("value", taxInfo);
        return ret;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CustomerTaxInfo info = this.getCustomerTaxInfo(ctx, pk);
        if (info.getNumber() != null) {
            String cuID = info.getCU().getId().toString();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, cuID);
            if (codeRuleInfo != null && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, cuID) || codeRuleInfo.isIsaddnewbreak())) {
                iCodingRuleManager.recycleNumber((IObjectValue)info, cuID, info.getNumber());
            }
        }
        super._delete(ctx, pk);
    }

    @Override
    protected Map _syncCustomerTax(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        try {
            HashSet<String> idSet = new HashSet<String>();
            if (param.containsKey("idList")) {
                List idList = (List)param.get("idList");
                idSet.addAll(idList);
                if (this.filterExist(ctx, idSet)) {
                    String companyID = (String)param.get("cuid");
                    Map<String, String> bankMap = this.matchCustomerCompanyBank(ctx, idSet, companyID);
                    this.createCustomerTaxByCustomer(ctx, idSet, companyID, bankMap);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)("[syncCustomerTax] error:" + e.getMessage()), e);
        }
        return result;
    }

    protected boolean filterExist(Context ctx, Set idSet) throws BOSException, SQLException {
        if (idSet == null || idSet.size() == 0) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FCustomerID from T_TM_CustomerTax where FCustomerID in ").append(IMUtils.getInStringFromSet(idSet));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet.next()) {
            String id = rowSet.getString(1);
            idSet.remove(id);
            logger.error((Object)("[syncProductCode] filterExist id : " + id));
        }
        return idSet.size() > 0;
    }

    protected Map<String, String> matchCustomerCompanyBank(Context ctx, Set idSet, String companyID) throws BOSException, SQLException {
        HashMap<String, String> bankMap = new HashMap<String, String>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT");
        sql.append(" cusCompany.FCUSTOMERID as customerID,");
        sql.append(" bank.FISDEFAULT as isDefault,");
        sql.append(" bank.FBANK as bank,");
        sql.append(" bank.FBANKACCOUNT as bankAccount");
        sql.append(" FROM T_BD_CustomerCompanyBank  bank");
        sql.append(" left  join T_BD_CustomerCompanyInfo cusCompany on cusCompany.FID  = bank.FCUSTOMERCOMPANYINFOID");
        sql.append(" where cusCompany.FCOMORGID ='").append(companyID).append("'");
        sql.append("  and cusCompany.FCUSTOMERID in ").append(TMCommonUtil.getInStringFromSet((Set)idSet));
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String customerID = null;
        boolean isDefault = false;
        String bank = null;
        String bankAccount = null;
        while (rowSet.next()) {
            isDefault = rowSet.getBoolean("isDefault");
            if (!isDefault) continue;
            customerID = rowSet.getString("customerID");
            bank = rowSet.getString("bank");
            bank = StringUtils.isEmpty((String)bank) ? "" : bank;
            bankAccount = rowSet.getString("bankAccount");
            String string = bankAccount = StringUtils.isEmpty((String)bankAccount) ? "" : bankAccount;
            if (StringUtils.isEmpty((String)bank) && StringUtils.isEmpty((String)bankAccount)) continue;
            bankMap.put(customerID, bank + bankAccount);
        }
        return bankMap;
    }

    protected void createCustomerTaxByCustomer(Context ctx, Set<String> idSet, String companyID, Map<String, String> bankMap) throws BOSException, SQLException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("taxRegisterNo"));
        sic.add(new SelectorItemInfo("address"));
        sic.add(new SelectorItemInfo("invoiceType"));
        sic.add(new SelectorItemInfo("CU.id"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        CustomerCollection customerColl = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(viewInfo);
        CustomerTaxInfo customerTaxInfo = null;
        CustomerTaxEntryInfo entry = null;
        CustomerTaxEntryCollection entryColl = null;
        if (customerColl != null && customerColl.size() > 0) {
            CustomerInfo customerInfo = null;
            int size = customerColl.size();
            for (int i = 0; i < size; ++i) {
                customerInfo = customerColl.get(i);
                customerTaxInfo = new CustomerTaxInfo();
                customerTaxInfo.setId(BOSUuid.create((String)"3A8078A7"));
                customerTaxInfo.setNumber(this.getSyncNumber(ctx, customerInfo.getNumber()));
                customerTaxInfo.setStatus(CustomerTaxStatusEnum.FORBIDDEN);
                customerTaxInfo.setTaxNumber(customerInfo.getTaxRegisterNo());
                customerTaxInfo.setAddressTel(customerInfo.getAddress());
                customerTaxInfo.setCurrentAccountType(CurrentAccountType.CUSTOMER);
                customerTaxInfo.setCustomer(customerInfo);
                customerTaxInfo.setRecCompanyName(customerInfo.getName());
                customerTaxInfo.setCU(customerInfo.getCU());
                customerTaxInfo.setSourceType(CustomerTaxSourceTypeEnum.SYNC);
                customerTaxInfo.setIsValueAdded(true);
                customerTaxInfo.setIsDefault(true);
                customerTaxInfo.setIsVehicle(false);
                if (bankMap.containsKey(customerInfo.getId().toString())) {
                    String bankAccount = bankMap.get(customerInfo.getId().toString());
                    if (!StringUtils.isEmpty((String)bankAccount) && bankAccount.length() > 300) {
                        customerTaxInfo.setBankAccount(bankMap.get(customerInfo.getId().toString()).substring(0, 299));
                    } else {
                        customerTaxInfo.setBankAccount(bankMap.get(customerInfo.getId().toString()));
                    }
                }
                PayInvoiceTypeEnum invoiceType = customerInfo.getInvoiceType();
                entryColl = new CustomerTaxEntryCollection();
                Iterator invoiceTypes = PayInvoiceTypeEnum.iterator();
                ICustomerTax iCustomerTax = CustomerTaxFactory.getLocalInstance(ctx);
                while (invoiceTypes.hasNext()) {
                    PayInvoiceTypeEnum tempInvoiceType = (PayInvoiceTypeEnum)invoiceTypes.next();
                    if (tempInvoiceType == PayInvoiceTypeEnum.DEFAULTTYPE) continue;
                    entry = new CustomerTaxEntryInfo();
                    entry.setInvoiceType(tempInvoiceType);
                    entry.setLimitAmt(BigDecimal.ZERO);
                    entry.setDiscountType(DiscountTypeEnum.NULL);
                    entry.setIsPrintList(IsPrintListEnum.NULL);
                    entry.setParent(customerTaxInfo);
                    if (tempInvoiceType.equals((Object)invoiceType)) {
                        entry.setIsDefault(true);
                    } else {
                        entry.setIsDefault(false);
                    }
                    if (tempInvoiceType.equals((Object)PayInvoiceTypeEnum.VALUEADDEDTAXINV)) {
                        entryColl.insertObject(-1, (IObjectValue)entry);
                        continue;
                    }
                    entryColl.add(entry);
                }
                customerTaxInfo.getEntries().addCollection(entryColl);
                LogControllManager.getInstance().enableLog();
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                iCustomerTax.saveRequiresNew((IObjectValue)customerTaxInfo);
            }
        }
    }

    protected String getSyncNumber(Context ctx, String number) throws BOSException, SQLException {
        block1: {
            String sql1 = " select 1 from T_TM_CustomerTax where fnumber = '";
            String sql2 = "' ";
            StringBuffer sql = new StringBuffer();
            do {
                sql.setLength(0);
                sql.append(sql1).append(number).append(sql2);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (!rowSet.next()) break block1;
            } while ((number = number + "_NewNum").length() <= 100);
            return number.substring(100);
        }
        return number;
    }

    @Override
    protected IObjectPK _saveRequiresNew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this._save(ctx, model);
    }
}

