/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.RefCheckerFactory;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.basedata.BaseDataStatusEnum;
import com.kingdee.eas.tm.im.basedata.VehicleManageFactory;
import com.kingdee.eas.tm.im.basedata.VehicleManageInfo;
import com.kingdee.eas.tm.im.basedata.app.AbstractVehicleManageControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import java.util.Locale;
import org.apache.log4j.Logger;

public class VehicleManageControllerBean
extends AbstractVehicleManageControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.basedata.app.VehicleManageControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VehicleManageInfo info = (VehicleManageInfo)model;
        FilterInfo idFilterInfo = new FilterInfo();
        idFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId()));
        boolean exists = VehicleManageFactory.getLocalInstance(ctx).exists(idFilterInfo);
        this.checkNumber(ctx, info.getNumber(), info);
        if (exists) {
            this.checkState(ctx, info);
            return super._submit(ctx, (IObjectValue)info);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        VehicleManageInfo info = (VehicleManageInfo)model;
        FilterInfo idFilterInfo = new FilterInfo();
        idFilterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId()));
        boolean exists = VehicleManageFactory.getLocalInstance(ctx).exists(idFilterInfo);
        this.checkNumber(ctx, info.getNumber(), info);
        if (exists) {
            this.checkState(ctx, info);
            super._submit(ctx, pk, (IObjectValue)info);
        } else {
            super._save(ctx, pk, (IObjectValue)info);
        }
    }

    private void checkState(Context ctx, VehicleManageInfo info) throws IMException {
        if (info.getStatus().equals((Object)BaseDataStatusEnum.USING)) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.VehicleManageResource", (String)"CANNOTEDIT", (Locale)ctx.getOriginLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
    }

    private void checkNumber(Context ctx, String number, VehicleManageInfo info) throws BOSException, EASBizException {
        if (number != null && !"".equals(number.trim())) {
            boolean exists;
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            if (info.getId() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (exists = VehicleManageFactory.getLocalInstance(ctx).exists(filterInfo)) {
                String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.VehicleManageResource", (String)"EXIST_SAME_NUMBER", (Locale)ctx.getOriginLocale());
                throw new IMException(IMException.ERRORMSG, new Object[]{str});
            }
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VehicleManageInfo info = this.getVehicleManageInfo(ctx, pk);
        if (info.getStatus() == BaseDataStatusEnum.USING) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.tm.im.basedata.VehicleManageResource", (String)"CANNOTREMOVE", (Locale)ctx.getOriginLocale());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        Boolean isReference = RefCheckerFactory.getLocalInstance((Context)ctx).isReferenced(info.getId());
        if (isReference.booleanValue()) {
            String str = IMUtils.getIMResource(ctx, "CANNOTDELETE_USED", info.getNumber());
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _active(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VehicleManageInfo info = this.getVehicleManageInfo(ctx, pk);
        if (!BaseDataStatusEnum.FORBIDDEN.equals((Object)info.getStatus())) {
            String str = IMUtils.getIMResource(ctx, "CANNOT_ACTIVE", new String[0]) + "!";
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        info.setStatus(BaseDataStatusEnum.USING);
        this._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _inActive(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        VehicleManageInfo info = this.getVehicleManageInfo(ctx, pk);
        if (!BaseDataStatusEnum.USING.equals((Object)info.getStatus())) {
            String str = IMUtils.getIMResource(ctx, "CANNOT_INACTIVE", new String[0]) + "!";
            throw new IMException(IMException.ERRORMSG, new Object[]{str});
        }
        info.setStatus(BaseDataStatusEnum.FORBIDDEN);
        this._update(ctx, pk, (IObjectValue)info);
    }
}

