/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app.transformer;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.ProductCodeSourceTypeEnum;
import com.kingdee.eas.tm.im.ProductCodeStatusEnum;
import com.kingdee.eas.tm.im.basedata.app.transformer.ProductCodeTransformer;
import com.kingdee.eas.tm.im.common.model.ClassfiyOverLengthField;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class Material2ProductCodeSyncTransformer
extends ProductCodeTransformer {
    private static final Logger logger = Logger.getLogger(Material2ProductCodeSyncTransformer.class);

    public Material2ProductCodeSyncTransformer(Context ctx) {
        super(ctx);
    }

    protected ProductCodeInfo defaultTransfor(IObjectValue srcObj) throws BOSException, EASBizException {
        MaterialInfo info = (MaterialInfo)srcObj;
        ProductCodeInfo product = new ProductCodeInfo();
        product.setId(BOSUuid.create((String)this.getDestBosType()));
        String number = info.getNumber();
        logger.debug((Object)("[Material2ProductCodeSyncTransformer] defaultTransfor number : " + number));
        product.setNumber(this.getSyncNumber(this.ctx, number));
        product.setName(info.getName());
        product.setMaterial(info);
        product.setStatus(ProductCodeStatusEnum.FORBIDDEN);
        product.setModel(info.getModel());
        product.setUnit(info.getBaseUnit());
        product.setIsTax(true);
        product.setSourceType(ProductCodeSourceTypeEnum.SYNC);
        product.setCU(info.getCU());
        return product;
    }

    @Override
    protected ClassfiyOverLengthField getClassfiyOverLengthField() {
        HashMap<String, Integer> fieldLengthMap = new HashMap<String, Integer>();
        fieldLengthMap.put("model", 40);
        return ClassfiyOverLengthField.custom().setOverLengthFields(new String[]{"number", "name", "model"}).setFieldLengthMap(fieldLengthMap).build();
    }

    @Override
    protected String getRelationField() {
        return "material";
    }

    @Override
    public String getSrcBosType() {
        return "4409E7F0";
    }

    @Override
    protected SelectorItemCollection getSelector() {
        return super.getSelector();
    }
}

