/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.basedata.app.transformer;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.tm.im.ProductCodeInfo;
import com.kingdee.eas.tm.im.basedata.BDSyncRuleInfo;
import com.kingdee.eas.tm.im.basedata.app.transformer.BaseDataTransformer;
import java.util.List;

public abstract class ProductCodeTransformer
extends BaseDataTransformer {
    private final String[] TCC_FIELDS = new String[]{"taxClassificationCode", "taxRate", "hasPreferential", "preferentialPolicies", "taxClass"};

    public ProductCodeTransformer(Context ctx) {
        super(ctx);
    }

    @Override
    protected IObjectValue segTransfor(IObjectValue srcObj, BDSyncRuleInfo rule) throws Exception {
        ProductCodeInfo info = (ProductCodeInfo)super.segTransfor(srcObj, rule);
        this.setAutoMatchTccCodeFlag(info, rule);
        return info;
    }

    private void setAutoMatchTccCodeFlag(ProductCodeInfo info, BDSyncRuleInfo rule) {
        List<String> destExprFields = rule.getDestExprFields();
        boolean autoMatchTccCode = true;
        int size = this.TCC_FIELDS.length;
        for (int i = 0; i < size; ++i) {
            if (!destExprFields.contains(this.TCC_FIELDS[i])) continue;
            autoMatchTccCode = false;
            break;
        }
        info.setAutoMatchTccCode(autoMatchTccCode);
    }

    @Override
    public String getDestBosType() {
        return "268661B5";
    }
}

