/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.calculate;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.runtime.Interpreter;
import com.kingdee.bos.kscript.runtime.InterpreterException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.util.ExpressionParser;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PropertyCalculator {
    protected static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.calculate.PropertyCalculator");
    private IObjectValue entry;
    private IRow curRow;
    private Set propertySet = null;
    private Map fieldMap = null;

    public PropertyCalculator(IObjectValue entry) {
        this.entry = entry;
    }

    public PropertyCalculator(IObjectValue entry, Map fieldMap) {
        this(entry);
        this.fieldMap = fieldMap;
    }

    public PropertyCalculator(IRow curRow) {
        this.curRow = curRow;
    }

    public PropertyCalculator(IRow curRow, Map fieldMap) {
        this(curRow);
        this.fieldMap = fieldMap;
    }

    private boolean checkExprssion(String expr) {
        boolean isValid = false;
        ExpressionParser expPars = ExpressionParser.getInstance();
        isValid = expPars.isExpression(expr);
        return true;
    }

    public BigDecimal getBigDecimal(String property) {
        String destProperty = property;
        if (this.fieldMap != null && this.fieldMap.containsKey(property)) {
            destProperty = this.fieldMap.get(property).toString();
        }
        if (this.entry != null) {
            return this.nullToZero(this.entry.getBigDecimal(destProperty));
        }
        if (this.curRow != null) {
            Object value = this.getCurRowValue(destProperty);
            if (value != null) {
                if (value instanceof BigDecimal) {
                    return this.nullToZero((BigDecimal)value);
                }
                BigDecimal value_BD = new BigDecimal(value.toString());
                return this.nullToZero(value_BD);
            }
            return this.nullToZero(null);
        }
        return this.nullToZero(null);
    }

    public Object getValue(String property) {
        String destProperty = property;
        if (this.fieldMap != null && this.fieldMap.containsKey(property)) {
            destProperty = this.fieldMap.get(property).toString();
        }
        if (this.entry != null) {
            return this.entry.get(destProperty);
        }
        if (this.curRow != null) {
            return this.getCurRowValue(destProperty);
        }
        return null;
    }

    public void setValue(String property, Object value) {
        String destProperty = property;
        if (this.fieldMap != null && this.fieldMap.containsKey(property)) {
            destProperty = this.fieldMap.get(property).toString();
        }
        if (this.entry != null) {
            this.entry.put(destProperty, value);
        } else if (this.curRow != null) {
            this.setCurRowValue(destProperty, value);
        }
    }

    private Object getCurRowValue(String property) {
        Object value = null;
        try {
            value = this.curRow.getCell(property).getValue();
        }
        catch (Throwable e) {
            logger.error((Object)("[" + property + "]" + e.getMessage()), e);
        }
        return value;
    }

    private Object setCurRowValue(String property, Object value) {
        try {
            this.curRow.getCell(property).setValue(value);
        }
        catch (Throwable e) {
            logger.error((Object)("[" + property + "]" + e.getMessage()), e);
        }
        return value;
    }

    protected BigDecimal nullToZero(BigDecimal value) {
        if (value == null) {
            return SysConstant.BIGZERO;
        }
        return value;
    }

    public void evalForEntry(String expression, int precision) {
        if (this.checkExprssion(expression)) {
            ExpressionParser expPars = ExpressionParser.getInstance();
            String feekBaceProp = expression.substring(0, expression.indexOf("="));
            if (this.fieldMap != null && this.fieldMap.containsKey(feekBaceProp)) {
                feekBaceProp = this.fieldMap.get(feekBaceProp).toString();
            }
            String subExp = expression.substring(expression.indexOf("=") + 1);
            String[] varis = expPars.splitVariables(subExp);
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.propertySet = new HashSet();
            if (varis != null) {
                for (int i = 0; i < varis.length; ++i) {
                    String var = varis[i];
                    this.propertySet.add(var);
                }
                String property = "";
                Iterator it = this.propertySet.iterator();
                Object obj = null;
                while (it.hasNext()) {
                    String destProperty = property = (String)it.next();
                    if (this.fieldMap != null && this.fieldMap.containsKey(property)) {
                        destProperty = this.fieldMap.get(property).toString();
                    }
                    if (this.entry != null) {
                        obj = this.entry.get(destProperty);
                        if (obj == null) {
                            obj = SysConstant.BIGZERO;
                        }
                        map.put(property, obj);
                        continue;
                    }
                    if (this.curRow == null) continue;
                    obj = this.getCurRowValue(destProperty);
                    if (obj == null) {
                        obj = SysConstant.BIGZERO;
                    }
                    map.put(property, obj);
                }
            }
            Interpreter interpreter = new Interpreter();
            try {
                Object result = interpreter.eval(subExp, map);
                if (result instanceof Number) {
                    BigDecimal bg = SysConstant.BIGZERO;
                    bg = new BigDecimal(result.toString());
                    if (precision >= 0) {
                        bg = bg.setScale(precision, 4);
                    }
                    if (feekBaceProp.length() != 0) {
                        if (this.entry != null) {
                            this.entry.put(feekBaceProp, (Object)bg);
                        } else if (this.curRow != null) {
                            this.setCurRowValue(feekBaceProp, bg);
                        }
                    }
                } else if (feekBaceProp.length() != 0) {
                    if (this.entry != null) {
                        this.entry.put(feekBaceProp, result);
                    } else if (this.curRow != null) {
                        this.setCurRowValue(feekBaceProp, result);
                    }
                }
            }
            catch (InterpreterException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.info((Object)("Interpreter expression error:" + expression));
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                logger.info((Object)("Parse expression error:" + expression));
            }
        }
    }

    public void batchEvalForEntry(String[] expressions, int[] precisions) {
        if (expressions != null && precisions != null && expressions.length == precisions.length) {
            String expr = "";
            int precision = 4;
            for (int i = 0; i < expressions.length; ++i) {
                expr = expressions[i];
                precision = precisions[i];
                this.evalForEntry(expr, precision);
            }
        }
    }
}

