/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.app.AbstractIncomeInvoiceReWriteFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.msg.result.CertificateInvoiceResult;
import com.kingdee.eas.tm.im.common.comm.msg.result.IncomeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.tm.im.util.invoice.PoolDownloadInvoiceServerService;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IncomeInvoiceReWriteFacadeControllerBean
extends AbstractIncomeInvoiceReWriteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.IncomeInvoiceReWriteFacadeControllerBean");

    @Override
    public Map checkConfirmReWrite(Context ctx, List invoices, String orgid, Map params) throws BOSException, EASBizException {
        String periodNumber = null;
        if (params != null) {
            periodNumber = (String)params.get("periodNumber");
        }
        UserInfo authenticator = ContextUtil.getCurrentUserInfo((Context)ctx);
        String authenticatorDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        HashSet<String> billIds = new HashSet<String>();
        IncomeInvoiceInfo invoice = null;
        for (Object value : invoices) {
            if (value instanceof IncomeInvoiceInfo) {
                invoice = (IncomeInvoiceInfo)value;
                billIds.add(invoice.getId().toString());
                continue;
            }
            if (!(value instanceof LinkedTreeMap)) continue;
            LinkedTreeMap map = (LinkedTreeMap)value;
            billIds.add(map.get((Object)"id").toString());
        }
        String ids = CollectionUtil.convertSet2String(billIds, ",", true);
        StringBuffer sql = new StringBuffer();
        sql.append("update T_IM_IncomeInvoice set fauthenticateStatus = '2' ,FAuthenticatorID = '").append(authenticator.getId().toString()).append("'");
        sql.append(",FAuthenticateDate= to_date('").append(authenticatorDate).append("')");
        sql.append(",FAuthenticateWay = '0' ");
        sql.append(",FAuthenticateType = '0' ");
        if (!StringUtils.isEmpty((String)periodNumber) && !"null".equals(periodNumber)) {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select accountPeriodType.id where id = '" + orgid + "'");
            int year = Integer.parseInt(periodNumber.substring(0, 4));
            int number = Integer.parseInt(periodNumber.substring(4, 6));
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(year, number, companyOrgUnitInfo.getAccountPeriodType());
            String periodId = periodInfo.getId().toString();
            sql.append(",FBelongTaxPeriodID = '").append(periodId).append("'");
        }
        sql.append(" where fid in (").append(ids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" SELECT invoice.FCompanyId,");
        sql.append(" SUM(FTax) as totalTax,SUM(FAmount) as totalAmount ");
        sql.append(" FROM T_IM_IncomeInvoice invoice LEFT JOIN T_ORG_Company company ON invoice.FCompanyId = company.Fid");
        sql.append(" WHERE invoice.FID in (").append(ids).append(")");
        sql.append(" GROUP BY invoice.FCompanyId");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        HashMap<String, CertificateInvoiceResult> retMap = new HashMap<String, CertificateInvoiceResult>();
        CertificateInvoiceResult result = new CertificateInvoiceResult();
        result.setCompany(company);
        result.setSuccessCount(0);
        result.setTotalAmount(BigDecimal.ZERO);
        result.setTotalTax(BigDecimal.ZERO);
        try {
            if (rs.next()) {
                result.setSuccessCount(billIds.size());
                result.setTotalAmount(rs.getBigDecimal("totalAmount"));
                result.setTotalTax(rs.getBigDecimal("totalTax"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        retMap.put(orgid, result);
        return retMap;
    }

    @Override
    public Map billQueryDownload(Context ctx, Map params) throws BOSException, EASBizException {
        if (IncomeInvoicePwyHelper.isPoolDownload(params)) {
            PoolDownloadInvoiceServerService poolDownloadInvoiceServerService = new PoolDownloadInvoiceServerService();
            return poolDownloadInvoiceServerService.parseDownloadInvoice(ctx, params);
        }
        return this.parseDownloadInvoice(ctx, params);
    }

    protected Map parseDownloadInvoice(Context ctx, Map params) throws BOSException, EASBizException {
        Map ret;
        logger.info((Object)"com.kingdee.eas.tm.im.common.comm.app.IncomeInvoiceReWriteFacadeControllerBean.billQueryDownload");
        String orgid = (String)params.get("orgid");
        HashMap<String, Object> totalMap = (HashMap<String, Object>)params.get("totalMap");
        if (totalMap == null) {
            totalMap = new HashMap<String, Object>();
        }
        TaxNoSumResult sumRet = null;
        if (params.get("sumRet") instanceof TaxNoSumResult) {
            sumRet = (TaxNoSumResult)params.get("sumRet");
        } else if (params.get("sumRet") instanceof Map) {
            sumRet = (TaxNoSumResult)JSONUtils.convertJsonToObject((Context)ctx, (String)JSONUtils.convertObjectToJson((Context)ctx, (Object)((Map)params.get("sumRet"))), TaxNoSumResult.class);
        }
        Set<String> companySet = new HashSet<String>();
        if (sumRet != null) {
            companySet = sumRet.getCompanyMap().keySet();
        } else {
            companySet.add(orgid);
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        try {
            ret = IncomeInvoiceFactory.getLocalInstance(ctx).downLoadInvoice(params);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            if (totalMap.containsKey(company.getId().toString())) {
                IncomeInvoiceDownloadResult result = (IncomeInvoiceDownloadResult)totalMap.get(company.getId().toString());
                result.getErrMsgList().add(e.getMessage());
                totalMap.put(orgid, result);
                return totalMap;
            }
            IncomeInvoiceDownloadResult result = new IncomeInvoiceDownloadResult();
            result.setCompany(company);
            result.getErrMsgList().add(e.getMessage());
            totalMap.put(orgid, result);
            return totalMap;
        }
        CoreBaseCollection invoiceColl = (CoreBaseCollection)ret.get("invoiceColl");
        IncomeInvoiceInfo invoiceInfo = null;
        if (invoiceColl.size() == 0) {
            if (!totalMap.containsKey(company.getId().toString())) {
                IncomeInvoiceDownloadResult result = new IncomeInvoiceDownloadResult();
                result.setCompany(company);
                totalMap.put(orgid, result);
            }
        } else {
            for (int i = 0; i < invoiceColl.size(); ++i) {
                IncomeInvoiceDownloadResult result;
                invoiceInfo = (IncomeInvoiceInfo)invoiceColl.get(i);
                company = invoiceInfo.getCompany();
                if (totalMap.containsKey(company.getId().toString())) {
                    result = (IncomeInvoiceDownloadResult)totalMap.get(company.getId().toString());
                    result.add((IObjectValue)invoiceInfo);
                } else {
                    result = new IncomeInvoiceDownloadResult();
                    result.setCompany(company);
                    result.add((IObjectValue)invoiceInfo);
                    totalMap.put(company.getId().toString(), result);
                }
                Object statusChaged = null;
                statusChaged = invoiceInfo.get("statusChaged");
                if (statusChaged == null || !Boolean.parseBoolean(statusChaged.toString())) continue;
                if (invoiceInfo.getBizBillType() == null) {
                    totalMap.put("BizBillType_" + invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber(), "");
                    continue;
                }
                if ("4A44F49F".equals(invoiceInfo.getBizBillType().getBillBosType())) {
                    totalMap.put("BizBillType_" + invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber(), "4A44F49F");
                    continue;
                }
                if ("48DA3A71".equals(invoiceInfo.getBizBillType().getBillBosType())) {
                    totalMap.put("BizBillType_" + invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber(), "48DA3A71");
                    continue;
                }
                totalMap.put("BizBillType_" + invoiceInfo.getInvoiceCode() + "_" + invoiceInfo.getInvoiceNumber(), "");
            }
        }
        if (ret.get("invoiceDataIsNull") != null) {
            totalMap.put("invoiceDataIsNull", true);
        }
        return totalMap;
    }
}

