/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.app.util.IMServerUtil;
import com.kingdee.eas.tm.im.common.comm.IMCommException;
import com.kingdee.eas.tm.im.common.comm.LocalServiceFactory;
import com.kingdee.eas.tm.im.common.comm.LocalServiceInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.ServiceStateEnum;
import com.kingdee.eas.tm.im.common.comm.app.AbstractLocalServiceControllerBean;
import com.kingdee.eas.tm.im.common.comm.service.util.CommUtil;
import com.kingdee.eas.tm.im.common.comm.service.util.EASOpenApiUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class LocalServiceControllerBean
extends AbstractLocalServiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.LocalServiceControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkBeforeSubmit(ctx, model);
        return super._submit(ctx, model);
    }

    protected void checkBeforeSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String[] emptyFields = new String[]{"number", "name", "serviceURL", "loginUrl", "apiUrl", "dcName", "user"};
        IMServerUtil.checkEmptyFields(ctx, model, emptyFields, null);
        String[] lengthFields = new String[]{"number", "name", "serviceURL", "tenantId", "tenantName", "accountId", "loginUrl", "apiUrl", "dcName", "user", "pwd"};
        IMServerUtil.checkLengthFields(ctx, model, lengthFields);
        super._checkNumberDup(ctx, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LocalServiceInfo info = LocalServiceFactory.getLocalInstance(ctx).getLocalServiceInfo(pk);
        if (ServiceStateEnum.INITED.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_LOCALSERVICE_INITED);
        }
        EASOpenApiUtil.login(info);
        if (StringUtils.isEmpty((String)info.getAccountId())) {
            info.setAccountId(CommUtil.nextId());
        }
        info.setState(ServiceStateEnum.INITED);
        this._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        LocalServiceInfo info = LocalServiceFactory.getLocalInstance(ctx).getLocalServiceInfo(pk);
        if (ServiceStateEnum.UNINIT.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_LOCALSERVICE_UNINIT);
        }
        info.setState(ServiceStateEnum.UNINIT);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LocalServiceInfo info = LocalServiceFactory.getLocalInstance(ctx).getLocalServiceInfo(pk);
        this.beforeDelete(ctx, info);
        super._delete(ctx, pk);
    }

    private void beforeDelete(Context ctx, LocalServiceInfo info) throws BOSException, EASBizException {
        if (info.isIsScheduled()) {
            throw new IMCommException(IMCommException.PRESET_NOT_DELETE);
        }
        if (ServiceStateEnum.INITED.equals((Object)info.getState())) {
            throw new ServiceException(ServiceException.EPX_LOCALSERVICE_INITED_NOTDELETE);
        }
    }
}

