/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.InvoiceBillStatus;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.PreferentialPoliciesEnum;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.TaxClassificationCodeCollection;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingEntryInfo;
import com.kingdee.eas.tm.im.basedata.CustomerMailingFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxFactory;
import com.kingdee.eas.tm.im.basedata.CustomerTaxInfo;
import com.kingdee.eas.tm.im.basedata.ICustomerMailing;
import com.kingdee.eas.tm.im.common.comm.app.AbstractMakeInvoiceReWriteFacadeControllerBean;
import com.kingdee.eas.tm.im.common.comm.msg.result.MakeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class MakeInvoiceReWriteFacadeControllerBean
extends AbstractMakeInvoiceReWriteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.MakeInvoiceReWriteFacadeControllerBean");

    @Override
    protected Map _billQueryDownload(Context ctx, Map params) throws BOSException, EASBizException {
        JSONObject dataJson;
        String retInfo = (String)params.get("retInfo");
        String orgid = (String)params.get("orgid");
        try {
            dataJson = new JSONObject(retInfo);
        }
        catch (JSONException e) {
            throw new BOSException("JSON parse ERROR");
        }
        Map res = this.dealInvoiceData(ctx, dataJson, orgid);
        int successCount = 0;
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal priceTax = BigDecimal.ZERO;
        HashMap<String, Number> result = new HashMap<String, Number>();
        result.put("successCount", successCount);
        result.put("taxAmt", taxAmt);
        result.put("priceTax", priceTax);
        if (res.get("successCount") != null && (Integer)res.get("successCount") != 0) {
            result.put("successCount", successCount + (Integer)res.get("successCount"));
            result.put("taxAmt", taxAmt.add((BigDecimal)res.get("taxAmt")));
            result.put("priceTax", priceTax.add((BigDecimal)res.get("priceTax")));
        }
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        MakeInvoiceDownloadResult downloadResult = new MakeInvoiceDownloadResult();
        downloadResult.setCompany(company);
        downloadResult.setSuccessCount((Integer)result.get("successCount"));
        downloadResult.setTaxAmt((BigDecimal)result.get("taxAmt"));
        downloadResult.setPriceTax((BigDecimal)result.get("priceTax"));
        HashMap<String, MakeInvoiceDownloadResult> ret = new HashMap<String, MakeInvoiceDownloadResult>();
        ret.put(orgid, downloadResult);
        return ret;
    }

    private Map dealInvoiceData(Context ctx, JSONObject jsonData, String orgid) throws EASBizException, BOSException {
        HashMap<String, Object> res = new HashMap<String, Object>();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        res.put("companyName", company == null ? "" : company.getName());
        try {
            JSONArray jsonArray;
            String errcode = this.getStringValue(jsonData, "errcode");
            int successCount = 0;
            BigDecimal taxAmt = BigDecimal.ZERO;
            BigDecimal priceTax = BigDecimal.ZERO;
            if ("0000".equals(errcode) && (jsonArray = jsonData.getJSONArray("data")) != null && jsonArray.length() > 0) {
                int size = jsonArray.length();
                for (int i = 0; i < size; ++i) {
                    Map ret;
                    CustomerTaxInfo custTaxInfo;
                    JSONObject invoiceData = (JSONObject)jsonArray.get(i);
                    MakeInvoiceInfo mkBill = null;
                    String invoiceType = this.getStringValue(invoiceData, "invoiceType");
                    String fpdm = this.getStringValue(invoiceData, "invoiceCode");
                    String fphm = this.getStringValue(invoiceData, "invoiceNo");
                    if ("26".equals(invoiceType) || "27".equals(invoiceType)) {
                        fpdm = "0";
                    }
                    int status = Integer.parseInt(this.getStringValue(invoiceData, "invoiceStatus"));
                    String zfrq = this.getStringValue(invoiceData, "invalidDate");
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    mkBill = this.getMakeInvoiceInfo(ctx, fpdm, fphm);
                    boolean isUpdate = false;
                    if (mkBill != null) {
                        String pdfUrl;
                        if (status == 2 && InvoiceBillStatus.MAKED.equals((Object)mkBill.getStatus())) {
                            mkBill.setStatus(InvoiceBillStatus.DELETED);
                            mkBill.setIsDelete(true);
                            if (!IMUtils.isEmpty(zfrq)) {
                                mkBill.setDeleteDate(format.parse(zfrq));
                            }
                            isUpdate = true;
                        } else if (StringUtils.isEmpty((String)mkBill.getInvoiceUrl()) && !StringUtils.isEmpty((String)(pdfUrl = this.getStringValue(invoiceData, "pdfurl")))) {
                            mkBill.setInvoiceUrl(pdfUrl);
                            isUpdate = true;
                        }
                        if (isUpdate) {
                            MakeInvoiceEntryCollection entrys = mkBill.getEntries();
                            int entrySize = entrys.size();
                            for (int j = 0; j < entrySize; ++j) {
                                MakeInvoiceEntryInfo entryInfo = entrys.get(j);
                                taxAmt = taxAmt.add(entryInfo.getTaxAmt());
                                priceTax = priceTax.add(entryInfo.getPriceTax());
                            }
                            MakeInvoiceFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(mkBill.getId().toString()), mkBill);
                            ++successCount;
                        }
                        res.put("successCount", successCount);
                        res.put("taxAmt", taxAmt);
                        res.put("priceTax", priceTax);
                        continue;
                    }
                    mkBill = MakeInvoiceInfo.createMakeInvoiceInfo();
                    if ("1".equals(invoiceType)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICINVOICE);
                    } else if ("2".equals(invoiceType)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE);
                    } else if ("4".equals(invoiceType)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.VALUEADDEDTAXINV);
                    } else if ("26".equals(invoiceType)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE);
                    } else if ("27".equals(invoiceType)) {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE);
                    } else {
                        mkBill.setInvoiceType(PayInvoiceTypeEnum.COMMONINVOICE);
                    }
                    String sgfp = this.getStringValue(invoiceData, "sgfp");
                    if ("2".equals(sgfp)) {
                        mkBill.setIsPurchaseInvoice(true);
                    } else {
                        mkBill.setIsPurchaseInvoice(false);
                    }
                    if ("18".equals(sgfp)) {
                        mkBill.setIsVehicle(true);
                    } else {
                        mkBill.setIsVehicle(false);
                    }
                    String ghf_mc = this.getStringValue(invoiceData, "buyerName");
                    String ghf_nsrsbh = this.getStringValue(invoiceData, "buyerTaxNo");
                    String hjbhsje = this.getStringValue(invoiceData, "invoiceAmount");
                    String jshjje = this.getStringValue(invoiceData, "totalTaxAmount");
                    String kphjse = this.getStringValue(invoiceData, "totalAmount");
                    String hsbz = this.getStringValue(invoiceData, "taxFlag");
                    String qsbz = this.getStringValue(invoiceData, "qsbz");
                    String kprq = this.getStringValue(invoiceData, "invoiceDate");
                    String xhf_mc = this.getStringValue(invoiceData, "salerName");
                    String xhf_nsrsbh = this.getStringValue(invoiceData, "salerTaxNo");
                    mkBill.setCompany(company);
                    mkBill.setReceiveCompany(ghf_mc);
                    mkBill.setTaxNumber(ghf_nsrsbh);
                    mkBill.setAddress(this.getStringValue(invoiceData, "buyerAddressPhone"));
                    mkBill.setBankAccount(this.getStringValue(invoiceData, "buyerAccount"));
                    String invoiceUrl = this.getStringValue(invoiceData, "pdfurl");
                    if (IMUtils.isEmpty(invoiceUrl) && IMUtils.isEmpty(invoiceUrl = this.getStringValue(invoiceData, "kdorgpdfurl"))) {
                        invoiceUrl = this.getStringValue(invoiceData, "snapshotUrl");
                    }
                    mkBill.setInvoiceUrl(invoiceUrl);
                    mkBill.setRemark(this.getStringValue(invoiceData, "remark"));
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("taxNumber", ghf_nsrsbh != null ? ghf_nsrsbh : " ");
                    params.put("invoiceType", mkBill.getInvoiceType().getValue());
                    if (company != null) {
                        params.put("companyId", company.getId().toString());
                    }
                    if ((custTaxInfo = (CustomerTaxInfo)(ret = CustomerTaxFactory.getLocalInstance(ctx).getCustomerTaxInfo(params)).get("value")) != null && custTaxInfo.getCustomer() != null && mkBill.getTaxNumber() != null) {
                        mkBill.setCurrAcctCustomer(custTaxInfo.getCustomer());
                        HashMap<String, String> param = new HashMap<String, String>();
                        param.put("comOrgUnitId", mkBill.getCompany() == null ? null : mkBill.getCompany().getId().toString());
                        param.put("customerId", mkBill.getCurrAcctCustomer() == null ? null : mkBill.getCurrAcctCustomer().getId().toString());
                        ICustomerMailing iCustomerMailing = CustomerMailingFactory.getLocalInstance(ctx);
                        Map entryMap = iCustomerMailing.getDefaultCustomerMailInfo(param);
                        CustomerMailingEntryInfo cmEntryInfo = (CustomerMailingEntryInfo)entryMap.get("defaultEntry");
                        if (cmEntryInfo != null) {
                            mkBill.setDisInvoicer(cmEntryInfo.getContacts());
                            mkBill.setCellphone(cmEntryInfo.getTelephone());
                            mkBill.setMailNumber(cmEntryInfo.getPostalcode());
                            mkBill.setRecBillComName(cmEntryInfo.getCompanyName());
                            mkBill.setRecBillAdress(cmEntryInfo.getAddress());
                            mkBill.setRecBillEmail(cmEntryInfo.getMailbox());
                        }
                    }
                    mkBill.setCurrentAccountType(CurrentAccountType.CUSTOMER);
                    if (!IMUtils.isEmpty(kprq)) {
                        mkBill.setInvoiceDate(format.parse(kprq));
                    }
                    mkBill.setInvoiceNumber(fpdm != null ? fpdm.trim() : null);
                    mkBill.setInvoiceNo(fphm != null ? fphm.trim() : null);
                    mkBill.setDrawertxt(this.getStringValue(invoiceData, "drawer"));
                    mkBill.setPayeetxt(this.getStringValue(invoiceData, "payee"));
                    mkBill.setChecktxt(this.getStringValue(invoiceData, "reviewer"));
                    if (hjbhsje != null && !hjbhsje.isEmpty() && !"null".equals(hjbhsje)) {
                        mkBill.setNoTaxAmtTotal(new BigDecimal(hjbhsje));
                    } else {
                        mkBill.setNoTaxAmtTotal(new BigDecimal("0"));
                    }
                    mkBill.setIsContainTax("1".equals(hsbz));
                    mkBill.setIsList("1".equals(qsbz));
                    if (jshjje != null && !jshjje.isEmpty() && !"null".equals(jshjje)) {
                        mkBill.setTaxAmtTotal(new BigDecimal(jshjje));
                    } else {
                        mkBill.setTaxAmtTotal(new BigDecimal("0"));
                    }
                    if (!StringUtils.isEmpty((String)kphjse) && !kphjse.equals("null")) {
                        mkBill.setPriceTaxTotal(new BigDecimal(kphjse));
                    } else {
                        mkBill.setPriceTaxTotal(mkBill.getNoTaxAmtTotal().add(mkBill.getTaxAmtTotal()));
                    }
                    mkBill.setApplicateDate(new Date());
                    mkBill.setSrcSystem(InvoiceSrcSystem.PWYDOWNLOAD);
                    mkBill.setBlueVoiceCode(this.getStringValue(invoiceData, "originalInvoiceCode"));
                    mkBill.setBlueVoiceNum(this.getStringValue(invoiceData, "originalInvoiceNo"));
                    if (status == 0) {
                        mkBill.setStatus(InvoiceBillStatus.MAKED);
                    } else if (status == 2) {
                        mkBill.setStatus(InvoiceBillStatus.DELETED);
                        mkBill.setIsDelete(true);
                        if (!IMUtils.isEmpty(zfrq)) {
                            mkBill.setDeleteDate(format.parse(zfrq));
                        }
                    } else if (status == 3) {
                        mkBill.setStatus(InvoiceBillStatus.MAKED);
                        mkBill.setIsRedVoice(true);
                    }
                    boolean isRedVoice = this.getBooleanValue(this.getStringValue(invoiceData, "type"));
                    mkBill.setIsRedVoice(isRedVoice);
                    JSONArray items = invoiceData.getJSONArray("items");
                    boolean isContainTax = mkBill.isIsContainTax();
                    for (int m = 0; m < items.length(); ++m) {
                        JSONObject item = items.getJSONObject(m);
                        MakeInvoiceEntryInfo entryInfo = MakeInvoiceEntryInfo.createMakeInvoiceEntryInfo(mkBill);
                        this.setMakeInvoiceEntryInfo(ctx, isContainTax, item, mkBill, entryInfo);
                        if (entryInfo.getBillRowType() == RowType.DISCOUNT_ROW && m > 0) {
                            entryInfo.setSourceBillEntryId(mkBill.getEntries().get(m - 1).getId().toString());
                        }
                        taxAmt = taxAmt.add(entryInfo.getTaxAmt());
                        priceTax = priceTax.add(entryInfo.getPriceTax());
                        mkBill.getEntries().add(entryInfo);
                    }
                    MakeInvoiceFactory.getLocalInstance(ctx).addnew(mkBill);
                    ++successCount;
                }
                res.put("successCount", successCount);
                res.put("taxAmt", taxAmt);
                res.put("priceTax", priceTax);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return res;
    }

    private void setMakeInvoiceEntryInfo(Context ctx, boolean isContainTax, JSONObject item, MakeInvoiceInfo mkBill, MakeInvoiceEntryInfo entryInfo) throws BOSException, EASBizException {
        String preferentialPolicy;
        String ggxh = this.getStringValue(item, "specModel");
        String se = this.getStringValue(item, "taxAmount");
        String sl = this.getStringValue(item, "taxRate");
        String xmdj = this.getStringValue(item, "unitPrice");
        if (xmdj == null) {
            xmdj = "0";
        }
        String xmdw = this.getStringValue(item, "unit");
        String xmje = this.getStringValue(item, "detailAmount");
        String xmmc = this.getStringValue(item, "goodsName");
        String xmsl = this.getStringValue(item, "num");
        String kce = this.getStringValue(item, "deduction");
        if (xmsl == null) {
            xmsl = "0";
        }
        String ssflbm = this.getStringValue(item, "goodsCode");
        entryInfo.setTaxClassificationCode(ssflbm);
        if (ssflbm != null && ssflbm.length() == 19) {
            EntityViewInfo taxClassView = new EntityViewInfo();
            FilterInfo taxClassFilter = new FilterInfo();
            taxClassFilter.getFilterItems().add(new FilterItemInfo("mergeCode", (Object)ssflbm, CompareType.EQUALS));
            taxClassView.setFilter(taxClassFilter);
            TaxClassificationCodeCollection taxClassColl = TaxClassificationCodeFactory.getLocalInstance(ctx).getTaxClassificationCodeCollection(taxClassView);
            if (taxClassColl != null && taxClassColl.size() > 0) {
                TaxClassificationCodeInfo taxClassInfo = taxClassColl.get(0);
                entryInfo.setTaxClassName(taxClassInfo.getName());
            }
        }
        if (!StringUtils.isEmpty((String)xmmc)) {
            String[] xmmcStr = xmmc.split("\\*");
            if (xmmcStr.length > 1) {
                entryInfo.setTaxClassName(xmmcStr[1]);
                entryInfo.setProduceName(xmmc.substring(xmmc.indexOf("*", 1) + 1));
            } else {
                entryInfo.setProduceName(xmmc);
            }
        }
        ggxh = IMUtils.cutStr(ggxh, 40);
        entryInfo.setSpecs(ggxh);
        if (se != null && !se.isEmpty() && !"null".equals(se)) {
            entryInfo.setTaxAmt(new BigDecimal(se));
        } else {
            entryInfo.setTaxAmt(new BigDecimal("0"));
        }
        if (sl != null && !sl.isEmpty() && !"null".equals(sl)) {
            entryInfo.setTaxRate(new BigDecimal(sl));
        } else {
            entryInfo.setTaxRate(new BigDecimal("0"));
        }
        EntityViewInfo unitView = new EntityViewInfo();
        FilterInfo unitFilter = new FilterInfo();
        unitFilter.getFilterItems().add(new FilterItemInfo("name", (Object)xmdw));
        unitView.setFilter(unitFilter);
        MeasureUnitCollection collection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitView);
        MeasureUnitInfo unitInfo = null;
        if (collection != null && collection.size() > 0) {
            unitInfo = collection.get(0);
        }
        entryInfo.setMeasureUnit(unitInfo);
        entryInfo.setMakeInvoiceUnit(xmdw);
        BigDecimal downPrice = BigDecimal.ZERO;
        if (xmdj != null && !xmdj.isEmpty() && !"null".equals(xmdj)) {
            downPrice = new BigDecimal(xmdj);
        }
        if (isContainTax) {
            entryInfo.setPrice(downPrice);
            if (entryInfo.getTaxRate() != null) {
                entryInfo.setNoTaxPrice(downPrice.divide(entryInfo.getTaxRate().add(BigDecimal.ONE), 10, 4));
            }
        } else {
            entryInfo.setNoTaxPrice(downPrice);
            if (entryInfo.getTaxRate() != null) {
                entryInfo.setPrice(downPrice.multiply(entryInfo.getTaxRate().add(BigDecimal.ONE)).setScale(10, 4));
            }
        }
        if (xmje != null && !xmje.isEmpty() && !"null".equals(xmje)) {
            if (isContainTax) {
                entryInfo.setPriceTax(new BigDecimal(xmje));
                entryInfo.setNoTaxAmt(entryInfo.getPriceTax().subtract(entryInfo.getTaxAmt()));
            } else {
                entryInfo.setNoTaxAmt(new BigDecimal(xmje));
                entryInfo.setPriceTax(entryInfo.getTaxAmt().add(entryInfo.getNoTaxAmt()));
            }
        } else {
            entryInfo.setNoTaxAmt(new BigDecimal("0"));
            entryInfo.setPriceTax(entryInfo.getTaxAmt().add(entryInfo.getNoTaxAmt()));
        }
        if (xmsl != null && !xmsl.isEmpty() && !"null".equals(xmsl)) {
            entryInfo.setQuantity(new BigDecimal(xmsl));
        }
        entryInfo.setDiscountAmt(BigDecimal.ZERO);
        entryInfo.setDiscountRate(BigDecimal.ZERO);
        entryInfo.setBillRowType(RowType.NORMAL_ROW);
        String rowType = this.getStringValue(item, "discountType");
        BigDecimal deductAmt = null;
        if (!StringUtils.isEmpty((String)kce)) {
            deductAmt = new BigDecimal(kce);
        }
        if (("0".equals(rowType) || "2".equals(rowType)) && deductAmt != null && BigDecimal.ZERO.compareTo(deductAmt) != 0) {
            entryInfo.setDeductAmt(deductAmt);
            mkBill.setIsDiffTax(true);
        }
        if ("1".equals(rowType)) {
            entryInfo.setBillRowType(RowType.DISCOUNT_ROW);
        }
        if ("2".equals(rowType)) {
            entryInfo.setBillRowType(RowType.DISCOUNTED_ROW);
        }
        if ("1".equals(preferentialPolicy = this.getStringValue(item, "preferentialPolicy"))) {
            entryInfo.setHasPreferential(true);
            String vatException = this.getStringValue(item, "vatException");
            PreferentialPoliciesEnum preferentialPoliciesEnum = (PreferentialPoliciesEnum)IMUtils.getEnumValue(PreferentialPoliciesEnum.class.getName(), vatException);
            entryInfo.setPreferentialPolicies(preferentialPoliciesEnum);
        }
    }

    protected MakeInvoiceInfo getMakeInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) {
        MakeInvoiceInfo invoiceInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNo", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        MakeInvoiceCollection coll = null;
        try {
            coll = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceCollection(view);
            if (coll != null && coll.size() > 0) {
                invoiceInfo = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return invoiceInfo;
    }

    @Override
    protected Map _billSingleQueryDownload(Context ctx, Map params) throws BOSException, EASBizException {
        Map res;
        JSONObject dataJson;
        String retInfo = (String)params.get("retInfo");
        String orgid = (String)params.get("orgid");
        try {
            dataJson = new JSONObject(retInfo);
        }
        catch (JSONException e) {
            throw new BOSException("JSON parse ERROR");
        }
        Map result = res = this.dealSingleInvoiceData(ctx, dataJson, orgid);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        MakeInvoiceDownloadResult downloadResult = new MakeInvoiceDownloadResult();
        downloadResult.setCompany(company);
        downloadResult.setSuccessCount((Integer)result.get("successCount"));
        downloadResult.setTaxAmt((BigDecimal)result.get("taxAmt"));
        downloadResult.setPriceTax((BigDecimal)result.get("priceTax"));
        HashMap<String, MakeInvoiceDownloadResult> ret = new HashMap<String, MakeInvoiceDownloadResult>();
        ret.put(orgid, downloadResult);
        return ret;
    }

    protected Map dealSingleInvoiceData(Context ctx, JSONObject jsonData, String orgid) throws EASBizException, BOSException {
        try {
            JSONArray array = new JSONArray();
            JSONObject invoiceData = jsonData.getJSONObject("data");
            array.put((Object)invoiceData);
            String errcode = this.getStringValue(jsonData, "errcode");
            JSONObject dataJson = new JSONObject();
            dataJson.put("data", (Object)array);
            dataJson.put("errcode", (Object)errcode);
            return this.dealInvoiceData(ctx, dataJson, orgid);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

