/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.common.comm.IMCommException;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.SendModeEnum;
import com.kingdee.eas.tm.im.common.comm.TaxMsgSettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogCollection;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.app.AbstractTaxTransLogControllerBean;
import com.kingdee.eas.tm.im.common.comm.log.AsyncExecuteParams;
import com.kingdee.eas.tm.im.common.comm.log.AsyncExecuteThread;
import com.kingdee.eas.tm.im.common.comm.service.ICallBackService;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.ws.ResultInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxTransLogControllerBean
extends AbstractTaxTransLogControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.app.TaxTransLogControllerBean");

    @Override
    protected void _addLog2Queue(Context ctx, IObjectValue logInfo) throws BOSException, EASBizException {
        AsyncExecuteParams executeParams = new AsyncExecuteParams(ctx, "log", logInfo);
        AsyncExecuteThread.putData(executeParams);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        TaxTransLogInfo logInfo = (TaxTransLogInfo)model;
        if (logInfo.getCreateTime() == null) {
            logInfo.setCreateTime(ts);
        }
        if (logInfo.getCreator() == null) {
            logInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        logInfo.setUpdateTime(ts);
        logInfo.setModifer(ContextUtil.getCurrentUserInfo((Context)ctx));
        if (logInfo.getCU() == null) {
            logInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        return super._save(ctx, (IObjectValue)logInfo);
    }

    @Override
    protected Map _buildLogParam(Context ctx, Map params) throws BOSException, EASBizException {
        List billIds = (List)params.get("billIds");
        int actionType = (Integer)params.get("actionType");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(billIds), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TaxTransLogInfo.getSelector());
        TaxTransLogCollection logList = TaxTransLogFactory.getLocalInstance(ctx).getTaxTransLogCollection(view);
        TaxTransLogInfo logInfo = null;
        ArrayList<String> msgTypes = new ArrayList<String>();
        for (int i = 0; i < logList.size(); ++i) {
            msgTypes.add(logList.get(i).getLogType().getValue());
        }
        Map<String, TaxMsgSettingInfo> msgSettingInfoMap = PwyServiceHelper.getMsgSettingMap(ctx, msgTypes);
        ArrayList list = new ArrayList();
        HashMap<String, Object> retMap = null;
        IPwyService pwyService = null;
        TaxMsgSettingInfo settingInfo = null;
        for (int i = 0; i < logList.size(); ++i) {
            logInfo = logList.get(i);
            settingInfo = msgSettingInfoMap.get(logInfo.getLogType().getValue());
            this.checkBeforeAction(ctx, logInfo, settingInfo, actionType);
            try {
                retMap = new HashMap<String, Object>();
                if (this.isServerSend(ctx, settingInfo)) {
                    retMap.put("logId", logInfo.getId().toString());
                    retMap.put("sendMode", (Object)SendModeEnum.SERVER);
                } else {
                    pwyService = PwyServiceHelper.getPwyService(ctx, logInfo, settingInfo);
                    pwyService.buildPwyParam();
                    retMap = new HashMap();
                    retMap.put("invokeParam", pwyService.getInvokeParam());
                    retMap.put("sendMode", (Object)SendModeEnum.CLIENT);
                }
            }
            catch (Exception e) {
                retMap = new HashMap();
                retMap.put("error", "exception");
                retMap.put("exception", e.getMessage());
            }
            list.add(retMap);
        }
        HashMap returnMap = new HashMap();
        returnMap.put("list", list);
        return returnMap;
    }

    private boolean isServerSend(Context ctx, TaxMsgSettingInfo settingInfo) {
        String serviceType = settingInfo.getMsgType().getValue();
        return 2 == settingInfo.getSendMode().getValue() || serviceType.startsWith("sim");
    }

    @Override
    protected List _doActions(Context ctx, ArrayList logIds, int actionType) throws BOSException, EASBizException {
        ArrayList<String> errorMsg = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(logIds), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TaxTransLogInfo.getSelector());
        TaxTransLogCollection logList = TaxTransLogFactory.getLocalInstance(ctx).getTaxTransLogCollection(view);
        TaxTransLogInfo logInfo = null;
        ArrayList<String> msgTypes = new ArrayList<String>();
        for (int i = 0; i < logList.size(); ++i) {
            msgTypes.add(logList.get(i).getLogType().getValue());
        }
        Map<String, TaxMsgSettingInfo> msgSettingInfoMap = PwyServiceHelper.getMsgSettingMap(ctx, msgTypes);
        ArrayList list = new ArrayList();
        TaxMsgSettingInfo settingInfo = null;
        for (int i = 0; i < logList.size(); ++i) {
            logInfo = logList.get(i);
            settingInfo = msgSettingInfoMap.get(logInfo.getLogType().getValue());
            try {
                TaxTransLogFactory.getLocalInstance(ctx).doAction((IObjectValue)logInfo, (IObjectValue)settingInfo, actionType);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                errorMsg.add(e.getMessage());
            }
        }
        return errorMsg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void _doAction(Context ctx, IObjectValue logObj, IObjectValue settingObj, int actionType) throws BOSException, EASBizException {
        TaxTransLogInfo logInfo = (TaxTransLogInfo)logObj;
        TaxMsgSettingInfo settingInfo = (TaxMsgSettingInfo)settingObj;
        if (StringUtils.isEmpty((String)settingInfo.getInterfaceImpClass())) {
            return;
        }
        try {
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (this.isCallBackService(settingInfo)) {
                if (0 != actionType) throw new IMCommException(IMCommException.EXP_CALLBACK_ONLY_SUPPORT_RETRY);
                IObjectPK logPk = LogUtils.beginLog(ctx, "retry", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(logInfo.getId().toString()), logInfo.getNumber(), "im_taxTransLog_retry", cuInfo.getId().toString());
                Class<?> interfaceImpClass = Class.forName(settingInfo.getInterfaceImpClass());
                Constructor<?> constructor = interfaceImpClass.getDeclaredConstructor(Context.class, TaxMsgSettingInfo.class, TaxTransLogInfo.class);
                ICallBackService callBackService = (ICallBackService)constructor.newInstance(ctx, settingInfo, logInfo);
                ResultInfo resultInfo = callBackService.callback(logInfo.getSendMsg());
                if (!resultInfo.isSuccess()) {
                    String errorMsg = IMUtils.buildErrorMsg(resultInfo.getErrorMsg());
                    throw new IMException(IMException.ERRORMSG, new Object[]{errorMsg});
                }
                LogUtils.afterLog(ctx, logPk);
                return;
            } else {
                IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, logInfo, settingInfo);
                if (0 == actionType) {
                    IObjectPK logPk = LogUtils.beginLog(ctx, "retry", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(logInfo.getId().toString()), logInfo.getNumber(), "im_taxTransLog_retry", cuInfo.getId().toString());
                    pwyService.invoke();
                    if (!pwyService.isSuccess() && !pwyService.getInvokeParam().isPartSuccess()) {
                        throw new IMException(IMException.ERRORMSG, new Object[]{pwyService.getInvokeParam().getDescription()});
                    }
                    LogUtils.afterLog(ctx, logPk);
                    return;
                } else if (1 == actionType) {
                    IObjectPK logPk = LogUtils.beginLog(ctx, "confirmSuccess", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(logInfo.getId().toString()), logInfo.getNumber(), "im_taxTransLog_confirmSuccess", cuInfo.getId().toString());
                    pwyService.getInvokeParam().getPwyLog().setLogStatus(LogStatusEnum.SUCCESS);
                    pwyService.updatePwyLog();
                    LogUtils.afterLog(ctx, logPk);
                    return;
                } else if (2 == actionType) {
                    IObjectPK logPk = LogUtils.beginLog(ctx, "confirmFailure", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(logInfo.getId().toString()), logInfo.getNumber(), "im_taxTransLog_confirmFailure", cuInfo.getId().toString());
                    pwyService.getInvokeParam().getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
                    pwyService.updatePwyLog();
                    LogUtils.afterLog(ctx, logPk);
                    return;
                } else {
                    if (3 != actionType) return;
                    IObjectPK logPk = LogUtils.beginLog(null, "markComplete", BOSObjectType.create((String)"34DD32C1"), (IObjectPK)new ObjectUuidPK(logInfo.getId().toString()), logInfo.getNumber(), "im_taxTransLog_markComplete", cuInfo.getId().toString());
                    pwyService.invokeAfter();
                    LogUtils.afterLog(ctx, logPk);
                }
            }
            return;
        }
        catch (Exception e) {
            if (!(e instanceof EASBizException)) throw new BOSException((Throwable)e);
            throw (EASBizException)((Object)e);
        }
    }

    private boolean isCallBackService(TaxMsgSettingInfo settingInfo) throws BOSException {
        try {
            Class<?> interfaceImpClass = Class.forName(settingInfo.getInterfaceImpClass());
            if (ICallBackService.class.isAssignableFrom(interfaceImpClass)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private void checkBeforeAction(Context ctx, TaxTransLogInfo logInfo, TaxMsgSettingInfo msgSettingInfo, int actionType) throws BOSException, EASBizException {
        if (!msgSettingInfo.isIsManualSend() && 0 == actionType) {
            throw new IMException(IMException.ERRORMSG, new Object[]{logInfo.getLogType().getAlias() + IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "MsgSendERROR", ctx.getLocale())});
        }
        if (this.isCallBackService(msgSettingInfo)) {
            if (0 != actionType) {
                throw new IMCommException(IMCommException.EXP_CALLBACK_ONLY_SUPPORT_RETRY);
            }
        } else if (0 == actionType) {
            if (!LogStatusEnum.FAILURE.equals((Object)logInfo.getLogStatus())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "RETRYERROR", ctx.getLocale())});
            }
        } else if (1 == actionType) {
            if (!LogStatusEnum.TO_BE_CONFIRM.equals((Object)logInfo.getLogStatus())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "CONFIRMSUCCESSERROR", ctx.getLocale())});
            }
        } else if (2 == actionType) {
            if (!LogStatusEnum.TO_BE_CONFIRM.equals((Object)logInfo.getLogStatus())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "CONFIRMFAILUREERROR", ctx.getLocale())});
            }
        } else if (3 == actionType && !LogStatusEnum.SUCCESS.equals((Object)logInfo.getLogStatus())) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.common.comm.IMCommResource", "MARKCOMPLETEERROR", ctx.getLocale())});
        }
    }

    @Override
    protected void _checkFunctionPermission(Context ctx, ArrayList id, String permItemName) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(id), CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TaxTransLogInfo.getSelector());
        TaxTransLogCollection List2 = TaxTransLogFactory.getLocalInstance(ctx).getTaxTransLogCollection(view);
        TaxTransLogInfo logInfo = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        for (int i = 0; i < List2.size(); ++i) {
            logInfo = List2.get(i);
            if (logInfo.getCU() == null) continue;
            ObjectUuidPK cuPk = new ObjectUuidPK(BOSUuid.read((String)logInfo.getCU().getId().toString()));
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)cuPk, permItemName);
        }
    }

    protected TaxTransLogInfo _createNewData(Context ctx) throws BOSException, EASBizException {
        TaxTransLogInfo pwyLog = new TaxTransLogInfo();
        pwyLog.setId(BOSUuid.create((String)"34DD32C1"));
        pwyLog.setNumber(PwyServiceHelper.getNewNumberString());
        pwyLog.setLogStatus(LogStatusEnum.TO_BE_CONFIRM);
        return pwyLog;
    }
}

