/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.tm.common.invoicePool.CheckStateEnum;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeStatusEnum;
import com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractParser;
import com.kingdee.util.StringUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractIncomeInvoiceParser
extends AbstractParser {
    @Deprecated
    protected IncomeInvoiceInfo getIncomeInvoiceInfo(Context ctx, String invoiceCode, String invoiceNumber) throws BOSException {
        IncomeInvoiceInfo invoiceInfo = new IncomeInvoiceInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNumber, CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("checkAbs.*"));
        sic.add(new SelectorItemInfo("nonCompliantInvoice.*"));
        sic.add(new SelectorItemInfo("nonCompliantInvoice.entry.*"));
        sic.add(new SelectorItemInfo("nonCompliantInvoice.entry.nonCompliantType.*"));
        view.setSelector(sic);
        IncomeInvoiceCollection coll = null;
        coll = IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
        if (coll != null && coll.size() > 0) {
            invoiceInfo = coll.get(0);
        }
        return invoiceInfo;
    }

    protected IncomeStatusEnum getIncomeStatusEnum(String value) {
        if ("0".equals(value)) {
            return IncomeStatusEnum.NORMAL;
        }
        if ("1".equals(value)) {
            return IncomeStatusEnum.LOSECONTROL;
        }
        if ("2".equals(value)) {
            return IncomeStatusEnum.CANCEL;
        }
        if ("3".equals(value)) {
            return IncomeStatusEnum.CREDIT;
        }
        if ("4".equals(value)) {
            return IncomeStatusEnum.UNUSUAL;
        }
        if ("5".equals(value)) {
            return IncomeStatusEnum.UNNORMAL;
        }
        if ("6".equals(value)) {
            return IncomeStatusEnum.UNCONFIRMRED;
        }
        if ("7".equals(value)) {
            return IncomeStatusEnum.PARTLYRED;
        }
        if ("8".equals(value)) {
            return IncomeStatusEnum.FULLRED;
        }
        return IncomeStatusEnum.NORMAL;
    }

    protected CheckStateEnum getCheckStateEnum(String value) {
        if ("0".equals(value)) {
            return CheckStateEnum.Unchecked;
        }
        if ("1".equals(value)) {
            return CheckStateEnum.Checked;
        }
        return CheckStateEnum.Checked;
    }

    public PayInvoiceTypeEnum getInvoiceType(String value) {
        if ("1".equals(value)) {
            return PayInvoiceTypeEnum.ELECTRONICINVOICE;
        }
        if ("2".equals(value)) {
            return PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        }
        if ("3".equals(value)) {
            return PayInvoiceTypeEnum.COMMONINVOICE;
        }
        if ("4".equals(value)) {
            return PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        }
        if ("5".equals(value)) {
            return PayInvoiceTypeEnum.COMMONINVOICE;
        }
        return null;
    }

    protected boolean filterInvoice(IncomeInvoiceInfo invoice, Map params) {
        Map filterMap = this.getFilterMap(params);
        if (filterMap == null) {
            return false;
        }
        return this.filterInvoiceStatus(invoice, filterMap) || this.filterInvoiceType(invoice, filterMap);
    }

    protected Map getFilterMap(Map params) {
        Map pwyData = (Map)params.get("pwyData");
        if (pwyData == null) {
            return null;
        }
        HashMap filterMap = new HashMap();
        filterMap.put("invoiceNumber", pwyData.get("invoiceNumber"));
        filterMap.put("invoiceCode", pwyData.get("invoiceCode"));
        filterMap.put("invoiceNo", pwyData.get("invoiceNo"));
        filterMap.put("status", params.get("status"));
        filterMap.put("invoiceTypes", pwyData.get("invoiceTypes"));
        return filterMap;
    }

    protected boolean filterInvoiceStatus(IncomeInvoiceInfo invoice, Map filterMap) {
        String invoiceNumber = (String)filterMap.get("invoiceNumber");
        if (!StringUtils.isEmpty((String)((String)filterMap.get("invoiceCode")))) {
            invoiceNumber = (String)filterMap.get("invoiceCode");
        }
        String invoiceNo = (String)filterMap.get("invoiceNo");
        String status = (String)filterMap.get("status");
        return !StringUtils.isEmpty((String)status) && StringUtils.isEmpty((String)invoiceNumber) && StringUtils.isEmpty((String)invoiceNo) && !status.contains(invoice.getStatus().getValue());
    }

    protected boolean filterInvoiceType(IncomeInvoiceInfo invoice, Map filterMap) {
        String invoiceNumber = (String)filterMap.get("invoiceNumber");
        if (!StringUtils.isEmpty((String)((String)filterMap.get("invoiceCode")))) {
            invoiceNumber = (String)filterMap.get("invoiceCode");
        }
        String invoiceNo = (String)filterMap.get("invoiceNo");
        String invoiceTypes = (String)filterMap.get("invoiceTypes");
        if (invoice.getTmInvoiceType() != null && !StringUtils.isEmpty((String)invoiceTypes) && StringUtils.isEmpty((String)invoiceNumber) && StringUtils.isEmpty((String)invoiceNo)) {
            String invoiceType = invoice.getTmInvoiceType().getValue();
            List<String> invoiceTypeList = Arrays.asList(invoiceTypes.split(","));
            if (!invoiceTypeList.contains(invoiceType)) {
                return true;
            }
        }
        return false;
    }
}

