/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.tm.im.common.comm.msg.parser.IParser;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class AbstractParser
implements IParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.parser.AbstractParser");

    protected JSONObject getJSONObject(JSONObject data, String key) {
        JSONObject value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONObject(key);
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected JSONArray getJSONArray(JSONObject data, String key) {
        JSONArray value = null;
        if (data.has(key)) {
            try {
                value = data.getJSONArray(key);
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected String getStringValue(JSONObject data, String key) {
        String value = null;
        if (data.has(key)) {
            try {
                String valueStr = data.getString(key);
                if (valueStr != null && valueStr.length() > 0 && !"null".equals(valueStr)) {
                    value = valueStr;
                }
            }
            catch (JSONException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected BigDecimal getBigDecimalValue(String valueStr) {
        BigDecimal value = new BigDecimal(0);
        if (valueStr != null && valueStr.length() > 0) {
            value = new BigDecimal(valueStr);
        }
        return value;
    }

    protected Date getDateValue(String valueStr) {
        Date value = null;
        if (valueStr != null && valueStr.length() > 0) {
            try {
                value = new SimpleDateFormat("yyyy-MM-dd").parse(valueStr);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected Timestamp getTimeValue(String tsStr) {
        Timestamp time = null;
        if (tsStr != null && tsStr.length() > 0) {
            try {
                time = Timestamp.valueOf(tsStr);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return time;
    }

    public Timestamp getTimestamp(String time) {
        try {
            return Timestamp.valueOf(time);
        }
        catch (Exception e) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                return new Timestamp(format.parse(time).getTime());
            }
            catch (Exception e2) {
                logger.error((Object)e2.getMessage(), (Throwable)e2);
                return null;
            }
        }
    }

    protected boolean getBooleanValue(String valueStr) {
        boolean value = false;
        if ("1".equals(valueStr)) {
            value = true;
        }
        return value;
    }

    protected String getSuccessCode() {
        return "0000";
    }
}

