/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.msg.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.msg.parser.MakeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardInfo;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardVolumnInfo;
import com.kingdee.eas.tm.im.inv.OutputInvoiceType;
import com.kingdee.eas.tm.im.util.IMUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxCardParser
extends MakeInvoiceParser {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.msg.parser.TaxCardParser");

    @Override
    public Object parse(Context ctx, Map param) throws BOSException, EASBizException, JSONException {
        ArrayList<TaxCardVolumnInfo> result = new ArrayList<TaxCardVolumnInfo>();
        TaxCardInfo taxCardInfo = new TaxCardInfo();
        taxCardInfo.setId(BOSUuid.create((String)"88888888").toString());
        TaxCardVolumnInfo taxCardVolumnInfo = null;
        String retInfo = (String)param.get("retInfo");
        JSONObject dataJson = new JSONObject(retInfo);
        String errcode = dataJson.getString("errcode");
        if (this.getSuccessCode().equals(errcode)) {
            JSONArray elec_special_volumn;
            JSONArray elec_volumn;
            JSONArray special_papery_volumn;
            JSONArray roll_volumn;
            JSONObject sjd = dataJson.getJSONObject("sjd");
            String[] str1 = sjd.getString("jsph").split("-");
            String jsph = str1.length > 1 ? str1[1] : str1[0];
            String jspjh = sjd.getString("jspjh");
            taxCardInfo.setJsph(jsph);
            taxCardInfo.setJspjh(jspjh);
            taxCardInfo.setPtfpdm(sjd.getString("ptfpdm"));
            taxCardInfo.setPtfphm(sjd.getString("ptfphm"));
            taxCardInfo.setJsfpdm(sjd.getString("jsfpdm"));
            taxCardInfo.setJsfphm(sjd.getString("jsfphm"));
            JSONArray normal_papery_volumn = sjd.getJSONArray("normal_papery_volumn");
            if (normal_papery_volumn != null && normal_papery_volumn.length() > 0) {
                for (int i = 0; i < normal_papery_volumn.length(); ++i) {
                    taxCardVolumnInfo = new TaxCardVolumnInfo();
                    JSONObject typeInfo = (JSONObject)normal_papery_volumn.get(i);
                    taxCardVolumnInfo.setInvoiceType(OutputInvoiceType.OUTPUT_COMMON);
                    taxCardVolumnInfo.setJsph(jsph);
                    taxCardVolumnInfo.setJspjh(jspjh);
                    taxCardVolumnInfo.setParent(taxCardInfo);
                    this.parseJson(taxCardVolumnInfo, typeInfo);
                    result.add(taxCardVolumnInfo);
                }
            }
            if ((roll_volumn = sjd.getJSONArray("roll_volumn")) != null && roll_volumn.length() > 0) {
                for (int i = 0; i < roll_volumn.length(); ++i) {
                    taxCardVolumnInfo = new TaxCardVolumnInfo();
                    JSONObject typeInfo = (JSONObject)roll_volumn.get(i);
                    taxCardVolumnInfo.setInvoiceType(OutputInvoiceType.OUTPUT_COIL);
                    taxCardVolumnInfo.setJsph(jsph);
                    taxCardVolumnInfo.setJspjh(jspjh);
                    taxCardVolumnInfo.setParent(taxCardInfo);
                    this.parseJson(taxCardVolumnInfo, typeInfo);
                    result.add(taxCardVolumnInfo);
                }
            }
            if ((special_papery_volumn = sjd.getJSONArray("special_papery_volumn")) != null && special_papery_volumn.length() > 0) {
                for (int i = 0; i < special_papery_volumn.length(); ++i) {
                    taxCardVolumnInfo = new TaxCardVolumnInfo();
                    JSONObject typeInfo = (JSONObject)special_papery_volumn.get(i);
                    taxCardVolumnInfo.setInvoiceType(OutputInvoiceType.OUTPUT_SPECIAL);
                    taxCardVolumnInfo.setJsph(jsph);
                    taxCardVolumnInfo.setJspjh(jspjh);
                    taxCardVolumnInfo.setParent(taxCardInfo);
                    this.parseJson(taxCardVolumnInfo, typeInfo);
                    result.add(taxCardVolumnInfo);
                }
            }
            if ((elec_volumn = sjd.getJSONArray("elec_volumn")) != null && elec_volumn.length() > 0) {
                for (int i = 0; i < elec_volumn.length(); ++i) {
                    taxCardVolumnInfo = new TaxCardVolumnInfo();
                    JSONObject typeInfo = (JSONObject)elec_volumn.get(i);
                    taxCardVolumnInfo.setInvoiceType(OutputInvoiceType.OUPPUT_ELECTRONIC);
                    taxCardVolumnInfo.setJsph(jsph);
                    taxCardVolumnInfo.setJspjh(jspjh);
                    taxCardVolumnInfo.setParent(taxCardInfo);
                    this.parseJson(taxCardVolumnInfo, typeInfo);
                    result.add(taxCardVolumnInfo);
                }
            }
            if ((elec_special_volumn = sjd.getJSONArray("elec_special_volumn")) != null && elec_special_volumn.length() > 0) {
                for (int i = 0; i < elec_special_volumn.length(); ++i) {
                    taxCardVolumnInfo = new TaxCardVolumnInfo();
                    JSONObject typeInfo = (JSONObject)elec_special_volumn.get(i);
                    taxCardVolumnInfo.setInvoiceType(OutputInvoiceType.OUTPUT_ELECTRONICSPECIAL);
                    taxCardVolumnInfo.setJsph(jsph);
                    taxCardVolumnInfo.setJspjh(jspjh);
                    taxCardVolumnInfo.setParent(taxCardInfo);
                    this.parseJson(taxCardVolumnInfo, typeInfo);
                    result.add(taxCardVolumnInfo);
                }
            }
        }
        taxCardInfo.setVolumns(result);
        taxCardInfo.init();
        return taxCardInfo;
    }

    protected void parseJson(TaxCardVolumnInfo taxCardVolumnInfo, JSONObject typeInfo) throws JSONException {
        taxCardVolumnInfo.setId(BOSUuid.create((String)"88888888").toString());
        NumberFormat numberFormat = IMUtils.getInvoiceNumberFmt();
        taxCardVolumnInfo.setInvoice_code(typeInfo.getString("invoice_code"));
        String firstNumber = typeInfo.getString("invoice_num");
        int first = Integer.valueOf(firstNumber);
        int remainderQty = typeInfo.getInt("remainder");
        int qty = typeInfo.getInt("amount");
        int last = first + qty - 1;
        int next = last - remainderQty + 1;
        taxCardVolumnInfo.setAmount(qty);
        taxCardVolumnInfo.setInvoice_num(numberFormat.format(first));
        taxCardVolumnInfo.setNext_invoice_num(numberFormat.format(next));
        taxCardVolumnInfo.setRemainder(remainderQty);
        taxCardVolumnInfo.setPurchase_person(typeInfo.getString("purchase_person"));
        taxCardVolumnInfo.setVol_no(typeInfo.getString("vol_no"));
        taxCardVolumnInfo.setLast_invoice_num(numberFormat.format(last));
    }

    @Override
    protected String getSuccessCode() {
        return "0";
    }
}

