/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.ierp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.basedata.InvoiceScanFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.ierp.FpyBaseService;
import com.kingdee.eas.tm.im.common.comm.service.util.FpyServiceHelper;
import java.util.HashMap;
import java.util.Map;

public class FpyInitCloudService
extends FpyBaseService {
    public FpyInitCloudService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public FpyInitCloudService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        return FpyServiceHelper.getInitCloudData(this.getInvokeParam().getRemoteServiceInfo());
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void resolveSuccess() {
        try {
            JSONObject jsonObject = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONObject dataJson = jsonObject.getJSONObject("data");
            String publicKey = dataJson.getString("publicKey");
            this.getInvokeParam().getInvokeActionMap().put("publicKey", publicKey);
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serviceNumber", this.getInvokeParam().getRemoteServiceInfo().getNumber());
        param.put("publicKey", (String)this.getInvokeParam().getInvokeActionMap().get("publicKey"));
        InvoiceScanFacadeFactory.getLocalInstance(this.getCtx()).initCloudReWrite(param);
    }

    @Override
    public String getPwyCzlx() {
        return "fpy001";
    }

    @Override
    protected void verify() throws EASBizException, BOSException {
    }
}

