/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.ierp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.basedata.InvoiceScanFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.ierp.FpyBaseService;
import com.kingdee.eas.tm.im.common.comm.service.util.FpyServiceHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class FpySyncQrKeyService
extends FpyBaseService {
    public FpySyncQrKeyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public FpySyncQrKeyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        Map params = this.getInvokeParam().getParams();
        String strTaxNos = (String)params.get("taxNos");
        HashSet<String> taxNos = new HashSet<String>(Arrays.asList(strTaxNos.split(";")));
        return FpyServiceHelper.getSyncQrKeyData(this.getInvokeParam().getRemoteServiceInfo(), taxNos);
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void resolveSuccess() {
        try {
            JSONObject jsonObject = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONArray dataJsonArray = jsonObject.getJSONArray("data");
            JSONObject dataJson = null;
            ArrayList<String> qrList = new ArrayList<String>();
            int size = dataJsonArray.length();
            for (int i = 0; i < size; ++i) {
                dataJson = dataJsonArray.getJSONObject(i);
                qrList.add(dataJson.getString("qrKey") + "_" + dataJson.getString("taxNo"));
            }
            this.getInvokeParam().getInvokeActionMap().put("qrList", qrList);
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        InvoiceScanFacadeFactory.getLocalInstance(this.getCtx()).syncQrKeyReWrite(this.getInvokeParam().getInvokeActionMap());
    }

    @Override
    public String getPwyCzlx() {
        return "fpy002";
    }

    @Override
    protected void verify() throws EASBizException, BOSException {
    }
}

