/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolDownloadInvoiceHelper;
import com.kingdee.eas.tm.im.IIncomeInvoice;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransOperTypeEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceWebPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IncomeInvoiceCheckInvoicePwyService
extends IncomeInvoiceWebPwyService {
    public IncomeInvoiceCheckInvoicePwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    @Override
    public String getPwyCzlx() {
        return "9008";
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        PwyInvokeParam invokeParam = this.getInvokeParam().getBeforeInvokeParam().get("9004");
        if (invokeParam != null && invokeParam.isSuccess()) {
            this.getInvokeParam().setToken(invokeParam.getToken());
        }
        return this.getInvokeParam().getParams();
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = super.createPwyLog();
        pwyLog.setOperType(TransOperTypeEnum.incomeinvoice);
        if (this.getInvokeParam().getParams() != null) {
            String number = (String)this.getInvokeParam().getParams().get("number");
            String invoiceNumber = (String)this.getInvokeParam().getParams().get("invoiceNo");
            String invoiceCode = (String)this.getInvokeParam().getParams().get("invoiceCode");
            pwyLog.setInvoiceNumber(number);
            pwyLog.setInvoiceNum(invoiceNumber);
            pwyLog.setInvoiceCode(invoiceCode);
        }
        return pwyLog;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        params.put("billid", this.getInvokeParam().getBillId());
        params.put("parserClass", "com.kingdee.eas.tm.im.common.comm.msg.parser.CheckInvoiceParser");
        HashMap<String, IObjectValue> retValue = null;
        if (IncomeInvoicePwyHelper.isPoolCheck(this.getInvokeParam().getParams())) {
            DownloadInvoiceParams downloadParams = new DownloadInvoiceParams(DownloadInvoiceType.CHECK);
            downloadParams.setCompanyId(this.getInvokeParam().getOrgId());
            IObjectValue value = PoolDownloadInvoiceHelper.parseCheckInvoice((Context)this.getCtx(), (String)this.getInvokeParam().getRevMsg(), (DownloadInvoiceParams)downloadParams);
            retValue = new HashMap<String, IObjectValue>();
            retValue.put("model", value);
            this.getInvokeParam().setInvokeActionMap(retValue);
        } else {
            IIncomeInvoice iIncomeInvoice = BizInterfaceFactory.getIncomeInvoice(this.getCtx());
            retValue = iIncomeInvoice.downLoadInvoice(params);
            IObjectCollection col = (IObjectCollection)retValue.get("invoiceColl");
            if (col != null && col.size() != 0) {
                IncomeInvoiceInfo info = (IncomeInvoiceInfo)col.getObject(0);
                iIncomeInvoice.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
            }
            this.getInvokeParam().setInvokeActionMap(retValue);
        }
    }
}

