/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.incomeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.IncomeInvoiceBatchPwyService;
import com.kingdee.eas.tm.im.common.comm.service.incomeinvoice.InvoiceCheckConfirmPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvoiceCheckPwyServcie
extends IncomeInvoiceBatchPwyService {
    private InvoiceCheckConfirmPwyService invoiceCheckConfirmPwyService = null;

    public InvoiceCheckPwyServcie(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public InvoiceCheckPwyServcie(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getPwyData() {
        return IncomeInvoicePwyHelper.getInvoiceCheckPwyData(this.getInvokeParam().getValues(), this.getInvokeParam().getSetting());
    }

    @Override
    protected int getDefaultRetryTimes() {
        return 3;
    }

    @Override
    protected void resolveSuccess() {
        try {
            List invoices = this.getValues();
            this.getSuccessInvoices().clear();
            this.getSuccessInvoices().addAll(invoices);
        }
        catch (Exception e) {
            this.setReturn(this.getUnKownCode(), "InvoiceCheckPwyServcie JSON Parse ERROR!");
        }
    }

    @Override
    protected void resolvePartSuccess() {
        JSONObject retJson = null;
        try {
            List invoices = this.getValues();
            this.getSuccessInvoices().clear();
            this.getSuccessInvoices().addAll(invoices);
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            IncomeInvoiceInfo invoice = null;
            if ("5004".equals(retJson.get("errcode"))) {
                JSONArray failedList = retJson.getJSONArray("failed_list");
                for (int i = 0; i < failedList.length(); ++i) {
                    JSONObject filedObj = failedList.getJSONObject(i);
                    String invoice_code = filedObj.getString("invoice_code");
                    String invoice_num = filedObj.getString("invoice_num");
                    invoice = this.getInvoiceMap().get(invoice_num + "-" + invoice_code);
                    if (invoice == null) continue;
                    this.getFailInvoices().add(invoice);
                    this.getSuccessInvoices().remove(invoice);
                }
            }
        }
        catch (Exception e) {
            this.setReturn(this.getUnKownCode(), "JSON Parse ERROR!");
        }
    }

    @Override
    public String getPartSuccessCode() {
        return "5004";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        if (this.getSuccessInvoices().size() == 0) {
            return;
        }
        HashMap<String, List<IncomeInvoiceInfo>> retValue = new HashMap<String, List<IncomeInvoiceInfo>>();
        retValue.put("failInvoices", this.getFailInvoices());
        Map retMap = BizInterfaceFactory.getIncomeInvoiceReWriteFacade(this.getCtx()).checkConfirmReWrite(this.getSuccessInvoices(), this.getInvokeParam().getOrgId(), this.getInvokeParam().getParams());
        retMap.putAll(retValue);
        this.getInvokeParam().setInvokeActionMap(retMap);
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/easyconfirm";
    }

    public InvoiceCheckConfirmPwyService getInvoiceCheckConfirmPwyService() {
        return this.invoiceCheckConfirmPwyService;
    }

    public void setInvoiceCheckConfirmPwyService(InvoiceCheckConfirmPwyService invoiceCheckConfirmPwyService) {
        this.invoiceCheckConfirmPwyService = invoiceCheckConfirmPwyService;
    }

    @Override
    public String getPwyCzlx() {
        return "8003";
    }
}

