/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoiceWebPwyService;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class GetAuthCodePwyService
extends MakeInvoiceWebPwyService {
    public GetAuthCodePwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public GetAuthCodePwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/base/oauth/code";
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = this.getInvokeParam().getCompany();
        String taxNo = company.getTaxNumber();
        if (!StringUtils.isEmpty((String)taxNo)) {
            taxNo = taxNo.trim();
        }
        UserInfo userInfo = this.getCtx() == null ? SysContext.getSysContext().getCurrentUserInfo() : ContextUtil.getCurrentUserInfo((Context)this.getCtx());
        String userID = userInfo.getId().toString();
        return this.getPwyHelper().getAuthcodeSjd(this.getPwySetting(), userID, taxNo);
    }

    @Override
    public void resolveSuccess() {
        JSONObject resultJson = null;
        try {
            resultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            String errcode = resultJson.getString("errcode");
            if ("0000".equals(errcode)) {
                String authcode = resultJson.getString("auth_code");
                this.getInvokeParam().setAuthcode(authcode);
            }
        }
        catch (Exception e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    public String getPwyCzlx() {
        return "9009";
    }

    @Override
    protected boolean isNeedEncrypt() {
        return false;
    }

    @Override
    public boolean isNeedToken() {
        return false;
    }
}

