/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.MakeInvoiceDownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoiceBillQueryBaseService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MakeInvoiceBillQueryPwyService
extends MakeInvoiceBillQueryBaseService {
    private MakeInvoiceBillQueryPwyService nextService = null;
    private int totalPage = 0;
    private int currentPage = 0;

    public MakeInvoiceBillQueryPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public MakeInvoiceBillQueryPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        return this.getInvokeParam().getParams();
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/m7/bill/invoice/items/query";
    }

    @Override
    public String getPwyCzlx() {
        return "9001";
    }

    @Override
    protected void resolveSuccess() {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            if ("0000".equals(retJson.get("errcode"))) {
                this.totalPage = retJson.getInt("totalPage");
                this.currentPage = retJson.getInt("currentPage");
            }
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), "JSON parse ERROR");
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        Map retValue = BizInterfaceFactory.getMakeInvoiceReWriteFacade(this.getCtx()).billQueryDownload(params);
        this.getInvokeParam().setInvokeActionMap(retValue);
        ++this.currentPage;
        if (this.currentPage <= this.totalPage) {
            params = new HashMap();
            params.putAll(this.getInvokeParam().getParams());
            params.put("pageNo", this.currentPage);
            PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.getInvokeParam());
            invokeParam.setParams(params);
            invokeParam.setInit(true);
            this.nextService = (MakeInvoiceBillQueryPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
            this.nextService.invoke();
        }
    }

    public MakeInvoiceBillQueryPwyService getNextService() {
        return this.nextService;
    }

    public void setPwyService(MakeInvoiceBillQueryPwyService nextService) {
        this.nextService = nextService;
    }

    @Override
    public List getErrorList() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.isSuccess()) {
            errorList.add(this.getInvokeParam().getDescription());
        }
        for (MakeInvoiceBillQueryPwyService nextService = this.getNextService(); nextService != null; nextService = nextService.getNextService()) {
            if (nextService.isSuccess()) continue;
            errorList.add(nextService.getInvokeParam().getDescription());
        }
        return errorList;
    }

    @Override
    public Map getInvokeActionMap() {
        HashMap retValue = new HashMap();
        ArrayList<MakeInvoiceDownloadResult> resultList = new ArrayList<MakeInvoiceDownloadResult>();
        MakeInvoiceDownloadResult result = (MakeInvoiceDownloadResult)this.getInvokeParam().getInvokeActionMap().get(this.getInvokeParam().getOrgId());
        resultList.add(result);
        MakeInvoiceDownloadResult invokeResult = null;
        for (MakeInvoiceBillQueryPwyService nextService = this.getNextService(); nextService != null; nextService = nextService.getNextService()) {
            Map invokeActionMap = nextService.getInvokeParam().getInvokeActionMap();
            if (invokeActionMap == null) continue;
            invokeResult = (MakeInvoiceDownloadResult)invokeActionMap.get(this.getInvokeParam().getOrgId());
            resultList.add(invokeResult);
        }
        retValue.put("result", resultList);
        return retValue;
    }
}

