/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.ElectricPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MakeInvoiceElectricClientPwyService
extends ElectricPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoiceElectricClientPwyService");

    public MakeInvoiceElectricClientPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public MakeInvoiceElectricClientPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getPwySjd() throws BOSException {
        return this.getPwyHelper().getSjd4ClientEleInvoice(this.getInvoice(), this.getCtx());
    }

    @Override
    public String getPwyCzlx() {
        return "110";
    }

    @Override
    protected int getDefaultRetryTimes() {
        return 3;
    }

    @Override
    public String getSuccessCode() {
        return "0000";
    }

    @Override
    public String getAuthcode() {
        return "";
    }

    @Override
    public String getTid() {
        if (this.getInvokeParam().getCompany() != null) {
            String taxNo = this.getInvokeParam().getCompany().getTaxNumber();
            if (!StringUtils.isEmpty((String)taxNo)) {
                taxNo = taxNo.trim();
            }
            return taxNo;
        }
        return "";
    }

    @Override
    protected void resolveSuccess() {
        try {
            JSONObject resultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONObject invoiceJson = resultJson.getJSONObject("data");
            this.getInvokeParam().getPwyLog().setInvoiceNum(invoiceJson.getString("invoicenum"));
            this.getInvokeParam().getPwyLog().setInvoiceCode(invoiceJson.getString("invoicecode"));
            if (resultJson.has("is_duplicate") && !resultJson.getBoolean("is_duplicate")) {
                JSONObject device = resultJson.getJSONObject("device_info");
                HashMap params = this.getInvokeParam().getParams();
                if (params == null) {
                    params = new HashMap();
                    this.getInvokeParam().setParams(params);
                }
                this.getInvokeParam().getParams().put("card_no", device.getString("card_no"));
                this.getInvokeParam().getParams().put("subid", device.getString("subid"));
                this.getInvokeParam().getParams().put("taxcode", device.getString("taxcode"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        try {
            JSONObject resultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONObject invoiceJson = resultJson.getJSONObject("data");
            String invoiceNo = invoiceJson.getString("invoicenum");
            String invoiceNum = invoiceJson.getString("invoicecode");
            String pdfurl = invoiceJson.getString("pdfurl");
            String sn = invoiceJson.getString("serialnum");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("invoiceNo", invoiceNo);
            param.put("invoiceNum", invoiceNum);
            param.put("pdfurl", pdfurl);
            param.put("sn", sn);
            if (this.getInvokeParam().getParams() != null) {
                param.put("card_no", (String)this.getInvokeParam().getParams().get("card_no"));
                param.put("subid", (String)this.getInvokeParam().getParams().get("subid"));
                param.put("taxcode", (String)this.getInvokeParam().getParams().get("taxcode"));
            }
            BizInterfaceFactory.getMakeInvoice(this.getCtx()).make((IObjectPK)new ObjectUuidPK(this.getInvoice().getId().toString()), param);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }
}

