/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.ElectricPwyService;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class MakeInvoiceElectricServerPwyService
extends ElectricPwyService {
    public MakeInvoiceElectricServerPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public MakeInvoiceElectricServerPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        MakeInvoiceInfo info = this.getInvoice();
        if (info.isIsRedVoice()) {
            return this.getPwyHelper().getSjd4ServerRedEleInvoice(this.getCtx(), info);
        }
        return this.getPwyHelper().getSjd4ServerEleInvoice(this.getCtx(), info);
    }

    @Override
    protected int getDefaultRetryTimes() {
        return 3;
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/bill/hx/invoice/add";
    }

    @Override
    public String getPwyCzlx() {
        return "100";
    }

    @Override
    public String getSuccessCode() {
        return "0000";
    }

    @Override
    public String getAuthcode() {
        return "";
    }

    @Override
    public String getTid() {
        if (this.getInvokeParam().getCompany() != null) {
            String taxNo = this.getInvokeParam().getCompany().getTaxNumber();
            if (!StringUtils.isEmpty((String)taxNo)) {
                taxNo = taxNo.trim();
            }
            return taxNo;
        }
        return "";
    }

    @Override
    public String getPwyURL() throws EASBizException, BOSException {
        String url = super.getPwyURL();
        if (this.isNeedToken() && this.getInvokeParam().getToken() != null) {
            url = url + "?access_token=" + this.getInvokeParam().getToken();
        }
        return url;
    }

    @Override
    public String getBaseURL() {
        return this.getInvokeParam().getSetting().getHttpAddress();
    }

    @Override
    protected boolean isNeedEncrypt() {
        return false;
    }

    @Override
    public boolean isNeedToken() {
        return false;
    }

    @Override
    protected void resolveSuccess() {
        try {
            JSONObject resultJson = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONObject invoiceJson = resultJson.getJSONObject("data");
            this.getInvokeParam().getPwyLog().setInvoiceNum(invoiceJson.getString("invoicenum"));
            this.getInvokeParam().getPwyLog().setInvoiceCode(invoiceJson.getString("invoicecode"));
        }
        catch (Exception e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        try {
            JSONObject value = new JSONObject(this.getInvokeParam().getRevMsg());
            JSONObject invoiceJson = value.getJSONObject("data");
            String invoiceNo = invoiceJson.getString("invoicenum");
            String invoiceNum = invoiceJson.getString("invoicecode");
            String pdfurl = invoiceJson.getString("pdfurl");
            String sn = invoiceJson.getString("serialnum");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("invoiceNo", invoiceNo);
            param.put("invoiceNum", invoiceNum);
            param.put("pdfurl", pdfurl);
            param.put("sn", sn);
            MakeInvoiceFactory.getLocalInstance(this.getCtx()).make((IObjectPK)new ObjectUuidPK(this.getInvoice().getId().toString()), param);
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    public Map getPwySjd() throws EASBizException, BOSException {
        return null;
    }
}

