/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.TaxCardVolumnInfo;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxCardSetVolumnPwyService
extends MakeInvoicePwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.makeinvoice.TaxCardSetVolumnPwyService");

    public TaxCardSetVolumnPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public TaxCardSetVolumnPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String client_id = "";
        String client_secret = "";
        Map sfrz = PwyHelper.getSfrz(client_id, client_secret);
        jsonMap.put("sfrz", sfrz);
        jsonMap.put("czlx", this.getPwyCzlx());
        Map pwySjd = this.getPwySjd();
        jsonMap.put("sjd", pwySjd);
        return jsonMap;
    }

    protected Map getPwySjd() {
        TaxCardVolumnInfo taxCardVolumnInfo = (TaxCardVolumnInfo)this.getInvokeParam().getParams().get("taxCardVolumnInfo");
        HashMap<String, String> pwySjd = new HashMap<String, String>();
        pwySjd.put("fpdm", taxCardVolumnInfo.getInvoice_code());
        pwySjd.put("fphm", taxCardVolumnInfo.getNext_invoice_num());
        pwySjd.put("kpzl", taxCardVolumnInfo.getInvoiceType().getValue());
        return pwySjd;
    }

    @Override
    public String getPwyCzlx() {
        return "23";
    }

    @Override
    public String getSuccessCode() {
        return "0";
    }

    @Override
    public String getBaseURL() throws EASBizException, BOSException {
        return this.getInvokeParam().getSetting().getHttpAddress();
    }

    @Override
    public PwySettingInfo getPwySetting() throws EASBizException, BOSException {
        PwySettingInfo setting = null;
        String pwyid = (String)this.getInvokeParam().getParams().get("pwyId");
        if (pwyid != null) {
            setting = BizInterfaceFactory.getPwySetting(this.getCtx()).getPwySettingInfo((IObjectPK)new ObjectUuidPK(pwyid));
        }
        return setting;
    }
}

