/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.makeinvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.CommUtil;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrException;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrInfo;
import com.kingdee.eas.tm.im.inv.OutputInvoiceType;
import com.kingdee.eas.tm.im.inv.TaxCopyStatus;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxCardSocketPwyService
extends MakeInvoicePwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.makeinvoice.TaxCardSocketPwyService");

    public TaxCardSocketPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public TaxCardSocketPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws BOSException, EASBizException {
        super.buildPwyParam(isWriteLog);
        this.getInvokeParam().setUrl(this.getPwyURL());
        this.getInvokeParam().getPwyLog().setUrl(this.getInvokeParam().getUrl());
    }

    protected boolean isUpdateInvoiceInvMgr() {
        boolean isUpdateInvoiceInvMgr = true;
        Map params = this.getInvokeParam().getParams();
        if (params != null) {
            Object value = params.get("isUpdateInvoiceInvMgr");
            isUpdateInvoiceInvMgr = value == null ? true : Boolean.parseBoolean(value.toString());
        }
        return isUpdateInvoiceInvMgr;
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        String client_id = "";
        String client_secret = "";
        Map sfrz = PwyHelper.getSfrz(client_id, client_secret);
        jsonMap.put("sfrz", sfrz);
        jsonMap.put("czlx", this.getPwyCzlx());
        return jsonMap;
    }

    @Override
    public String getPwyCzlx() {
        return "7";
    }

    @Override
    public String getSuccessCode() {
        return "0";
    }

    @Override
    public String getBaseURL() throws EASBizException, BOSException {
        if (this.isUpdateInvoiceInvMgr()) {
            InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)this.getInvokeParam().getValues().get(0);
            String httpAddress = info.getTaxPlate().getHttpAddress();
            if (StringUtils.isEmpty((String)httpAddress)) {
                throw new InvoiceInvMgrException(InvoiceInvMgrException.INVOICEINVMGRSYCHERROR1);
            }
            return httpAddress;
        }
        return this.getInvokeParam().getSetting().getHttpAddress();
    }

    @Override
    protected int getSendMode() {
        if (this.isWssUrl() || 2 == this.getRequestMode()) {
            return 2;
        }
        if (this.getInvokeParam().getMsgSettingInfo() != null && this.getInvokeParam().getMsgSettingInfo().getSendMode() != null) {
            return this.getInvokeParam().getMsgSettingInfo().getSendMode().getValue();
        }
        return 1;
    }

    protected boolean isWssUrl() {
        boolean isWssUrl = false;
        List values = this.getInvokeParam().getValues();
        if (values != null && values.size() > 0) {
            InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)this.getInvokeParam().getValues().get(0);
            if (this.getInvokeParam().getCommSettingInfo() != null && info.getTaxPlate() != null) {
                isWssUrl = CommUtil.isWssUrl(info.getTaxPlate().getHttpAddress(), this.getInvokeParam().getCommSettingInfo().getPwySocketURL());
            }
        }
        return isWssUrl;
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        if (!this.isUpdateInvoiceInvMgr()) {
            return null;
        }
        String billId = this.getInvokeParam().getBillId();
        HashMap<String, String> params = this.getInvokeParam().getParams();
        if (params == null) {
            params = new HashMap<String, String>();
            this.getInvokeParam().setParams(params);
        }
        ArrayList<InvoiceInvMgrInfo> invMgrList = null;
        if (!StringUtils.isEmpty((String)billId)) {
            String[] invoiceArr = billId.split(",");
            HashSet<String> invoiceSet = new HashSet<String>(Arrays.asList(invoiceArr));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invoiceSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(InvoiceInvMgrInfo.getPlateInfoSelector());
            invMgrList = new ArrayList<InvoiceInvMgrInfo>();
            InvoiceInvMgrCollection invoiceColl = BizInterfaceFactory.getInvoiceInvMgr(this.getCtx()).getInvoiceInvMgrCollection(view);
            InvoiceInvMgrInfo info = null;
            for (int i = 0; i < invoiceColl.size(); ++i) {
                info = invoiceColl.get(i);
                invMgrList.add(info);
                params.put("number", info.getNumber());
            }
        }
        return invMgrList;
    }

    @Override
    public PwySettingInfo getPwySetting() throws EASBizException, BOSException {
        String pwyid;
        PwySettingInfo setting = null;
        if (!this.isUpdateInvoiceInvMgr() && (pwyid = (String)this.getInvokeParam().getParams().get("pwyId")) != null) {
            setting = BizInterfaceFactory.getPwySetting(this.getCtx()).getPwySettingInfo((IObjectPK)new ObjectUuidPK(pwyid));
        }
        return setting;
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        if (!this.isUpdateInvoiceInvMgr()) {
            return;
        }
        String revMsg = this.getInvokeParam().getRevMsg();
        try {
            InvoiceInvMgrInfo info = (InvoiceInvMgrInfo)this.getValues().get(0);
            JSONObject dataJson = new JSONObject(revMsg);
            String errcode = dataJson.getString("errcode");
            if (this.getSuccessCode().equals(errcode)) {
                JSONArray elec_special_volumn;
                JSONArray special_papery_volumn;
                JSONArray roll_volumn;
                JSONArray normal_papery_volumn;
                JSONObject typeInfo;
                InvoiceInvMgrEntryInfo entry;
                int i;
                JSONArray elec_volumn;
                JSONObject sjd = dataJson.getJSONObject("sjd");
                info.setEnterpriseName(sjd.getString("qymc"));
                info.setTaxNumber(sjd.getString("qynsrsbh"));
                info.setTaxCopy(TaxCopyStatus.getEnum(sjd.getString("csbz")));
                String[] str1 = sjd.getString("jsph").split("-");
                String[] str2 = info.getTaxPlate().getPlateNo().split("-");
                String jsph1 = str1.length > 1 ? str1[1] : str1[0];
                String jsph = str2.length > 1 ? str2[1] : str2[0];
                String jspjh = sjd.getString("jspjh");
                if (!jsph1.equals(jsph) || !jspjh.equals(info.getTaxPlate().getExtensionNo())) {
                    this.getInvokeParam().getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
                    this.updatePwyLog();
                    throw new InvoiceInvMgrException(InvoiceInvMgrException.INVOICEINVMGRSYCHERROR2);
                }
                InvoiceInvMgrEntryCollection entries = info.getEntry();
                entries.clear();
                if (sjd.has("elec_volumn") && (elec_volumn = sjd.getJSONArray("elec_volumn")) != null && elec_volumn.length() > 0) {
                    for (i = 0; i < elec_volumn.length(); ++i) {
                        entry = new InvoiceInvMgrEntryInfo();
                        typeInfo = (JSONObject)elec_volumn.get(i);
                        entry.setInvoiceType(OutputInvoiceType.OUPPUT_ELECTRONIC);
                        this.parseJson(entries, entry, typeInfo);
                    }
                }
                if (sjd.has("normal_papery_volumn") && (normal_papery_volumn = sjd.getJSONArray("normal_papery_volumn")) != null && normal_papery_volumn.length() > 0) {
                    for (i = 0; i < normal_papery_volumn.length(); ++i) {
                        entry = new InvoiceInvMgrEntryInfo();
                        typeInfo = (JSONObject)normal_papery_volumn.get(i);
                        entry.setInvoiceType(OutputInvoiceType.OUTPUT_COMMON);
                        this.parseJson(entries, entry, typeInfo);
                    }
                }
                if (sjd.has("roll_volumn") && (roll_volumn = sjd.getJSONArray("roll_volumn")) != null && roll_volumn.length() > 0) {
                    for (i = 0; i < roll_volumn.length(); ++i) {
                        entry = new InvoiceInvMgrEntryInfo();
                        typeInfo = (JSONObject)roll_volumn.get(i);
                        entry.setInvoiceType(OutputInvoiceType.OUTPUT_COIL);
                        this.parseJson(entries, entry, typeInfo);
                    }
                }
                if (sjd.has("special_papery_volumn") && (special_papery_volumn = sjd.getJSONArray("special_papery_volumn")) != null && special_papery_volumn.length() > 0) {
                    for (i = 0; i < special_papery_volumn.length(); ++i) {
                        entry = new InvoiceInvMgrEntryInfo();
                        typeInfo = (JSONObject)special_papery_volumn.get(i);
                        entry.setInvoiceType(OutputInvoiceType.OUTPUT_SPECIAL);
                        this.parseJson(entries, entry, typeInfo);
                    }
                }
                if (sjd.has("elec_special_volumn") && (elec_special_volumn = sjd.getJSONArray("elec_special_volumn")) != null && elec_special_volumn.length() > 0) {
                    for (i = 0; i < elec_special_volumn.length(); ++i) {
                        entry = new InvoiceInvMgrEntryInfo();
                        typeInfo = (JSONObject)elec_special_volumn.get(i);
                        entry.setInvoiceType(OutputInvoiceType.OUTPUT_ELECTRONICSPECIAL);
                        this.parseJson(entries, entry, typeInfo);
                    }
                }
                BizInterfaceFactory.getInvoiceInvMgr(this.getCtx()).save((CoreBaseInfo)info);
            }
        }
        catch (JSONException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void parseJson(InvoiceInvMgrEntryCollection entries, InvoiceInvMgrEntryInfo entry, JSONObject typeInfo) throws JSONException {
        try {
            NumberFormat numberFormat = IMUtils.getInvoiceNumberFmt();
            entry.setInvoiceCode(typeInfo.getString("invoice_code"));
            String firstNumber = typeInfo.getString("invoice_num");
            int first = Integer.valueOf(firstNumber);
            int remainderQty = typeInfo.getInt("remainder");
            int qty = typeInfo.getInt("amount");
            int last = first + qty - 1;
            int next = last - remainderQty + 1;
            entry.setQuantity(qty);
            entry.setFirstNumber(numberFormat.format(first));
            entry.setLastNumber(numberFormat.format(last));
            entry.setNextNumber(numberFormat.format(next));
            entry.setRemainderQty(remainderQty);
            entry.setUsedQty(qty - remainderQty);
            entry.setPurchasePerson(typeInfo.getString("purchase_person"));
            String date = typeInfo.getString("purchase_date");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (!date.isEmpty()) {
                entry.setPurchaseDate(sdf.parse(date));
            }
            entries.add(entry);
        }
        catch (ParseException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

