/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.model.ResqMsg;
import com.kingdee.eas.tm.im.common.comm.service.pool.CheckServicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PoolPwyHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CSCheckPwyService
extends CheckServicePwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.pool.CSCheckPwyService");

    public CSCheckPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public CSCheckPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getBodyData() {
        Map params = this.getInvokeParam().getParams();
        if (this.checkAbsList == null) {
            this.checkAbsList = new ArrayList();
            ArrayList reCheckAbsList = (ArrayList)params.get("checkAbsList");
            if (reCheckAbsList != null) {
                CheckAbsInfo checkInfo = null;
                Iterator it = reCheckAbsList.iterator();
                while (it.hasNext()) {
                    try {
                        checkInfo = (CheckAbsInfo)JSONUtils.convertJsonToObject((Context)this.getCtx(), (String)JSONUtils.convertObjectToJson((Context)this.getCtx(), (Object)((Map)it.next())), CheckAbsInfo.class);
                        this.checkAbsList.add(checkInfo);
                    }
                    catch (BOSException e) {
                        this.setReturn(this.getUnKownCode(), "CheckAbsInfo JSON Parse ERROR!");
                    }
                }
            }
        }
        if (this.getInvokeParam().getSetting().isFpdkType()) {
            String taxNo = (String)params.get("taxNo");
            params.put("taxNo", taxNo);
            return PoolPwyHelper.getFpdkCSCheckPwyData(this.checkAbsList, params);
        }
        return PoolPwyHelper.getCSCheckPwyData(this.checkAbsList, params);
    }

    @Override
    protected void resolvePartSuccess() {
        try {
            JSONObject retJson = null;
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            CheckAbsInfo invoice = null;
            JSONObject data = retJson.getJSONObject("data");
            JSONArray failedList = data.getJSONArray("fail");
            for (int i = 0; i < failedList.length(); ++i) {
                JSONObject filedObj = failedList.getJSONObject(i);
                String invoice_code = filedObj.getString("invoiceCode");
                String invoice_num = filedObj.getString("invoiceNo");
                invoice = StringUtils.isEmpty((String)invoice_code) ? (CheckAbsInfo)this.invoiceMap.get("-" + invoice_num) : (CheckAbsInfo)this.invoiceMap.get(invoice_code + "-" + invoice_num);
                if (invoice == null) continue;
                this.failList.add(invoice);
                this.successList.remove(invoice);
            }
        }
        catch (Exception e) {
            this.setReturn(this.getUnKownCode(), "CSCheckPwyService JSON Parse ERROR!");
        }
    }

    @Override
    public String getPartSuccessCode() {
        return "90001";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        if (this.successList.size() == 0) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", this.getInvokeParam().getOrgId());
        params.put("successList", this.successList);
        params.put("failList", this.failList);
        params.putAll(this.getInvokeParam().getParams());
        Map retMap = BizInterfaceFactory.getCheckServiceFacade(this.getCtx()).checkReWrite(params);
        retMap.putAll(params);
        this.getInvokeParam().setInvokeActionMap(retMap);
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/fpdk/dkgx/gxInvoices";
    }

    @Override
    public String getPwyCzlx() {
        if (this.getInvokeParam().getSetting().isFpdkType()) {
            return "KP0003";
        }
        if ("-4".equals(this.deductibleMode) || "4".equals(this.deductibleMode)) {
            return "PS1911";
        }
        return "PS1902";
    }

    @Override
    public void invokeAfter() {
        if (this.successList.size() == 0 && this.failList.size() == 0) {
            Map params = this.getInvokeParam().getParams();
            if (params.containsKey("isUndo")) {
                this.isUndo = (Boolean)params.get("isUndo");
            }
            this.checkAbsList = (ArrayList)params.get("checkAbsList");
            if (this.checkAbsList != null) {
                CheckAbsInfo checkInfo = null;
                Object value = null;
                Iterator it = this.checkAbsList.iterator();
                while (it.hasNext()) {
                    try {
                        value = it.next();
                        checkInfo = value instanceof CheckAbsInfo ? (CheckAbsInfo)value : (value instanceof Map ? (CheckAbsInfo)JSONUtils.convertJsonToObject((Context)this.getCtx(), (String)JSONUtils.convertObjectToJson((Context)this.getCtx(), (Object)value), CheckAbsInfo.class) : new CheckAbsInfo());
                        this.successList.add(checkInfo);
                        if (StringUtils.isEmpty((String)checkInfo.getInvoiceCode())) {
                            this.invoiceMap.put("-" + checkInfo.getInvoiceNo(), checkInfo);
                            continue;
                        }
                        this.invoiceMap.put(checkInfo.getInvoiceCode() + "-" + checkInfo.getInvoiceNo(), checkInfo);
                    }
                    catch (BOSException e) {
                        this.setReturn(this.getUnKownCode(), "CheckAbsInfo JSON Parse ERROR!");
                    }
                }
            }
        }
        super.invokeAfter();
    }

    @Override
    protected void resolveResp(ResqMsg msg) {
        super.resolveResp(msg);
        String result = msg.getRevMsg();
        boolean isSpecial = false;
        if (!StringUtils.isEmpty((String)result)) {
            try {
                JSONObject retJson = new JSONObject(result);
                StringBuffer descriptionSB = new StringBuffer();
                if (retJson.has("data") && !"null".equals(retJson.getString("data"))) {
                    JSONObject data = new JSONObject(retJson.getString("data"));
                    if (data.has("fail")) {
                        JSONArray fail = new JSONArray(data.getString("fail"));
                        JSONObject failObject = null;
                        CheckAbsInfo invoice = null;
                        int j = fail.length();
                        for (int i = 0; i < j; ++i) {
                            failObject = (JSONObject)fail.get(i);
                            if (failObject.has("description")) {
                                if (StringUtils.isEmpty((String)failObject.getString("invoiceCode"))) {
                                    descriptionSB.append(failObject.getString("invoiceNo") + ":" + failObject.getString("description") + ";\r\n");
                                } else {
                                    descriptionSB.append(failObject.getString("invoiceCode") + "_" + failObject.getString("invoiceNo") + ":" + failObject.getString("description") + ";\r\n");
                                }
                            } else if (StringUtils.isEmpty((String)failObject.getString("invoiceCode"))) {
                                descriptionSB.append(failObject.getString("invoiceNo") + ";\r\n");
                            } else {
                                descriptionSB.append(failObject.getString("invoiceCode") + "_" + failObject.getString("invoiceNo") + ";\r\n");
                            }
                            String invoice_code = failObject.getString("invoiceCode");
                            String invoice_num = failObject.getString("invoiceNo");
                            invoice = StringUtils.isEmpty((String)invoice_code) ? (CheckAbsInfo)this.invoiceMap.get("-" + invoice_num) : (CheckAbsInfo)this.invoiceMap.get(invoice_code + "-" + invoice_num);
                            if (invoice == null) continue;
                            if (!this.failList.contains(invoice)) {
                                this.failList.add(invoice);
                            }
                            this.successList.remove(invoice);
                        }
                        if (descriptionSB.length() > 0) {
                            msg.setDescription(descriptionSB.toString());
                            this.getInvokeParam().setDescription(msg.getDescription());
                        }
                    } else {
                        isSpecial = true;
                    }
                } else {
                    isSpecial = true;
                }
                if (isSpecial) {
                    this.failList = new ArrayList(this.successList);
                    this.successList.clear();
                    descriptionSB.append(this.getInvokeParam().getDescription() + "\r\n");
                    for (int i = 0; i < this.failList.size(); ++i) {
                        CheckAbsInfo checkAbsInfo = (CheckAbsInfo)this.failList.get(i);
                        if (StringUtils.isEmpty((String)checkAbsInfo.getInvoiceCode())) {
                            descriptionSB.append(IMUtils.getAllResource("com.kingdee.eas.tm.im.ps.PoolServiceResource", "Msg_InvoiceForFullElec", this.getCtx(), new Object[]{checkAbsInfo.getInvoiceNo()}) + "\r\n");
                            continue;
                        }
                        descriptionSB.append(IMUtils.getAllResource("com.kingdee.eas.tm.im.ps.PoolServiceResource", "Msg_Invoice", this.getCtx(), new Object[]{checkAbsInfo.getInvoiceCode(), checkAbsInfo.getInvoiceNo()}));
                    }
                    this.getInvokeParam().setDescription(descriptionSB.toString());
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u3010resolveResp\u3011" + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    protected boolean isNeedEncrypt() {
        return this.getInvokeParam().getSetting().isFpdkType();
    }
}

