/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.CheckAbsInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolDiskPwyService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CheckServicePwyService
extends PoolDiskPwyService {
    protected boolean isUndo = false;
    protected String deductibleMode = null;
    protected List<CheckAbsInfo> checkAbsList;
    protected List<CheckAbsInfo> successList = new ArrayList<CheckAbsInfo>();
    protected List<CheckAbsInfo> failList = new ArrayList<CheckAbsInfo>();
    protected Map<String, CheckAbsInfo> invoiceMap = new HashMap<String, CheckAbsInfo>();
    protected String requestId = null;

    public CheckServicePwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public CheckServicePwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public void buildPwyParam(boolean isWriteLog) throws EASBizException, BOSException {
        Map params = this.getInvokeParam().getParams();
        if (params.containsKey("isUndo")) {
            this.isUndo = (Boolean)params.get("isUndo");
        }
        if (params.containsKey("requestId")) {
            this.requestId = (String)params.get("requestId");
        }
        if (params.containsKey("deductibleMode")) {
            this.deductibleMode = (String)params.get("deductibleMode");
        }
        this.checkAbsList = (ArrayList)params.get("checkAbsList");
        if (this.checkAbsList != null) {
            this.successList.addAll(this.checkAbsList);
            CheckAbsInfo checkInfo2 = null;
            for (CheckAbsInfo checkInfo2 : this.checkAbsList) {
                if (checkInfo2.getInvoiceCode() == null) {
                    this.invoiceMap.put("-" + checkInfo2.getInvoiceNo(), checkInfo2);
                    continue;
                }
                this.invoiceMap.put(checkInfo2.getInvoiceCode() + "-" + checkInfo2.getInvoiceNo(), checkInfo2);
            }
        }
        super.buildPwyParam(isWriteLog);
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        return this.checkAbsList;
    }

    public List<CheckAbsInfo> getSuccessList() {
        return this.successList;
    }

    public List<CheckAbsInfo> getFailList() {
        return this.failList;
    }
}

