/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolDiskPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiskDownloadPwyService
extends PoolDiskPwyService {
    private String serialNo = EMPTYSTR;
    private int nextDataFromIndex = 0;
    private String nextDataIndex = EMPTYSTR;
    private boolean endFlag = false;
    private DiskDownloadPwyService nextService = null;

    public DiskDownloadPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public DiskDownloadPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected void resolveSuccess() {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            if ("0000".equals(retJson.get("errcode"))) {
                this.serialNo = retJson.getString("serialNo");
                this.nextDataFromIndex = retJson.getInt("nextDataFromIndex");
                this.nextDataIndex = retJson.getString("nextDataIndex");
                this.endFlag = retJson.getBoolean("endFlag");
            }
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        return null;
    }

    @Override
    protected Map getBodyData() throws EASBizException, BOSException {
        return (Map)this.getInvokeParam().getParams().get("pwyData");
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(this.getInvokeParam().getParams());
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        params.put("parserClass", "com.kingdee.eas.tm.im.common.comm.msg.parser.DiskDownloadParser");
        Map retValue = BizInterfaceFactory.getIncomeInvoiceReWriteFacade(this.getCtx()).billQueryDownload(params);
        this.getInvokeParam().setInvokeActionMap(retValue);
        if (!this.endFlag && this.getInvokeParam().getPwyLog().getLogStatus() != LogStatusEnum.FAILURE) {
            HashMap<String, Object> pwyDataMap = new HashMap<String, Object>();
            pwyDataMap.putAll(this.getPwyData());
            HashMap paramOpt = new HashMap();
            paramOpt.putAll((Map)this.getPwyData().get("searchOpt"));
            pwyDataMap.put("searchOpt", paramOpt);
            pwyDataMap.put("serialNo", this.serialNo);
            pwyDataMap.put("dataFromIndex", this.nextDataFromIndex);
            pwyDataMap.put("dataIndex", this.nextDataIndex);
            HashMap<String, Map> newParams = new HashMap<String, Map>();
            newParams.putAll(this.getInvokeParam().getParams());
            newParams.put("pwyData", pwyDataMap);
            newParams.put("totalMap", retValue);
            PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.getInvokeParam());
            invokeParam.setParams(newParams);
            invokeParam.setInit(true);
            this.nextService = (DiskDownloadPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
            this.nextService.invoke();
            if (this.nextService.isSuccess()) {
                this.getInvokeParam().setInvokeActionMap(this.nextService.getInvokeParam().getInvokeActionMap());
            }
        }
    }

    @Override
    public String getPwyCzlx() {
        return "PS1901";
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/fpdk/queryinvoice";
    }
}

