/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class PoolDiskPwyService
extends PoolPwyService {
    public PoolDiskPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public PoolDiskPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected Map getPwyData() throws EASBizException, BOSException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("request_path", this.getInterfacePath());
        Map body = this.getBodyData();
        if (body != null) {
            data.putAll(body);
        }
        return data;
    }

    protected abstract Map getBodyData() throws EASBizException, BOSException;

    @Override
    public String getBaseURL() {
        if (this.getInvokeParam().getSetting().isFpdkType()) {
            return PwyServiceHelper.getBaseUrl(this.getInvokeParam().getCommSettingInfo());
        }
        return this.getInvokeParam().getSetting().getHttpAddress();
    }

    @Override
    public String getPwyURL() throws EASBizException, BOSException {
        String url = null;
        if (this.getInvokeParam().getSetting().isFpdkType()) {
            url = super.getPwyURL();
            if (this.isNeedToken() && !StringUtils.isEmpty((String)this.getInvokeParam().getToken())) {
                url = url + "?access_token=" + this.getInvokeParam().getToken();
                url = url + "&fpdk_type=2";
            }
        } else {
            if (this.getInvokeParam().isWssUrl() || 2 == this.getRequestMode()) {
                return this.getInvokeParam().getSetting().getHttpAddress();
            }
            url = super.getPwyURL();
            if (this.isNeedToken() && !StringUtils.isEmpty((String)this.getInvokeParam().getToken())) {
                url = url + "?access_token=" + this.getInvokeParam().getToken();
                url = url + "&fpdk_type=1";
            }
        }
        return url;
    }

    @Override
    public boolean isNeedToken() {
        return this.getInvokeParam().getSetting().isFpdkType();
    }

    @Override
    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = super.createPwyLog();
        if (!StringUtils.isEmpty((String)this.getPwyCzlx())) {
            pwyLog.setLogType(PwyServiceType.getEnum(this.getPwyCzlx()));
        } else {
            pwyLog.setLogType(PwyServiceType.getEnum(this.getInvokeParam().getMsgType()));
        }
        return pwyLog;
    }
}

