/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransOperTypeEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.AbstractPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.util.IMUtils;

public abstract class PoolPwyService
extends AbstractPwyService {
    protected static String EMPTYSTR = "";

    public PoolPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public PoolPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = super.createPwyLog();
        pwyLog.setOperType(TransOperTypeEnum.incomeinvoice);
        return pwyLog;
    }

    @Override
    protected PwySettingInfo getPwySetting() throws BOSException, EASBizException {
        PwySettingInfo pwyInfo;
        String orgid = this.getInvokeParam().getOrgId();
        FullOrgUnitInfo company = FullOrgUnitFactory.getLocalInstance((Context)this.getCtx()).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        if (company.isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo org = BizInterfaceFactory.getCompanyOrgUnit(this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
            this.getInvokeParam().setCompany(org);
        }
        if ((pwyInfo = (PwySettingInfo)BizInterfaceFactory.getPwySetting(this.getCtx()).getPwySetting(orgid, OPTypeEnum.RecInvoice, null, null)) == null) {
            this.setReturn(this.getUnKownCode(), company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0]));
            throw new IMException(IMException.ERRORMSG, new Object[]{company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0])});
        }
        return pwyInfo;
    }

    @Override
    public boolean isNeedToken() {
        return false;
    }

    @Override
    public String getSuccessCode() {
        return "0000";
    }

    @Override
    protected PwyServiceType getTokenMsgType() {
        return PwyServiceType.OPR_WEB_GETTOKEN_INCOMEINV;
    }
}

